/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.frames;

import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProviderFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriterFactory;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeNSMInteriorFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreePolicyType;

public class RTreeNSMInteriorFrameFactory
implements ITreeIndexFrameFactory {
    private static final long serialVersionUID = 1L;
    private final ITreeIndexTupleWriterFactory tupleWriterFactory;
    private final IPrimitiveValueProviderFactory[] keyValueProviderFactories;
    private final RTreePolicyType rtreePolicyType;

    public RTreeNSMInteriorFrameFactory(ITreeIndexTupleWriterFactory tupleWriterFactory, IPrimitiveValueProviderFactory[] keyValueProviderFactories, RTreePolicyType rtreePolicyType) {
        this.tupleWriterFactory = tupleWriterFactory;
        if (keyValueProviderFactories.length % 2 != 0) {
            throw new IllegalArgumentException("The key has different number of dimensions.");
        }
        this.keyValueProviderFactories = keyValueProviderFactories;
        this.rtreePolicyType = rtreePolicyType;
    }

    public IRTreeInteriorFrame createFrame() {
        IPrimitiveValueProvider[] keyValueProviders = new IPrimitiveValueProvider[this.keyValueProviderFactories.length];
        for (int i = 0; i < keyValueProviders.length; ++i) {
            keyValueProviders[i] = this.keyValueProviderFactories[i].createPrimitiveValueProvider();
        }
        return new RTreeNSMInteriorFrame(this.tupleWriterFactory.createTupleWriter(), keyValueProviders, this.rtreePolicyType);
    }

    public ITreeIndexTupleWriterFactory getTupleWriterFactory() {
        return this.tupleWriterFactory;
    }
}

