/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.frames;

import edu.uci.ics.hyracks.api.dataflow.value.IBinaryComparator;
import edu.uci.ics.hyracks.data.std.accessors.PointableBinaryComparatorFactory;
import edu.uci.ics.hyracks.data.std.api.IPointableFactory;
import edu.uci.ics.hyracks.data.std.primitive.IntegerPointable;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.dataflow.common.data.marshalling.IntegerSerializerDeserializer;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.api.TreeIndexException;
import edu.uci.ics.hyracks.storage.am.common.frames.FrameOpSpaceStatus;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.SlotOffTupleOff;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeInteriorFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeComputationUtils;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreeNSMFrame;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreePolicyType;
import edu.uci.ics.hyracks.storage.am.rtree.impls.PathList;
import java.util.ArrayList;
import java.util.Collections;

public class RTreeNSMInteriorFrame
extends RTreeNSMFrame
implements IRTreeInteriorFrame {
    private static final int childPtrSize = 4;
    private IBinaryComparator childPtrCmp = PointableBinaryComparatorFactory.of((IPointableFactory)IntegerPointable.FACTORY).createBinaryComparator();
    private final int keyFieldCount;

    public RTreeNSMInteriorFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType) {
        super(tupleWriter, keyValueProviders, rtreePolicyType);
        this.keyFieldCount = keyValueProviders.length;
        this.frameTuple.setFieldCount(this.keyFieldCount);
    }

    public int getBytesRequriedToWriteTuple(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + 4 + this.slotManager.getSlotSize();
    }

    @Override
    public int findBestChild(ITupleReference tuple, MultiComparator cmp) {
        int bestChild = this.rtreePolicy.findBestChildPosition(this, tuple, this.frameTuple, cmp);
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, bestChild);
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public boolean checkIfEnlarementIsNeeded(ITupleReference tuple, MultiComparator cmp) {
        return !RTreeComputationUtils.containsRegion((ITupleReference)this.frameTuple, tuple, cmp, this.keyValueProviders);
    }

    public ITreeIndexTupleReference createTupleReference() {
        ITreeIndexTupleReference tuple = this.tupleWriter.createTupleReference();
        tuple.setFieldCount(this.keyFieldCount);
        return tuple;
    }

    @Override
    public int findTupleByPointer(ITupleReference tuple, MultiComparator cmp) {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        for (int i = 0; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            int c = this.pointerCmp((ITupleReference)this.frameTuple, tuple, cmp);
            if (c != 0) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getChildPageId(int tupleIndex) {
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public int getChildPageIdIfIntersect(ITupleReference tuple, int tupleIndex, MultiComparator cmp) {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, tupleIndex);
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j));
            if (c > 0) {
                return -1;
            }
            c = cmp.getComparators()[i].compare(tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i));
            if (c >= 0) continue;
            return -1;
        }
        return this.buf.getInt(this.getChildPointerOff((ITupleReference)this.frameTuple));
    }

    @Override
    public int findTupleByPointer(ITupleReference tuple, PathList traverseList, int parentIndex, MultiComparator cmp) {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        for (int i = 0; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            int c = this.pointerCmp((ITupleReference)this.frameTuple, tuple, cmp);
            if (c == 0) {
                return i;
            }
            int pageId = IntegerSerializerDeserializer.getInt((byte[])this.frameTuple.getFieldData(cmp.getKeyFieldCount() - 1), (int)this.getChildPointerOff((ITupleReference)this.frameTuple));
            traverseList.add(pageId, -1L, parentIndex);
        }
        return -1;
    }

    public boolean compact() {
        int i;
        this.resetSpaceParams();
        int tupleCount = this.buf.getInt(8);
        int freeSpace = this.buf.getInt(12);
        ArrayList<SlotOffTupleOff> sortedTupleOffs = new ArrayList<SlotOffTupleOff>();
        sortedTupleOffs.ensureCapacity(tupleCount);
        for (i = 0; i < tupleCount; ++i) {
            int slotOff = this.slotManager.getSlotOff(i);
            int tupleOff = this.slotManager.getTupleOff(slotOff);
            sortedTupleOffs.add(new SlotOffTupleOff(i, slotOff, tupleOff));
        }
        Collections.sort(sortedTupleOffs);
        for (i = 0; i < sortedTupleOffs.size(); ++i) {
            int tupleOff = ((SlotOffTupleOff)sortedTupleOffs.get((int)i)).tupleOff;
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            int tupleEndOff = this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1);
            int tupleLength = tupleEndOff - tupleOff + 4;
            System.arraycopy(this.buf.array(), tupleOff, this.buf.array(), freeSpace, tupleLength);
            this.slotManager.setSlot(((SlotOffTupleOff)sortedTupleOffs.get((int)i)).slotOff, freeSpace);
            freeSpace += tupleLength;
        }
        this.buf.putInt(12, freeSpace);
        this.buf.putInt(16, this.buf.capacity() - freeSpace - tupleCount * this.slotManager.getSlotSize());
        return false;
    }

    public FrameOpSpaceStatus hasSpaceInsert(ITupleReference tuple) {
        int bytesRequired = this.tupleWriter.bytesRequired(tuple) + 4;
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.capacity() - this.buf.getInt(12) - this.buf.getInt(8) * this.slotManager.getSlotSize()) {
            return FrameOpSpaceStatus.SUFFICIENT_CONTIGUOUS_SPACE;
        }
        if (bytesRequired + this.slotManager.getSlotSize() <= this.buf.getInt(16)) {
            return FrameOpSpaceStatus.SUFFICIENT_SPACE;
        }
        return FrameOpSpaceStatus.INSUFFICIENT_SPACE;
    }

    @Override
    public void adjustKey(ITupleReference tuple, int tupleIndex, MultiComparator cmp) throws TreeIndexException {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        if (tupleIndex == -1) {
            tupleIndex = this.findTupleByPointer(tuple, cmp);
        }
        if (tupleIndex == -1) {
            throw new TreeIndexException("Error: Faild to find a tuple in a page");
        }
        this.tupleWriter.writeTuple(tuple, this.buf.array(), this.getTupleOffset(tupleIndex));
    }

    protected int pointerCmp(ITupleReference tupleA, ITupleReference tupleB, MultiComparator cmp) {
        return this.childPtrCmp.compare(tupleA.getFieldData(cmp.getKeyFieldCount() - 1), this.getChildPointerOff(tupleA), 4, tupleB.getFieldData(cmp.getKeyFieldCount() - 1), this.getChildPointerOff(tupleB), 4);
    }

    @Override
    public int getTupleSize(ITupleReference tuple) {
        return this.tupleWriter.bytesRequired(tuple) + 4;
    }

    private int getChildPointerOff(ITupleReference tuple) {
        return tuple.getFieldStart(tuple.getFieldCount() - 1) + tuple.getFieldLength(tuple.getFieldCount() - 1);
    }

    public void insert(ITupleReference tuple, int tupleIndex) {
        this.frameTuple.setFieldCount(tuple.getFieldCount());
        this.slotManager.insertSlot(-1, this.buf.getInt(12));
        int freeSpace = this.buf.getInt(12);
        int bytesWritten = this.tupleWriter.writeTupleFields(tuple, 0, tuple.getFieldCount(), this.buf.array(), freeSpace);
        System.arraycopy(tuple.getFieldData(tuple.getFieldCount() - 1), this.getChildPointerOff(tuple), this.buf.array(), freeSpace + bytesWritten, 4);
        int tupleSize = bytesWritten + 4;
        this.buf.putInt(8, this.buf.getInt(8) + 1);
        this.buf.putInt(12, this.buf.getInt(12) + tupleSize);
        this.buf.putInt(16, this.buf.getInt(16) - tupleSize - this.slotManager.getSlotSize());
    }

    @Override
    public void delete(int tupleIndex, MultiComparator cmp) {
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int slotOff = this.slotManager.getSlotOff(tupleIndex);
        int tupleOff = this.slotManager.getTupleOff(slotOff);
        this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
        int tupleSize = this.tupleWriter.bytesRequired((ITupleReference)this.frameTuple);
        int slotStartOff = this.slotManager.getSlotEndOff();
        int length = slotOff - slotStartOff;
        System.arraycopy(this.buf.array(), slotStartOff, this.buf.array(), slotStartOff + this.slotManager.getSlotSize(), length);
        this.buf.putInt(8, this.buf.getInt(8) - 1);
        this.buf.putInt(16, this.buf.getInt(16) + tupleSize + 4 + this.slotManager.getSlotSize());
    }

    @Override
    public void enlarge(ITupleReference tuple, MultiComparator cmp) {
        int maxFieldPos = cmp.getKeyFieldCount() / 2;
        for (int i = 0; i < maxFieldPos; ++i) {
            int j = maxFieldPos + i;
            int c = cmp.getComparators()[i].compare(this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), this.frameTuple.getFieldLength(i), tuple.getFieldData(i), tuple.getFieldStart(i), tuple.getFieldLength(i));
            if (c > 0) {
                System.arraycopy(tuple.getFieldData(i), tuple.getFieldStart(i), this.frameTuple.getFieldData(i), this.frameTuple.getFieldStart(i), tuple.getFieldLength(i));
            }
            if ((c = cmp.getComparators()[j].compare(this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), this.frameTuple.getFieldLength(j), tuple.getFieldData(j), tuple.getFieldStart(j), tuple.getFieldLength(j))) >= 0) continue;
            System.arraycopy(tuple.getFieldData(j), tuple.getFieldStart(j), this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j), tuple.getFieldLength(j));
        }
    }

    public ArrayList<Integer> getChildren(MultiComparator cmp) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        this.frameTuple.setFieldCount(cmp.getKeyFieldCount());
        int tupleCount = this.buf.getInt(8);
        for (int i = 0; i < tupleCount; ++i) {
            int tupleOff = this.slotManager.getTupleOff(this.slotManager.getSlotOff(i));
            this.frameTuple.resetByTupleOffset(this.buf, tupleOff);
            int intVal = IntegerSerializerDeserializer.getInt((byte[])this.buf.array(), (int)(this.frameTuple.getFieldStart(this.frameTuple.getFieldCount() - 1) + this.frameTuple.getFieldLength(this.frameTuple.getFieldCount() - 1)));
            ret.add(intVal);
        }
        return ret;
    }

    @Override
    public int getFieldCount() {
        return this.keyValueProviders.length;
    }

    public int getChildPointerSize() {
        return 4;
    }
}

