/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.frames;

import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.IPrimitiveValueProvider;
import edu.uci.ics.hyracks.storage.am.common.api.ISlotManager;
import edu.uci.ics.hyracks.storage.am.common.api.ISplitKey;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexFrame;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndexTupleWriter;
import edu.uci.ics.hyracks.storage.am.common.frames.TreeIndexNSMFrame;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreeFrame;
import edu.uci.ics.hyracks.storage.am.rtree.api.IRTreePolicy;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RStarTreePolicy;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreePolicy;
import edu.uci.ics.hyracks.storage.am.rtree.frames.RTreePolicyType;
import edu.uci.ics.hyracks.storage.am.rtree.impls.UnorderedSlotManager;

public abstract class RTreeNSMFrame
extends TreeIndexNSMFrame
implements IRTreeFrame {
    protected static final int pageNsnOff = 22;
    protected static final int rightPageOff = 30;
    protected ITreeIndexTupleReference[] tuples;
    protected ITreeIndexTupleReference cmpFrameTuple;
    private static final double doubleEpsilon = RTreeNSMFrame.computeDoubleEpsilon();
    protected final IPrimitiveValueProvider[] keyValueProviders;
    protected IRTreePolicy rtreePolicy;

    public RTreeNSMFrame(ITreeIndexTupleWriter tupleWriter, IPrimitiveValueProvider[] keyValueProviders, RTreePolicyType rtreePolicyType) {
        super(tupleWriter, (ISlotManager)new UnorderedSlotManager());
        this.tuples = new ITreeIndexTupleReference[keyValueProviders.length];
        for (int i = 0; i < keyValueProviders.length; ++i) {
            this.tuples[i] = tupleWriter.createTupleReference();
        }
        this.cmpFrameTuple = tupleWriter.createTupleReference();
        this.keyValueProviders = keyValueProviders;
        this.rtreePolicy = rtreePolicyType == RTreePolicyType.RTREE ? new RTreePolicy(tupleWriter, keyValueProviders, this.cmpFrameTuple, 16) : new RStarTreePolicy(tupleWriter, keyValueProviders, this.cmpFrameTuple, 16);
    }

    private static double computeDoubleEpsilon() {
        double doubleEpsilon = 1.0;
        while (1.0 + (doubleEpsilon /= 2.0) / 2.0 != 1.0) {
        }
        return doubleEpsilon;
    }

    public static double doubleEpsilon() {
        return doubleEpsilon;
    }

    public void initBuffer(byte level) {
        super.initBuffer(level);
        this.buf.putLong(22, 0L);
        this.buf.putInt(30, -1);
    }

    public void setTupleCount(int tupleCount) {
        this.buf.putInt(8, tupleCount);
    }

    @Override
    public void setPageNsn(long pageNsn) {
        this.buf.putLong(22, pageNsn);
    }

    @Override
    public long getPageNsn() {
        return this.buf.getLong(22);
    }

    protected void resetSpaceParams() {
        this.buf.putInt(12, 34);
        this.buf.putInt(16, this.buf.capacity() - 34);
    }

    @Override
    public int getRightPage() {
        return this.buf.getInt(30);
    }

    @Override
    public void setRightPage(int rightPage) {
        this.buf.putInt(30, rightPage);
    }

    public ITreeIndexTupleReference[] getTuples() {
        return this.tuples;
    }

    public void split(ITreeIndexFrame rightFrame, ITupleReference tuple, ISplitKey splitKey) {
        this.rtreePolicy.split(this, this.buf, rightFrame, this.slotManager, this.frameTuple, tuple, splitKey);
    }

    public abstract int getTupleSize(ITupleReference var1);

    public void adjustMBRImpl(ITreeIndexTupleReference[] tuples) {
        int maxFieldPos = this.keyValueProviders.length / 2;
        for (int i = 1; i < this.getTupleCount(); ++i) {
            this.frameTuple.resetByTupleIndex((ITreeIndexFrame)this, i);
            for (int j = 0; j < maxFieldPos; ++j) {
                double valB;
                int k = maxFieldPos + j;
                double valA = this.keyValueProviders[j].getValue(this.frameTuple.getFieldData(j), this.frameTuple.getFieldStart(j));
                if (valA < (valB = this.keyValueProviders[j].getValue(tuples[j].getFieldData(j), tuples[j].getFieldStart(j)))) {
                    tuples[j].resetByTupleIndex((ITreeIndexFrame)this, i);
                }
                if (!((valA = this.keyValueProviders[k].getValue(this.frameTuple.getFieldData(k), this.frameTuple.getFieldStart(k))) > (valB = this.keyValueProviders[k].getValue(tuples[k].getFieldData(k), tuples[k].getFieldStart(k))))) continue;
                tuples[k].resetByTupleIndex((ITreeIndexFrame)this, i);
            }
        }
    }

    @Override
    public void adjustMBR() {
        for (int i = 0; i < this.tuples.length; ++i) {
            this.tuples[i].setFieldCount(this.getFieldCount());
            this.tuples[i].resetByTupleIndex((ITreeIndexFrame)this, 0);
        }
        this.adjustMBRImpl(this.tuples);
    }

    public abstract int getFieldCount();

    public int getPageHeaderSize() {
        return 34;
    }

    public void setMultiComparator(MultiComparator cmp) {
    }
}

