/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.hyracks.storage.am.rtree.dataflow;

import edu.uci.ics.hyracks.api.comm.IFrameTupleAccessor;
import edu.uci.ics.hyracks.api.context.IHyracksTaskContext;
import edu.uci.ics.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import edu.uci.ics.hyracks.dataflow.common.data.accessors.ITupleReference;
import edu.uci.ics.hyracks.storage.am.common.api.ISearchPredicate;
import edu.uci.ics.hyracks.storage.am.common.api.ITreeIndex;
import edu.uci.ics.hyracks.storage.am.common.dataflow.AbstractTreeIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IIndexOperatorDescriptor;
import edu.uci.ics.hyracks.storage.am.common.dataflow.IndexSearchOperatorNodePushable;
import edu.uci.ics.hyracks.storage.am.common.ophelpers.MultiComparator;
import edu.uci.ics.hyracks.storage.am.common.tuples.PermutingFrameTupleReference;
import edu.uci.ics.hyracks.storage.am.rtree.impls.SearchPredicate;
import edu.uci.ics.hyracks.storage.am.rtree.util.RTreeUtils;

public class RTreeSearchOperatorNodePushable
extends IndexSearchOperatorNodePushable {
    protected PermutingFrameTupleReference searchKey;
    protected MultiComparator cmp;

    public RTreeSearchOperatorNodePushable(AbstractTreeIndexOperatorDescriptor opDesc, IHyracksTaskContext ctx, int partition, IRecordDescriptorProvider recordDescProvider, int[] keyFields) {
        super((IIndexOperatorDescriptor)opDesc, ctx, partition, recordDescProvider);
        if (keyFields != null && keyFields.length > 0) {
            this.searchKey = new PermutingFrameTupleReference();
            this.searchKey.setFieldPermutation(keyFields);
        }
    }

    protected ISearchPredicate createSearchPredicate() {
        ITreeIndex treeIndex = (ITreeIndex)this.index;
        this.cmp = RTreeUtils.getSearchMultiComparator(treeIndex.getComparatorFactories(), (ITupleReference)this.searchKey);
        return new SearchPredicate((ITupleReference)this.searchKey, this.cmp);
    }

    protected void resetSearchPredicate(int tupleIndex) {
        if (this.searchKey != null) {
            this.searchKey.reset((IFrameTupleAccessor)this.accessor, tupleIndex);
        }
    }
}

