/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.mail.actions;

import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.Authenticator;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.actions.Action;
import org.apache.unomi.api.actions.ActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stringtemplate.v4.ST;

public class SendMailAction
implements ActionExecutor {
    private static final Logger logger = LoggerFactory.getLogger((String)SendMailAction.class.getName());
    private String mailServerHostName;
    private int mailServerPort;
    private String mailServerUsername;
    private String mailServerPassword;
    private boolean mailServerSSLOnConnect = true;

    public void setMailServerHostName(String mailServerHostName) {
        this.mailServerHostName = mailServerHostName;
    }

    public void setMailServerPort(int mailServerPort) {
        this.mailServerPort = mailServerPort;
    }

    public void setMailServerUsername(String mailServerUsername) {
        this.mailServerUsername = mailServerUsername;
    }

    public void setMailServerPassword(String mailServerPassword) {
        this.mailServerPassword = mailServerPassword;
    }

    public void setMailServerSSLOnConnect(boolean mailServerSSLOnConnect) {
        this.mailServerSSLOnConnect = mailServerSSLOnConnect;
    }

    public int execute(Action action, Event event) {
        String from = (String)action.getParameterValues().get("from");
        String to = (String)action.getParameterValues().get("to");
        String cc = (String)action.getParameterValues().get("cc");
        String bcc = (String)action.getParameterValues().get("bcc");
        String subject = (String)action.getParameterValues().get("subject");
        String template = (String)action.getParameterValues().get("template");
        ST stringTemplate = new ST(template);
        stringTemplate.add("profile", (Object)event.getProfile());
        stringTemplate.add("event", (Object)event);
        String htmlEmailTemplate = stringTemplate.render();
        try {
            new URL("http://www.apache.org");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        ImageHtmlEmail email = new ImageHtmlEmail();
        email.setHostName(this.mailServerHostName);
        email.setSmtpPort(this.mailServerPort);
        email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.mailServerUsername, this.mailServerPassword));
        email.setSSLOnConnect(this.mailServerSSLOnConnect);
        try {
            email.addTo(to);
            email.setFrom(from);
            if (cc != null && cc.length() > 0) {
                email.addCc(cc);
            }
            if (bcc != null && bcc.length() > 0) {
                email.addBcc(bcc);
            }
            email.setSubject(subject);
            email.setHtmlMsg(htmlEmailTemplate);
            email.setTextMsg("Your email client does not support HTML messages");
            email.send();
        }
        catch (EmailException e) {
            logger.error("Cannot send mail", (Throwable)e);
        }
        return 0;
    }
}

