/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.uima.tools.util.gui.IntegerField;

public class SliderField
extends JPanel
implements ChangeListener,
PropertyChangeListener {
    private static final long serialVersionUID = 8200124988260091779L;
    private JSlider slider;
    private IntegerField textField;

    public SliderField(int min, int max, int initialValue) {
        this.setLayout(new FlowLayout(0, 4, 4));
        this.slider = new JSlider(min, max, initialValue);
        int majorTickSpacing = this.determineMajorTickSpacing(max - min);
        this.slider.setMajorTickSpacing(majorTickSpacing);
        this.slider.setPaintTicks(true);
        this.slider.addChangeListener(this);
        this.add(this.slider);
        this.textField = new IntegerField(min, max, initialValue);
        this.textField.setColumns(5);
        this.textField.addPropertyChangeListener(this);
        this.add(this.textField);
    }

    public void stateChanged(ChangeEvent e) {
        int sliderValue = this.slider.getValue();
        this.textField.setValue(new Integer(sliderValue));
        if (!this.slider.getValueIsAdjusting()) {
            this.textField.setValue(new Integer(sliderValue));
        } else {
            this.textField.setText(String.valueOf(sliderValue));
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("value")) {
            Number value = (Number)e.getNewValue();
            if (this.slider != null && value != null) {
                this.slider.setValue(value.intValue());
            }
        }
    }

    public void setEnabled(boolean onOff) {
        this.slider.setEnabled(onOff);
        this.textField.setEnabled(onOff);
    }

    public int getValue() {
        Integer value = (Integer)this.textField.getValue();
        return value;
    }

    private int determineMajorTickSpacing(int range) {
        if (range > 1000000) {
            return 1000000;
        }
        if (range > 100000) {
            return 100000;
        }
        if (range > 10000) {
            return 10000;
        }
        if (range > 1000) {
            return 1000;
        }
        if (range > 100) {
            return 100;
        }
        return 10;
    }
}

