/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.util.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.apache.uima.UIMAFramework;
import org.apache.uima.tools.images.Images;
import org.apache.uima.util.Level;

public class AboutDialog
extends JDialog {
    private static final long serialVersionUID = -3901327861122722078L;
    private static final String ABOUT_TEXT;

    public AboutDialog(JFrame aParentFrame, String aDialogTitle) {
        super((Frame)aParentFrame, aDialogTitle);
        this.getContentPane().setLayout(new BorderLayout());
        JButton closeButton = new JButton("OK");
        JLabel imageLabel = new JLabel(Images.getImageIcon("/org/apache/uima/tools/images/UIMA_logo_big.png"));
        JPanel imagePanel = new JPanel();
        imagePanel.setBackground(Color.WHITE);
        imagePanel.add(imageLabel);
        this.getContentPane().add((Component)imagePanel, "West");
        String aboutText = ABOUT_TEXT.replaceAll("\\$\\{version\\}", UIMAFramework.getVersionString());
        JTextArea textArea = new JTextArea(aboutText);
        textArea.setEditable(false);
        this.getContentPane().add((Component)textArea, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(closeButton);
        this.getContentPane().add((Component)buttonPanel, "South");
        this.pack();
        this.setResizable(false);
        this.setModal(true);
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                AboutDialog.this.setVisible(false);
            }
        });
    }

    static {
        StringBuffer buf = new StringBuffer();
        try {
            String line;
            InputStream textStream = AboutDialog.class.getResourceAsStream("about.txt");
            BufferedReader reader = new BufferedReader(new InputStreamReader(textStream));
            while ((line = reader.readLine()) != null) {
                buf.append(line).append('\n');
            }
        }
        catch (Exception e) {
            UIMAFramework.getLogger().log(Level.WARNING, "About text could not be loaded", (Throwable)e);
        }
        ABOUT_TEXT = buf.toString();
    }
}

