/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.soap;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.apache.axis.encoding.SerializationContext;
import org.apache.axis.encoding.Serializer;
import org.apache.axis.wsdl.fromJava.Types;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlSerializer
implements Serializer {
    private static final long serialVersionUID = 1674801848276745835L;

    public void serialize(QName name, Attributes attributes, Object value, SerializationContext context) throws IOException {
        if (value instanceof XMLizable) {
            try {
                context.startElement(name, attributes);
                SerializerContentHandler contentHandler = new SerializerContentHandler(context);
                ((XMLizable)value).toXML((ContentHandler)contentHandler);
                context.endElement();
            }
            catch (SAXException e) {
                throw new IOException("SAXException: " + e.getMessage());
            }
        } else {
            throw new IOException("Can't serialize a " + value.getClass().getName() + " with an XmlSerializer.");
        }
    }

    public String getMechanismType() {
        return "Axis SAX Mechanism";
    }

    public Element writeSchema(Class javaType, Types types) throws Exception {
        return null;
    }

    static class SerializerContentHandler
    extends DefaultHandler {
        private SerializationContext mContext;

        SerializerContentHandler(SerializationContext aContext) {
            this.mContext = aContext;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.mContext.writeChars(ch, start, length);
            }
            catch (IOException e) {
                throw new SAXException("IOException:" + e.getMessage());
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            try {
                this.mContext.endElement();
            }
            catch (IOException e) {
                throw new SAXException("IOException:" + e.getMessage());
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            try {
                this.mContext.startElement(new QName(uri, localName), attributes);
            }
            catch (IOException e) {
                throw new SAXException("IOException:" + e.getMessage());
            }
        }
    }
}

