/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.experiment.pos;

import java.text.NumberFormat;
import java.util.List;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.examples.type.Sentence;
import org.apache.uima.fit.examples.type.Token;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;

@SofaCapability(inputSofas={"GOLD_VIEW", "SYSTEM_VIEW"})
public class Evaluator
extends JCasAnnotator_ImplBase {
    private int totalCorrect = 0;
    private int totalWrong = 0;

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            JCas goldView = jCas.getView("GOLD_VIEW");
            JCas systemView = jCas.getView("SYSTEM_VIEW");
            for (Sentence goldSentence : JCasUtil.select((JCas)goldView, Sentence.class)) {
                List goldTokens = JCasUtil.selectCovered((JCas)goldView, Token.class, (AnnotationFS)goldSentence);
                List systemTokens = JCasUtil.selectCovered((JCas)systemView, Token.class, (AnnotationFS)goldSentence);
                if (goldTokens.size() == systemTokens.size()) {
                    for (int i = 0; i < goldTokens.size(); ++i) {
                        String systemPos;
                        String goldPos = ((Token)((Object)goldTokens.get(i))).getPos();
                        if (goldPos.equals(systemPos = ((Token)((Object)systemTokens.get(i))).getPos())) {
                            ++this.totalCorrect;
                            continue;
                        }
                        ++this.totalWrong;
                    }
                    continue;
                }
                throw new RuntimeException("number of tokens in gold view differs from number of tokens in system view");
            }
        }
        catch (CASException ce) {
            throw new AnalysisEngineProcessException((Throwable)ce);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        int total = this.totalCorrect + this.totalWrong;
        System.out.println("total tokens: " + total);
        System.out.println("correct: " + this.totalCorrect);
        System.out.println("wrong: " + this.totalWrong);
        float accuracy = (float)this.totalCorrect / (float)total;
        System.out.println("accuracy: " + NumberFormat.getPercentInstance().format(accuracy));
    }
}

