/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.tutorial.ex6;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ExternalResource;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.examples.tutorial.ex6.StringMapResource;
import org.apache.uima.fit.examples.tutorial.ex6.StringMapResource_impl;
import org.apache.uima.fit.examples.tutorial.type.UimaAcronym;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ExternalResourceFactory;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"org.apache.uima.examples.tutorial.UimaAcronym", "org.apache.uima.examples.tutorial.UimaAcronym:expandedForm"})
public class UimaAcronymAnnotator
extends JCasAnnotator_ImplBase {
    static final String RES_ACRONYM_TABLE = "acronymTable";
    @ExternalResource(key="acronymTable")
    private StringMapResource acronymTable;

    public void process(JCas aJCas) {
        String text = aJCas.getDocumentText();
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(text, " \t\n\r.<.>/?\";:[{]}\\|=+()!", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String expandedForm = this.acronymTable.get(token);
            if (expandedForm != null) {
                UimaAcronym annot = new UimaAcronym(aJCas, pos, pos + token.length());
                annot.setExpandedForm(expandedForm);
                annot.addToIndexes();
            }
            pos += token.length();
        }
    }

    public static void main(String[] args) throws Exception {
        File outputDirectory = new File("target/examples/tutorial/ex6/");
        outputDirectory.mkdirs();
        AnalysisEngineDescription aed = AnalysisEngineFactory.createEngineDescription(UimaAcronymAnnotator.class, (Object[])new Object[]{RES_ACRONYM_TABLE, ExternalResourceFactory.createSharedResourceDescription((String)"file:org/apache/uima/fit/examples/tutorial/ex6/uimaAcronyms.txt", StringMapResource_impl.class, (Object[])new Object[0])});
        aed.toXML((OutputStream)new FileOutputStream(new File(outputDirectory, "UimaAcronymAnnotator.xml")));
    }
}

