/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.tutorial.ex1;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.TypeCapability;
import org.apache.uima.fit.examples.tutorial.type.RoomNumber;
import org.apache.uima.jcas.JCas;

@TypeCapability(outputs={"org.apache.uima.tutorial.RoomNumber", "org.apache.uima.tutorial.RoomNumber:building"})
public class RoomNumberAnnotator
extends JCasAnnotator_ImplBase {
    private Pattern mYorktownPattern = Pattern.compile("\\b[0-4]\\d-[0-2]\\d\\d\\b");
    private Pattern mHawthornePattern = Pattern.compile("\\b[G1-4][NS]-[A-Z]\\d\\d\\b");

    public void process(JCas aJCas) {
        RoomNumber annotation;
        String docText = aJCas.getDocumentText();
        Matcher matcher = this.mYorktownPattern.matcher(docText);
        while (matcher.find()) {
            annotation = new RoomNumber(aJCas, matcher.start(), matcher.end());
            annotation.setBuilding("Yorktown");
            annotation.addToIndexes();
        }
        matcher = this.mHawthornePattern.matcher(docText);
        while (matcher.find()) {
            annotation = new RoomNumber(aJCas, matcher.start(), matcher.end());
            annotation.setBuilding("Hawthorne");
            annotation.addToIndexes();
        }
    }
}

