/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.fit.examples.experiment.pos;

import java.util.ArrayList;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.component.ViewCreatorAnnotator;
import org.apache.uima.fit.descriptor.SofaCapability;
import org.apache.uima.fit.examples.type.Sentence;
import org.apache.uima.fit.examples.type.Token;
import org.apache.uima.jcas.JCas;

@SofaCapability(inputSofas={"_InitialView"}, outputSofas={"GOLD_VIEW"})
public class GoldTagger
extends JCasAnnotator_ImplBase {
    public void process(JCas jCas) throws AnalysisEngineProcessException {
        try {
            JCas defaultView = jCas.getView("_InitialView");
            String tagData = defaultView.getDocumentText();
            JCas goldView = ViewCreatorAnnotator.createViewSafely((JCas)jCas, (String)"GOLD_VIEW");
            String[] wordTagPairs = tagData.split("\\s+");
            StringBuffer text = new StringBuffer();
            int offset = 0;
            ArrayList<Token> tokens = new ArrayList<Token>();
            for (String wordTagPair : wordTagPairs) {
                String word = wordTagPair.split("/")[0];
                String tag = wordTagPair.split("/")[1];
                text.append(word);
                Token token = new Token(goldView, offset, text.length());
                token.setPos(tag);
                tokens.add(token);
                text.append(" ");
                offset += word.length() + 1;
            }
            goldView.setDocumentText(text.toString().trim());
            new Sentence(goldView, 0, goldView.getDocumentText().length()).addToIndexes();
            for (Token token : tokens) {
                token.addToIndexes();
            }
        }
        catch (CASException ce) {
            throw new AnalysisEngineProcessException((Throwable)ce);
        }
    }
}

