/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.rm.scheduler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.NodeIdentity;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.rm.scheduler.IRmJob;
import org.apache.uima.ducc.rm.scheduler.Machine;
import org.apache.uima.ducc.rm.scheduler.ResourceClass;
import org.apache.uima.ducc.rm.scheduler.SchedConstants;
import org.apache.uima.ducc.rm.scheduler.SchedInternalError;
import org.apache.uima.ducc.rm.scheduler.Share;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;

class NodePool
implements SchedConstants {
    static DuccLogger logger = DuccLogger.getLogger(NodePool.class, (String)"RM");
    String id;
    NodePool parent = null;
    int depth;
    int updated = 0;
    int search_order = 100;
    SchedConstants.EvictionPolicy evictionPolicy = SchedConstants.EvictionPolicy.SHRINK_BY_MACHINE;
    HashMap<String, NodePool> children = new HashMap();
    Map<String, String> subpoolNames = new HashMap<String, String>();
    HashMap<Node, Machine> allMachines = new HashMap();
    HashMap<Node, Machine> unresponsiveMachines = new HashMap();
    HashMap<Node, Machine> offlineMachines = new HashMap();
    HashMap<Integer, HashMap<Node, Machine>> machinesByOrder = new HashMap();
    HashMap<String, Machine> machinesByName = new HashMap();
    HashMap<String, Machine> deadByName = new HashMap();
    HashMap<String, Machine> machinesByIp = new HashMap();
    HashMap<Share, Share> allShares = new HashMap();
    HashMap<Node, Machine> preemptables = new HashMap();
    int total_shares = 0;
    Map<ResourceClass, ResourceClass> allClasses = new HashMap<ResourceClass, ResourceClass>();
    int[] nMachinesByOrder;
    int[] vMachinesByOrder;
    int[] nSharesByOrder;
    int[] nPendingByOrder;
    Map<Integer, Integer> onlineMachinesByOrder = new HashMap<Integer, Integer>();
    HashMap<Integer, Map<Node, Machine>> virtualMachinesByOrder = new HashMap();
    static int maxorder = 0;

    NodePool(NodePool parent, String id, Map<String, String> nodes, SchedConstants.EvictionPolicy ep, int depth, int search_order) {
        String methodName = "NodePool.<init>";
        this.parent = parent;
        this.id = id;
        this.subpoolNames = nodes;
        if (nodes == null) {
            this.subpoolNames = new HashMap<String, String>();
            logger.warn(methodName, null, new Object[]{"Nodepool", id, ": no nodes in node list"});
        }
        this.evictionPolicy = ep;
        this.depth = depth;
        this.search_order = search_order;
    }

    void addResourceClass(ResourceClass cl) {
        this.allClasses.put(cl, cl);
    }

    NodePool getParent() {
        return this.parent;
    }

    String getId() {
        return this.id;
    }

    int getDepth() {
        return this.depth;
    }

    int countShares() {
        return this.allShares.size();
    }

    int countOccupiedShares() {
        int count = this.allShares.size();
        for (NodePool np : this.children.values()) {
            count += np.countOccupiedShares();
        }
        return count;
    }

    int countAssignableShares(int order) {
        String methodName = "countAssignableShares";
        int ret = this.nSharesByOrder[order];
        for (ResourceClass rc : this.allClasses.values()) {
            int[] gbo = rc.getGivenByOrder();
            if (gbo == null) continue;
            ret -= gbo[order];
        }
        logger.trace(methodName, null, new Object[]{"Shares available for", this.id, ":", ret});
        for (NodePool np : this.children.values()) {
            ret += np.countAssignableShares(order);
        }
        return ret;
    }

    void removeShare(Share s) {
        this.allShares.remove(s);
    }

    boolean containsPoolNode(Node n) {
        if (this.subpoolNames.containsKey(n.getNodeIdentity().getIp())) {
            return true;
        }
        return this.subpoolNames.containsKey(n.getNodeIdentity().getName());
    }

    int countMachines() {
        int count = this.allMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countMachines();
        }
        return count;
    }

    int countUnresponsiveMachines() {
        int count = this.unresponsiveMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countUnresponsiveMachines();
        }
        return count;
    }

    int countLocalUnresponsiveMachines() {
        return this.unresponsiveMachines.size();
    }

    int countOfflineMachines() {
        int count = this.offlineMachines.size();
        for (NodePool np : this.children.values()) {
            count += np.countOfflineMachines();
        }
        return count;
    }

    int countLocalOfflineMachines() {
        return this.offlineMachines.size();
    }

    Map<Node, Machine> getOfflineMachines() {
        Map ret = (Map)this.offlineMachines.clone();
        for (NodePool np : this.children.values()) {
            ret.putAll(np.getOfflineMachines());
        }
        return ret;
    }

    Map<Node, Machine> getUnresponsiveMachines() {
        Map ret = (Map)this.unresponsiveMachines.clone();
        for (NodePool np : this.children.values()) {
            ret.putAll(np.unresponsiveMachines);
        }
        return ret;
    }

    int countLocalMachines() {
        return this.allMachines.size();
    }

    int countLocalShares() {
        return this.total_shares;
    }

    int countFreeMachines(int order) {
        int cnt = 0;
        HashMap<Node, Machine> mlist = null;
        mlist = this.machinesByOrder.get(order);
        if (mlist == null) {
            return 0;
        }
        for (Machine m : mlist.values()) {
            if (!m.isFree()) continue;
            ++cnt;
        }
        return cnt;
    }

    int[] countLocalFreeMachines() {
        return (int[])this.nMachinesByOrder.clone();
    }

    int countTotalShares() {
        int answer = this.total_shares;
        for (NodePool np : this.children.values()) {
            answer += np.countTotalShares();
        }
        return answer;
    }

    int countQShares() {
        int count = this.nSharesByOrder[1];
        for (NodePool np : this.children.values()) {
            count += np.countQShares();
        }
        return count;
    }

    int countLocalQShares() {
        return this.nSharesByOrder[1];
    }

    int countAllMachinesByOrder(int o) {
        int count = 0;
        if (this.machinesByOrder.containsKey(o)) {
            count = this.machinesByOrder.get(o).size();
        }
        for (NodePool np : this.children.values()) {
            count += np.countAllMachinesByOrder(o);
        }
        return count;
    }

    int[] countAllLocalMachines() {
        int[] ret = NodePool.makeArray();
        for (int o : this.machinesByOrder.keySet()) {
            ret[o] = this.machinesByOrder.get(o).size();
        }
        return ret;
    }

    int countNSharesByOrder(int o) {
        int count = this.nSharesByOrder[o];
        for (NodePool np : this.children.values()) {
            count += np.countNSharesByOrder(o);
        }
        return count;
    }

    int countLocalNSharesByOrder(int o) {
        return this.nSharesByOrder[o];
    }

    int countPendingSharesByOrder(int o) {
        int count = this.nPendingByOrder[o];
        for (NodePool np : this.children.values()) {
            count += np.countPendingSharesByOrder(o);
        }
        return count;
    }

    private boolean isCompatibleNodepool(SchedConstants.Policy p, ResourceClass rc) {
        if (this.allClasses.containsKey(rc)) {
            return true;
        }
        for (NodePool np : this.children.values()) {
            if (!np.isCompatibleNodepool(p, rc)) continue;
            return true;
        }
        return false;
    }

    NodePool findTopOfHeirarchy() {
        NodePool ret = this;
        while (ret.getParent() != null) {
            ret = ret.getParent();
        }
        return ret;
    }

    boolean compatibleNodepool(SchedConstants.Policy p, ResourceClass rc) {
        switch (p) {
            case FAIR_SHARE: {
                NodePool top = this.findTopOfHeirarchy();
                return top.isCompatibleNodepool(p, rc);
            }
            case FIXED_SHARE: 
            case RESERVE: {
                if (!this.allClasses.containsKey(rc)) break;
                return true;
            }
        }
        return false;
    }

    int[] cloneNSharesByOrder() {
        int[] cln = (int[])this.nSharesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] subcln = np.cloneNSharesByOrder();
            for (int i = 0; i < cln.length; ++i) {
                int n = i;
                cln[n] = cln[n] + subcln[i];
            }
        }
        return cln;
    }

    int[] cloneVMachinesByOrder() {
        int[] cln = (int[])this.nMachinesByOrder.clone();
        for (int i = 0; i < cln.length; ++i) {
            int n = i;
            cln[n] = cln[n] + this.vMachinesByOrder[i];
        }
        for (NodePool np : this.children.values()) {
            int[] subcln = np.cloneVMachinesByOrder();
            for (int i = 0; i < cln.length; ++i) {
                int n = i;
                cln[n] = cln[n] + subcln[i];
            }
        }
        return cln;
    }

    public static int getMaxOrder() {
        return maxorder;
    }

    public static int[] makeArray() {
        return new int[NodePool.getArraySize()];
    }

    public static int getArraySize() {
        return NodePool.getMaxOrder() + 1;
    }

    int getSearchOrder() {
        return this.search_order;
    }

    public Machine getMachine(Node n) {
        Machine m;
        block1: {
            NodePool np;
            m = this.allMachines.get(n);
            if (m != null) break block1;
            Iterator<NodePool> i$ = this.children.values().iterator();
            while (i$.hasNext() && (m = (np = i$.next()).getMachine(n)) == null) {
            }
        }
        return m;
    }

    public Machine getMachine(NodeIdentity ni) {
        Machine m;
        block1: {
            NodePool np;
            m = this.machinesByIp.get(ni.getIp());
            if (m != null) break block1;
            Iterator<NodePool> i$ = this.children.values().iterator();
            while (i$.hasNext() && (m = (np = i$.next()).getMachine(ni)) == null) {
            }
        }
        return m;
    }

    boolean containsMachine(Machine m) {
        HashMap<Node, Machine> allm = this.getAllMachines();
        return allm.containsKey(m.getNode());
    }

    HashMap<Node, Machine> getAllMachinesForPool() {
        return (HashMap)this.allMachines.clone();
    }

    HashMap<Node, Machine> getAllMachines() {
        HashMap machs = (HashMap)this.allMachines.clone();
        for (NodePool np : this.children.values()) {
            HashMap<Node, Machine> m = np.getAllMachines();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<String, Machine> getMachinesByName() {
        HashMap machs = (HashMap)this.machinesByName.clone();
        for (NodePool np : this.children.values()) {
            HashMap<String, Machine> m = np.getMachinesByName();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<String, Machine> getMachinesByIp() {
        HashMap machs = (HashMap)this.machinesByIp.clone();
        for (NodePool np : this.children.values()) {
            HashMap<String, Machine> m = np.getMachinesByIp();
            if (m == null) continue;
            machs.putAll(m);
        }
        return machs;
    }

    HashMap<Node, Machine> getMachinesByOrder(int order) {
        HashMap machs = this.machinesByOrder.containsKey(order) ? (HashMap)this.machinesByOrder.get(order).clone() : new HashMap();
        for (NodePool np : this.children.values()) {
            HashMap<Node, Machine> m = np.getMachinesByOrder(order);
            machs.putAll(m);
        }
        return machs;
    }

    Map<Node, Machine> getVirtualMachinesByOrder(int order) {
        HashMap machs;
        if (this.virtualMachinesByOrder.containsKey(order)) {
            HashMap tmp = (HashMap)this.virtualMachinesByOrder.get(order);
            machs = (HashMap)tmp.clone();
        } else {
            machs = new HashMap();
        }
        return machs;
    }

    protected void calcNSharesByOrder() {
        int len = this.nMachinesByOrder.length;
        System.arraycopy(this.nMachinesByOrder, 0, this.nSharesByOrder, 0, len);
        for (int i = 0; i < maxorder + 1; ++i) {
            int n = i;
            this.nSharesByOrder[n] = this.nSharesByOrder[n] + this.vMachinesByOrder[i];
        }
        for (int o = 1; o < len; ++o) {
            for (int p = o + 1; p < len; ++p) {
                if (this.nSharesByOrder[p] == 0) continue;
                int n = o;
                this.nSharesByOrder[n] = this.nSharesByOrder[n] + p / o * this.nSharesByOrder[p];
            }
        }
    }

    protected int[] countMachinesByOrder() {
        int[] ans = (int[])this.nMachinesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countMachinesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    protected int[] countVMachinesByOrder() {
        int[] ans = (int[])this.vMachinesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countVMachinesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    protected int[] countLocalVMachinesByOrder() {
        return (int[])this.vMachinesByOrder.clone();
    }

    protected int[] countAllNSharesByOrder() {
        int[] ans = (int[])this.nSharesByOrder.clone();
        for (NodePool np : this.children.values()) {
            int[] tmp = np.countAllNSharesByOrder();
            for (int i = 0; i < NodePool.getArraySize(); ++i) {
                int n = i;
                ans[n] = ans[n] + tmp[i];
            }
        }
        return ans;
    }

    public synchronized void connectShare(Share s, Machine m, IRmJob j, int order) {
        String methodName = "connectShare";
        logger.info(methodName, j.getId(), new Object[]{"share", s, "order", order, "machine", m});
        j.assignShare(s);
        m.assignShare(s);
        this.rearrangeVirtual(m, order);
        this.allShares.put(s, s);
    }

    void rearrangeVirtual(Machine m, int order) {
        String methodName = "rearrangeVirtual";
        if (this.allMachines.containsKey(m.key())) {
            int v_order = m.getVirtualShareOrder();
            int r_order = m.getShareOrder();
            logger.trace(methodName, null, new Object[]{m.getId(), "order", order, "v_order", v_order, "r_order", r_order});
            if (v_order == r_order) {
                int n = r_order;
                this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
            } else {
                int n = v_order;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] - 1;
            }
            Map<Node, Machine> vlist = this.virtualMachinesByOrder.get(v_order);
            if (vlist == null) {
                logger.error(methodName, null, new Object[]{"ERROR: bad virtual machine list.", m.getId(), "order", order, "v_order", v_order, "r_order", r_order});
                return;
            }
            vlist.remove(m.key());
            m.setVirtualShareOrder(v_order -= order);
            if (v_order != 0) {
                vlist = this.virtualMachinesByOrder.get(v_order);
                if (vlist == null) {
                    vlist = new HashMap<Node, Machine>();
                    this.virtualMachinesByOrder.put(v_order, vlist);
                }
                vlist.put(m.key(), m);
                int n = v_order;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] + 1;
            }
            this.calcNSharesByOrder();
        } else {
            for (NodePool np : this.children.values()) {
                np.rearrangeVirtual(m, order);
            }
        }
    }

    void accountForShares(HashMap<Share, Share> shares) {
        if (shares == null) {
            return;
        }
        for (Share s : shares.values()) {
            int order = s.getShareOrder();
            Machine m = s.getMachine();
            this.rearrangeVirtual(m, order);
        }
    }

    void reset(int order) {
        String methodName = "reset";
        maxorder = Math.max(order, maxorder);
        this.nSharesByOrder = new int[maxorder + 1];
        this.nMachinesByOrder = new int[maxorder + 1];
        this.vMachinesByOrder = new int[maxorder + 1];
        this.nPendingByOrder = new int[maxorder + 1];
        this.virtualMachinesByOrder.clear();
        for (Machine m : this.allMachines.values()) {
            m.resetVirtualShareOrder();
            int v_order = m.getVirtualShareOrder();
            int r_order = m.getShareOrder();
            Map<Node, Machine> ml = null;
            if (v_order == r_order) {
                int n = r_order;
                this.nMachinesByOrder[n] = this.nMachinesByOrder[n] + 1;
            } else {
                int n = v_order;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] + 1;
            }
            ml = this.virtualMachinesByOrder.get(v_order);
            if (ml == null) {
                ml = new HashMap<Node, Machine>();
                this.virtualMachinesByOrder.put(v_order, ml);
            }
            ml.put(m.key(), m);
        }
        this.calcNSharesByOrder();
        for (NodePool np : this.children.values()) {
            np.reset(order);
        }
        if (this.parent == null && this.updated > 0) {
            logger.info(methodName, null, new Object[]{"Scheduling Tables:\n", this.toString()});
            this.updated = 0;
        }
    }

    void resetPreemptables() {
        String methodName = "resetPreemptables";
        logger.info(methodName, null, new Object[]{"Resetting preemptables in nodepool", this.id});
        this.preemptables.clear();
        for (NodePool np : this.children.values()) {
            np.resetPreemptables();
        }
    }

    NodePool getSubpool(String name) {
        if (name.equals(this.id)) {
            return this;
        }
        for (NodePool np : this.children.values()) {
            NodePool ret = np.getSubpool(name);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    boolean containsSubpool(NodePool np) {
        if (np == this) {
            return true;
        }
        for (NodePool cnp : this.children.values()) {
            if (!cnp.containsSubpool(np)) continue;
            return true;
        }
        return false;
    }

    HashMap<String, NodePool> getChildren() {
        return this.children;
    }

    List<NodePool> getChildrenAscending() {
        ArrayList<NodePool> sorted = new ArrayList<NodePool>();
        if (this.children.size() > 0) {
            sorted.addAll(this.children.values());
            Collections.sort(sorted, new NodepoolAscendingSorter());
        }
        return sorted;
    }

    List<NodePool> getChildrenDescending() {
        ArrayList<NodePool> sorted = new ArrayList<NodePool>();
        if (this.children.size() > 0) {
            sorted.addAll(this.children.values());
            Collections.sort(sorted, new NodepoolDescendingSorter());
        }
        return sorted;
    }

    NodePool createSubpool(String className, Map<String, String> names, int order) {
        NodePool np = new NodePool(this, className, names, this.evictionPolicy, this.depth + 1, order);
        this.children.put(className, np);
        return np;
    }

    private synchronized void incrementOnlineByOrder(int order) {
        if (!this.onlineMachinesByOrder.containsKey(order)) {
            this.onlineMachinesByOrder.put(order, 1);
        } else {
            this.onlineMachinesByOrder.put(order, this.onlineMachinesByOrder.get(order) + 1);
        }
    }

    private synchronized void decrementOnlineByOrder(int order) {
        this.onlineMachinesByOrder.put(order, this.onlineMachinesByOrder.get(order) - 1);
    }

    synchronized void getLocalOnlineByOrder(int[] ret) {
        Iterator<Integer> i$ = this.onlineMachinesByOrder.keySet().iterator();
        while (i$.hasNext()) {
            int o;
            int n = o = i$.next().intValue();
            ret[n] = ret[n] + this.onlineMachinesByOrder.get(o);
        }
    }

    synchronized void getOnlineByOrder(int[] ret) {
        Iterator<Object> i$ = this.onlineMachinesByOrder.keySet().iterator();
        while (i$.hasNext()) {
            int o;
            int n = o = i$.next().intValue();
            ret[n] = ret[n] + this.onlineMachinesByOrder.get(o);
        }
        for (NodePool child : this.children.values()) {
            child.getOnlineByOrder(ret);
        }
    }

    Machine nodeArrives(Node node, int order) {
        HashMap<Object, Machine> mlist;
        Machine m;
        String methodName = "nodeArrives";
        maxorder = Math.max(order, maxorder);
        for (NodePool np : this.children.values()) {
            if (!np.containsPoolNode(node)) continue;
            Machine m2 = np.nodeArrives(node, order);
            return m2;
        }
        if (this.allMachines.containsKey(node)) {
            m = this.allMachines.get(node);
            logger.trace(methodName, null, new Object[]{"Node ", m.getId(), " is already known, not adding."});
            return m;
        }
        if (this.offlineMachines.containsKey(node)) {
            m = this.offlineMachines.get(node);
            logger.trace(methodName, null, new Object[]{"Node ", m.getId(), " is offline, not activating."});
            return m;
        }
        if (this.unresponsiveMachines.containsKey(node)) {
            m = this.unresponsiveMachines.remove(node);
            if (m.getShareOrder() != order) {
                m.setShareOrder(order);
            }
            this.allMachines.put(node, m);
            this.machinesByName.put(m.getId(), m);
            this.machinesByIp.put(m.getIp(), m);
            mlist = this.machinesByOrder.get(order);
            this.incrementOnlineByOrder(order);
            if (mlist == null) {
                mlist = new HashMap();
                this.machinesByOrder.put(order, mlist);
            }
            mlist.put(m.key(), m);
            this.total_shares += order;
            logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host reactivated ", m.getId(), String.format("shares %2d total %4d:", order, this.total_shares), m.toString()});
            return m;
        }
        Machine machine = new Machine(node);
        machine.setShareOrder(order);
        this.allMachines.put(machine.key(), machine);
        this.machinesByName.put(machine.getId(), machine);
        this.machinesByIp.put(machine.getIp(), machine);
        this.incrementOnlineByOrder(order);
        machine.setNodepool(this);
        this.total_shares += order;
        mlist = this.machinesByOrder.get(order);
        if (mlist == null) {
            mlist = new HashMap();
            this.machinesByOrder.put(order, mlist);
        }
        mlist.put(machine.key(), machine);
        logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host added:", this.id, ": ", machine.getId(), "Nodefile:", this.subpoolNames.get(machine.getId()), String.format("shares %2d total %4d:", order, this.total_shares), machine.toString()});
        ++this.updated;
        return machine;
    }

    void disable(Machine m, HashMap<Node, Machine> disableMap) {
        String methodName = "nodeLeaves";
        if (this.allMachines.containsKey(m.key())) {
            logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host disabled:", m.getId(), "Looking for shares to clear"});
            int order = m.getShareOrder();
            String name = m.getId();
            String ip = m.getIp();
            HashMap<Share, Share> shares = m.getActiveShares();
            for (Share s : shares.values()) {
                IRmJob j = s.getJob();
                if (j.getDuccType() == IDuccTypes.DuccType.Reservation) {
                    logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host dead/offline:", m.getId(), "Not purging", j.getDuccType()});
                    break;
                }
                switch (j.getDuccType()) {
                    case Reservation: {
                        logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host dead/offline:", m.getId(), "Not purging", j.getDuccType()});
                        break;
                    }
                    case Service: 
                    case Pop: {
                        j.markComplete();
                        logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Host dead/offline:", m.getId(), "Mark service/pop completed."});
                    }
                }
                logger.info(methodName, j.getId(), new Object[]{"Nodepool:", this.id, "Purge", j.getDuccType(), "on dead/offline:", m.getId()});
                j.shrinkByOne(s);
                int n = order;
                this.nPendingByOrder[n] = this.nPendingByOrder[n] + 1;
                s.purge();
            }
            this.allMachines.remove(m.key());
            this.decrementOnlineByOrder(order);
            this.total_shares -= order;
            disableMap.put(m.key(), m);
            HashMap<Node, Machine> machs = this.machinesByOrder.get(order);
            machs.remove(m.key());
            if (machs.size() == 0) {
                this.machinesByOrder.remove(order);
            }
            this.machinesByName.remove(name);
            this.machinesByIp.remove(ip);
            logger.info(methodName, null, new Object[]{"Nodepool:", this.id, "Node leaves:", m.getId(), "total shares:", this.total_shares});
        } else {
            for (NodePool np : this.children.values()) {
                np.nodeLeaves(m);
            }
        }
    }

    void nodeLeaves(Machine m) {
        this.disable(m, this.unresponsiveMachines);
    }

    boolean hasNode(String n) {
        if (this.machinesByName.containsKey(n)) {
            return true;
        }
        for (Node node : this.offlineMachines.keySet()) {
            if (!node.getNodeIdentity().getName().equals(n)) continue;
            return true;
        }
        for (Node node : this.unresponsiveMachines.keySet()) {
            if (!node.getNodeIdentity().getName().equals(n)) continue;
            return true;
        }
        return false;
    }

    String varyoff(String node) {
        Machine m = this.machinesByName.get(node);
        if (m == null) {
            for (Machine mm : this.offlineMachines.values()) {
                if (!mm.getId().equals(node)) continue;
                return "VaryOff: Nodepool " + this.id + " - Already offline: " + node;
            }
            Iterator<Machine> iter = this.unresponsiveMachines.values().iterator();
            while (iter.hasNext()) {
                Machine mm;
                mm = iter.next();
                if (!mm.getId().equals(node)) continue;
                Node key = mm.key();
                iter.remove();
                this.offlineMachines.put(key, mm);
                return "VaryOff: Nodepool " + this.id + " - Unresponsive machine, marked offline: " + node;
            }
            return "VaryOff: Nodepool " + this.id + " - Cannot find machine: " + node;
        }
        this.disable(m, this.offlineMachines);
        return "VaryOff: " + node + " - OK.";
    }

    String varyon(String node) {
        if (this.machinesByName.containsKey(node)) {
            return "VaryOn: Nodepool " + this.id + " - Already online: " + node;
        }
        Iterator<Machine> iter = this.offlineMachines.values().iterator();
        while (iter.hasNext()) {
            Machine mm = iter.next();
            if (!mm.getId().equals(node)) continue;
            iter.remove();
            return "VaryOn: Nodepool " + this.id + " - Machine marked online: " + node;
        }
        for (Machine mm : this.unresponsiveMachines.values()) {
            if (!mm.getId().equals(node)) continue;
            return "VaryOn: Nodepool " + this.id + " - Machine is online but not responsive: " + node;
        }
        return "VaryOn: Nodepool " + this.id + " - Cannot find machine: " + node;
    }

    int countReservables(IRmJob j) {
        int order = j.getShareOrder();
        if (!this.machinesByOrder.containsKey(order)) {
            return 0;
        }
        return this.machinesByOrder.get(order).size();
    }

    int countFixable(IRmJob j) {
        int order = j.getShareOrder();
        int ret = 0;
        for (int i = order; i < maxorder; ++i) {
            if (!this.machinesByOrder.containsKey(order)) continue;
            ret += this.machinesByOrder.get(order).size();
        }
        return ret;
    }

    int countFreeableMachines(IRmJob j, int needed) {
        String methodName = "countFreeableMachines";
        logger.info(methodName, j.getId(), new Object[]{"Enter nodepool", this.id, "preemptables.size() =", this.preemptables.size()});
        int order = j.getShareOrder();
        ArrayList<Machine> machs = new ArrayList<Machine>();
        if (!this.machinesByOrder.containsKey(order)) {
            return 0;
        }
        machs.addAll(this.machinesByOrder.get(order).values());
        StringBuffer sb = new StringBuffer("Machines to search:");
        for (Machine m : machs) {
            sb.append(" ");
            sb.append(m.getId());
        }
        logger.info(methodName, j.getId(), new Object[]{sb.toString()});
        Collections.sort(machs, new MachineByAscendingOrderSorter());
        int given = 0;
        Iterator iter = machs.iterator();
        ArrayList<Machine> pables = new ArrayList<Machine>();
        while (iter.hasNext() && given < needed) {
            Machine m = (Machine)iter.next();
            logger.info(methodName, j.getId(), new Object[]{"Examining", m.getId()});
            if (this.preemptables.containsKey(m.key())) {
                logger.info(methodName, j.getId(), new Object[]{"Bypass because machine", m.getId(), "already counted."});
                continue;
            }
            if (m.isFree()) {
                logger.info(methodName, j.getId(), new Object[]{"Giving", m.getId(), "because it is free"});
                ++given;
                continue;
            }
            if (m.isFreeable()) {
                logger.info(methodName, j.getId(), new Object[]{"Giving", m.getId(), "because it is freeable"});
                ++given;
                pables.add(m);
                continue;
            }
            logger.info(methodName, j.getId(), new Object[]{"Bypass because machine", m.getId(), "is not freeable"});
        }
        for (Machine m : pables) {
            logger.info(methodName, j.getId(), new Object[]{"Setting up", m.getId(), "to clear for reservation"});
            this.preemptables.put(m.key(), m);
            int n = m.getShareOrder();
            this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
        }
        this.calcNSharesByOrder();
        return given;
    }

    int countOutNSharesByOrder(int order, int nrequested) {
        int given = 0;
        int rem = 0;
        int low = order;
        while (given < nrequested && low <= maxorder) {
            int avail = this.vMachinesByOrder[low] + this.nMachinesByOrder[low];
            if (avail > 0) {
                if (this.vMachinesByOrder[low] > 0) {
                    int n = low;
                    this.vMachinesByOrder[n] = this.vMachinesByOrder[n] - 1;
                } else {
                    int n = low;
                    this.nMachinesByOrder[n] = this.nMachinesByOrder[n] - 1;
                }
                ++given;
                rem = low - order;
                if (rem <= 0) continue;
                int n = rem;
                this.vMachinesByOrder[n] = this.vMachinesByOrder[n] + 1;
                low = Math.max(rem, order);
                continue;
            }
            ++low;
        }
        int k = nrequested - given;
        if (k > 0) {
            Iterator<NodePool> iter = this.children.values().iterator();
            while (iter.hasNext() && k > 0) {
                NodePool np = iter.next();
                k = nrequested - (given += np.countOutNSharesByOrder(order, k));
            }
        }
        this.calcNSharesByOrder();
        return given;
    }

    protected ArrayList<Machine> sortedForReservation(HashMap<Node, Machine> machs) {
        ArrayList<Machine> answer = new ArrayList<Machine>();
        answer.addAll(machs.values());
        Collections.sort(answer, new ReservationSorter());
        return answer;
    }

    protected int setupPreemptions(int needed, int order) {
        String methodName = "setupPreemptions";
        int given = 0;
        Iterator<Machine> iter = this.preemptables.values().iterator();
        while (iter.hasNext() && given < needed) {
            Machine m = iter.next();
            int o = m.getShareOrder();
            if (order != o) continue;
            logger.info(methodName, null, new Object[]{"Clearing", m.getId(), "from preemptable list for reservations."});
            HashMap<Share, Share> shares = m.getActiveShares();
            for (Share s : shares.values()) {
                IRmJob j;
                if (s.isPreemptable()) {
                    j = s.getJob();
                    j.shrinkByOne(s);
                    int n = order;
                    this.nPendingByOrder[n] = this.nPendingByOrder[n] + 1;
                    continue;
                }
                if (s.isEvicted() || s.isPurged()) continue;
                j = s.getJob();
                logger.warn(methodName, j.getId(), new Object[]{"Found non-preemptable share", s.getId(), "fixed:", s.isFixed(), "j.NShares", j.countNShares(), "j.NSharesGiven", j.countNSharesGiven()});
            }
            ++given;
            iter.remove();
        }
        return given;
    }

    void findMachines(IRmJob job, ResourceClass rc) {
        String methodName = "findMachines";
        int order = job.getShareOrder();
        int counted = job.countNSharesGiven();
        int current = job.countNShares();
        int needed = counted - current;
        logger.info(methodName, job.getId(), new Object[]{"counted", counted, "current", current, "needed", needed, "order", order});
        if (needed <= 0) {
            return;
        }
        int cnt = this.countFreeMachines(order);
        if (cnt < needed) {
            logger.info(methodName, job.getId(), new Object[]{"Setup preemptions.  Have", cnt, "free machines, needed", needed});
            this.setupPreemptions(needed - cnt, order);
        }
        if (!this.machinesByOrder.containsKey(order)) {
            throw new SchedInternalError(job.getId(), "Scheduling counts are wrong - machinesByOrder does not match nMachinesByOrder");
        }
        ArrayList<Machine> machs = this.sortedForReservation(this.machinesByOrder.get(order));
        for (Machine mm : machs) {
            if (!mm.isFree()) continue;
            Share s = new Share(mm, job, mm.getShareOrder());
            s.setFixed();
            this.connectShare(s, mm, job, mm.getShareOrder());
            if (--needed != 0) continue;
            break;
        }
    }

    ArrayList<Share> evacuateLargest(int order, ArrayList<Share> shares) {
        int found_order = 0;
        if (shares.size() == 1) {
            Share s = shares.get(0);
            if (s.isPreemptable() && s.getShareOrder() == order) {
                return shares;
            }
            return null;
        }
        ArrayList<Share> slist = new ArrayList<Share>();
        for (Share s : shares) {
            found_order = s.getShareOrder();
            if (s.isPreemptable() && found_order == order) {
                slist.add(s);
                return slist;
            }
            int new_order = order - found_order;
            ArrayList new_shares = (ArrayList)shares.clone();
            new_shares.remove(0);
            ArrayList<Share> found_shares = this.evacuateLargest(new_order, new_shares);
            if (!s.isPreemptable() || found_shares == null) continue;
            slist.add(s);
            slist.addAll(found_shares);
            return slist;
        }
        return null;
    }

    int findShares(IRmJob j) {
        return this.findShares(j, true);
    }

    int findShares(IRmJob j, boolean honorCaps) {
        String methodName = "findShares";
        int counted = j.countNSharesGiven();
        int current = j.countNShares();
        int needed = counted - current;
        int order = j.getShareOrder();
        int given = 0;
        boolean expansionStopped = false;
        logger.info(methodName, j.getId(), new Object[]{"counted", counted, "current", current, "needed", needed, "order", order, "given", given});
        if (needed > 0) {
            block0: for (int i = order; i < NodePool.getArraySize(); ++i) {
                if (this.nSharesByOrder[i] == 0) continue;
                Map<Node, Machine> machs = this.getVirtualMachinesByOrder(i);
                ArrayList<Machine> ml = new ArrayList<Machine>();
                ml.addAll(machs.values());
                for (Machine m : ml) {
                    if (m.isBlacklisted()) continue;
                    int g = Math.min(needed, m.countFreeShares(order));
                    for (int ndx = 0; ndx < g; ++ndx) {
                        if (honorCaps && j.exceedsFairShareCap()) {
                            expansionStopped = true;
                            break block0;
                        }
                        Share s = new Share(m, j, order);
                        this.connectShare(s, m, j, order);
                        logger.info(methodName, j.getId(), new Object[]{"Connecting new share", s.toString()});
                    }
                    given += g;
                    if ((needed -= g) != 0) continue;
                    break block0;
                }
            }
        }
        if (needed > 0 && !expansionStopped) {
            for (NodePool np : this.getChildrenAscending()) {
                StringBuffer sb = new StringBuffer();
                for (NodePool sp : this.getChildrenAscending()) {
                    sb.append(sp.getId());
                    sb.append(" ");
                }
                logger.info(methodName, null, new Object[]{np.getId(), "Doing expansions in this order:", sb.toString()});
                int g = np.findShares(j);
                given += g;
                if ((needed -= g) != 0) continue;
                break;
            }
        }
        return given;
    }

    HashMap<IRmJob, IRmJob> doExpansion(List<IRmJob> jobs) {
        String methodName = "doExpansion";
        HashMap<IRmJob, IRmJob> expansions = new HashMap<IRmJob, IRmJob>();
        StringBuffer sb = new StringBuffer();
        sb.append("NP: ");
        sb.append(this.getId());
        sb.append(" Expansions in this order: ");
        for (IRmJob j : jobs) {
            if (j.isCompleted()) continue;
            j.undefer();
            sb.append(j.getId());
            sb.append(":");
            if (this.findShares(j) > 0) {
                sb.append("found ");
                expansions.put(j, j);
            } else {
                sb.append("notfound ");
            }
            if (j.countNShares() != 0) continue;
            j.setReason("Waiting for preemptions.");
        }
        logger.info(methodName, null, new Object[]{sb.toString()});
        return expansions;
    }

    public String toString() {
        int i;
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("--------------------------------------------------------------------------------\n");
        sb.append("Nodepool ");
        sb.append(this.id);
        sb.append(" depth ");
        sb.append(this.depth);
        sb.append(": ");
        sb.append("\n");
        int len = this.nMachinesByOrder.length;
        StringBuffer sbsb = new StringBuffer("%18s ");
        for (int i3 = 0; i3 < len; ++i3) {
            sbsb.append("%4s ");
        }
        sbsb.append("\n");
        String fmt = sbsb.toString();
        Object[] vals = new Object[len + 2];
        vals[0] = "Order";
        for (i2 = 0; i2 < len; ++i2) {
            vals[i2 + 1] = Integer.toString(i2);
        }
        sb.append(String.format(fmt, vals));
        sbsb = new StringBuffer("%18s ");
        for (i2 = 0; i2 < len; ++i2) {
            sbsb.append("%4d ");
        }
        sbsb.append("\n");
        fmt = sbsb.toString();
        vals[0] = "nMachinesByOrder";
        int[] counts = this.countMachinesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        vals[0] = "vMachinesByOrder";
        counts = this.countVMachinesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        vals[0] = "nSharesByOrder";
        counts = this.countAllNSharesByOrder();
        for (i = 0; i < len; ++i) {
            vals[i + 1] = counts[i];
        }
        sb.append(String.format(fmt, vals));
        sb.append("--------------------------------------------------------------------------------\n");
        for (NodePool np : this.children.values()) {
            sb.append(np.toString());
        }
        return sb.toString();
    }

    public void queryMachines() {
        String methodName = "queryMachines";
        ArrayList<Machine> machines = new ArrayList<Machine>();
        machines.addAll(this.getAllMachines().values());
        logger.info(methodName, null, new Object[]{"================================== Query Machines Nodepool:", this.id, "========================="});
        StringBuffer buf = new StringBuffer();
        buf.append(Machine.getHeader());
        buf.append("\n");
        buf.append(Machine.getDashes());
        buf.append("\n");
        Collections.sort(machines, new MachineByOrderSorter());
        for (Machine m : machines) {
            buf.append(m.toString());
            int remaining = m.countFreeShares();
            if (remaining > 0) {
                buf.append("[" + m.countFreeShares() + "]");
            }
            buf.append("\n");
        }
        logger.info(methodName, null, new Object[]{"\n", buf.toString()});
        logger.info(methodName, null, new Object[]{"================================== End Query Machines Nodepool:", this.id, "======================"});
    }

    class MachineByAscendingOrderSorter
    implements Comparator<Machine> {
        MachineByAscendingOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            return m1.getShareOrder() - m2.getShareOrder();
        }
    }

    class MachineByOrderSorter
    implements Comparator<Machine> {
        MachineByOrderSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            return m2.getShareOrder() - m1.getShareOrder();
        }
    }

    class DescendingShareOrderSorter
    implements Comparator<Share> {
        DescendingShareOrderSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            return s2.getShareOrder() - s1.getShareOrder();
        }
    }

    class InvestmentSorter
    implements Comparator<Share> {
        InvestmentSorter() {
        }

        @Override
        public int compare(Share s1, Share s2) {
            return (int)(s1.getInvestment() - s2.getInvestment());
        }
    }

    private static class NodepoolDescendingSorter
    implements Comparator<NodePool> {
        private NodepoolDescendingSorter() {
        }

        @Override
        public int compare(NodePool n1, NodePool n2) {
            return n2.getSearchOrder() - n1.getSearchOrder();
        }
    }

    private static class NodepoolAscendingSorter
    implements Comparator<NodePool> {
        private NodepoolAscendingSorter() {
        }

        @Override
        public int compare(NodePool n1, NodePool n2) {
            return n1.getSearchOrder() - n2.getSearchOrder();
        }
    }

    class ReservationSorter
    implements Comparator<Machine> {
        ReservationSorter() {
        }

        @Override
        public int compare(Machine m1, Machine m2) {
            if (m1.equals(m2)) {
                return 0;
            }
            if (m1.isFree()) {
                if (m2.isFree()) {
                    return m1.getShareOrder() - m2.getShareOrder();
                }
                return -1;
            }
            switch (NodePool.this.evictionPolicy) {
                case SHRINK_BY_MACHINE: {
                    return m2.countFreeShares() - m1.countFreeShares();
                }
                case SHRINK_BY_INVESTMENT: {
                    return m1.getInvestment() - m2.getInvestment();
                }
            }
            return 0;
        }
    }
}

