/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.common.Pair;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.persistence.IDbProperty;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.id.DuccId;
import org.apache.uima.ducc.database.DbHandle;
import org.apache.uima.ducc.database.DbManager;
import org.apache.uima.ducc.database.DbUtil;
import org.apache.uima.ducc.transport.event.common.ADuccWorkExecutable;
import org.apache.uima.ducc.transport.event.common.DuccWorkMap;
import org.apache.uima.ducc.transport.event.common.DuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;
import org.apache.uima.ducc.transport.event.common.IDuccProcessMap;
import org.apache.uima.ducc.transport.event.common.IDuccReservation;
import org.apache.uima.ducc.transport.event.common.IDuccReservationMap;
import org.apache.uima.ducc.transport.event.common.IDuccSchedulingInfo;
import org.apache.uima.ducc.transport.event.common.IDuccStandardInfo;
import org.apache.uima.ducc.transport.event.common.IDuccTypes;
import org.apache.uima.ducc.transport.event.common.IDuccWork;
import org.apache.uima.ducc.transport.event.common.IDuccWorkJob;
import org.apache.uima.ducc.transport.event.common.IDuccWorkReservation;
import org.apache.uima.ducc.transport.event.common.IDuccWorkService;
import org.apache.uima.ducc.transport.event.common.ITimeWindow;
import org.apache.uima.ducc.transport.event.common.history.IHistoryPersistenceManager;

public class HistoryManagerDb
implements IHistoryPersistenceManager {
    private DuccLogger logger = null;
    private DbManager dbManager;
    PreparedStatement jobBlobPrepare = null;
    PreparedStatement reservationBlobPrepare = null;
    PreparedStatement serviceBlobPrepare = null;
    PreparedStatement ckptPrepare = null;
    PreparedStatement processDetailsPrepare = null;
    PreparedStatement reservationAllocPrepare = null;
    PreparedStatement jobDetailsPrepare = null;
    PreparedStatement reservationDetailsPrepare = null;
    static final String JOB_HISTORY_TABLE = IHistoryPersistenceManager.OrWorkProps.JOB_HISTORY_TABLE.pname();
    static final String RES_HISTORY_TABLE = IHistoryPersistenceManager.OrWorkProps.RESERVATION_HISTORY_TABLE.pname();
    static final String SVC_HISTORY_TABLE = IHistoryPersistenceManager.OrWorkProps.SERVICE_HISTORY_TABLE.pname();
    static final String CKPT_TABLE = IHistoryPersistenceManager.OrCkptProps.CKPT_TABLE.pname();
    static final String PROCESS_TABLE = IHistoryPersistenceManager.OrProcessProps.TABLE_NAME.pname();
    static final String JOB_TABLE = IHistoryPersistenceManager.OrJobProps.TABLE_NAME.pname();
    static final String RESERVATION_TABLE = IHistoryPersistenceManager.OrReservationProps.TABLE_NAME.pname();
    static String[] alltables = new String[]{JOB_HISTORY_TABLE, RES_HISTORY_TABLE, SVC_HISTORY_TABLE, CKPT_TABLE, PROCESS_TABLE, JOB_TABLE, RESERVATION_TABLE};
    static final boolean saveDetails = System.getenv("SAVE_DB_DETAILS") != null;

    private boolean init(String dburl, DbManager dbm) throws Exception {
        String methodName = "init";
        boolean ret = true;
        this.logger.info(methodName, null, new Object[]{"Initializing OR persistence over the database"});
        while (true) {
            try {
                if (dbm != null) {
                    this.dbManager = dbm;
                } else {
                    this.dbManager = new DbManager(dburl, this.logger);
                    this.dbManager.init();
                }
                DbHandle h = this.dbManager.open();
                this.jobBlobPrepare = h.prepare("INSERT INTO " + JOB_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?) ;");
                this.reservationBlobPrepare = h.prepare("INSERT INTO " + RES_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?) ;");
                this.serviceBlobPrepare = h.prepare("INSERT INTO " + SVC_HISTORY_TABLE + " (ducc_id, type, history, work) VALUES (?, ?, ?, ?) ;");
                this.ckptPrepare = h.prepare("INSERT INTO " + CKPT_TABLE + " (id, work, p2jmap) VALUES (?, ?, ?);");
                if (!saveDetails) break;
                this.processDetailsPrepare = h.prepare("INSERT INTO " + PROCESS_TABLE + " (host, ducc_id, share_id, type, user, memory, start, stop, class, pid, reason_agent, exit_code, reason_scheduler, cpu, swap_max, run_time, init_time, initialized, investment, major_faults, gc_count, gc_time) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ;");
                this.reservationAllocPrepare = h.prepare("INSERT INTO " + PROCESS_TABLE + " (host, ducc_id, share_id, type, user, memory, start, stop, class, run_time) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ;");
                this.jobDetailsPrepare = h.prepare("INSERT INTO " + JOB_TABLE + " (user, class, ducc_id, submission_time, duration, memory, reason, init_fails, errors, pgin, swap, total_wi, retries, preemptions, description) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ;");
                this.reservationDetailsPrepare = h.prepare("INSERT INTO " + RESERVATION_TABLE + " (user, class, ducc_id, submission_time, duration, memory, reason, processes, state, type, hosts, description) values(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);");
            }
            catch (NoHostAvailableException e) {
                this.logger.error(methodName, null, new Object[]{"Cannot contact database.  Retrying in 5 seconds."});
                Thread.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                this.logger.error(methodName, null, new Object[]{"Errors contacting database.  No connetion made.", e});
                ret = false;
            }
            break;
        }
        return ret;
    }

    public boolean init(DuccLogger logger) throws Exception {
        this.logger = logger;
        String historyUrl = System.getProperty("ducc.database.host");
        return this.init(historyUrl, null);
    }

    boolean init(DuccLogger logger, DbManager dbManager) throws Exception {
        this.logger = logger;
        String stateUrl = System.getProperty("ducc.database.host");
        return this.init(stateUrl, dbManager);
    }

    static ArrayList<SimpleStatement> dropIndices() {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        List<String> indexes = DbUtil.dropIndices((IDbProperty[])IHistoryPersistenceManager.OrProcessProps.values(), PROCESS_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        indexes = DbUtil.dropIndices((IDbProperty[])IHistoryPersistenceManager.OrJobProps.values(), JOB_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        indexes = DbUtil.dropIndices((IDbProperty[])IHistoryPersistenceManager.OrReservationProps.values(), RESERVATION_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    static ArrayList<SimpleStatement> createIndices() {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        List<String> indexes = DbUtil.mkIndices((IDbProperty[])IHistoryPersistenceManager.OrProcessProps.values(), PROCESS_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        indexes = DbUtil.mkIndices((IDbProperty[])IHistoryPersistenceManager.OrJobProps.values(), JOB_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        indexes = DbUtil.mkIndices((IDbProperty[])IHistoryPersistenceManager.OrReservationProps.values(), RESERVATION_TABLE);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    static ArrayList<SimpleStatement> mkSchema(String tablename) throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + tablename + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IHistoryPersistenceManager.OrWorkProps.values()));
        buf.append(")");
        buf.append("WITH CLUSTERING ORDER BY (ducc_id desc)");
        ret.add(new SimpleStatement(buf.toString()));
        List<String> indexes = DbUtil.mkIndices((IDbProperty[])IHistoryPersistenceManager.OrWorkProps.values(), tablename);
        for (String s : indexes) {
            ret.add(new SimpleStatement(s));
        }
        return ret;
    }

    static ArrayList<SimpleStatement> mkSchema() throws Exception {
        ArrayList<SimpleStatement> ret = new ArrayList<SimpleStatement>();
        ret.addAll(HistoryManagerDb.mkSchema(JOB_HISTORY_TABLE));
        ret.addAll(HistoryManagerDb.mkSchema(RES_HISTORY_TABLE));
        ret.addAll(HistoryManagerDb.mkSchema(SVC_HISTORY_TABLE));
        StringBuffer buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + CKPT_TABLE + " (");
        buf.append(DbUtil.mkSchema((IDbProperty[])IHistoryPersistenceManager.OrCkptProps.values()));
        buf.append(")");
        ret.add(new SimpleStatement(buf.toString()));
        if (saveDetails) {
            buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + PROCESS_TABLE + " (");
            buf.append(DbUtil.mkSchema((IDbProperty[])IHistoryPersistenceManager.OrProcessProps.values()));
            buf.append(")");
            ret.add(new SimpleStatement(buf.toString()));
            buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + JOB_TABLE + " (");
            buf.append(DbUtil.mkSchema((IDbProperty[])IHistoryPersistenceManager.OrJobProps.values()));
            buf.append(")");
            ret.add(new SimpleStatement(buf.toString()));
            buf = new StringBuffer("CREATE TABLE IF NOT EXISTS " + RESERVATION_TABLE + " (");
            buf.append(DbUtil.mkSchema((IDbProperty[])IHistoryPersistenceManager.OrReservationProps.values()));
            buf.append(")");
            ret.add(new SimpleStatement(buf.toString()));
            ret.addAll(HistoryManagerDb.createIndices());
        }
        return ret;
    }

    int toInt(String i) {
        if (i == null) {
            return 0;
        }
        try {
            return Integer.parseInt(i);
        }
        catch (Exception e) {
            return 0;
        }
    }

    String getString(String s) {
        return s == null ? "<none>" : s;
    }

    void summarizeJob(DbHandle h, IDuccWork w, String type) throws Exception {
        IDuccWorkJob j = (IDuccWorkJob)w;
        long ducc_id = j.getDuccId().getFriendly();
        IDuccStandardInfo dsi = j.getStandardInfo();
        IDuccSchedulingInfo dsx = j.getSchedulingInfo();
        String user = dsi.getUser();
        String jclass = this.getString(dsx.getSchedulingClass());
        int memory = this.toInt(dsx.getMemorySizeRequested());
        long submission = dsi.getDateOfSubmissionMillis();
        long completion = dsi.getDateOfCompletionMillis();
        long duration = Math.max(0L, completion - submission);
        String reason = this.getString(j.getCompletionType().toString());
        int init_fails = (int)j.getProcessInitFailureCount();
        long pgin = j.getPgInCount();
        long swap = (long)j.getSwapUsageGbMax();
        int wi = (int)j.getWiTotal();
        int errors = this.toInt(dsx.getWorkItemsError());
        int retries = this.toInt(dsx.getWorkItemsRetry());
        int preemptions = this.toInt(dsx.getWorkItemsPreempt());
        String description = this.getString(dsi.getDescription());
        h.execute(this.jobDetailsPrepare, user, jclass, ducc_id, submission, duration, memory, reason, init_fails, errors, pgin, swap, wi, retries, preemptions, description);
    }

    void summarizeProcesses(DbHandle h, IDuccWork w, String type) throws Exception {
        long work_id = w.getDuccId().getFriendly();
        switch (w.getDuccType()) {
            case Job: 
            case Service: 
            case Pop: {
                IDuccProcessMap m = ((ADuccWorkExecutable)w).getProcessMap();
                Map map = m.getMap();
                IDuccStandardInfo dsi = w.getStandardInfo();
                IDuccSchedulingInfo dsx = w.getSchedulingInfo();
                String user = dsi.getUser();
                int memory = this.toInt(dsx.getMemorySizeRequested());
                String sclass = dsx.getSchedulingClass();
                for (IDuccProcess idp : map.values()) {
                    long share_id = idp.getDuccId().getFriendly();
                    long pid = this.toInt(idp.getPID());
                    String node = this.getString(idp.getNodeIdentity().getName());
                    String reason_agent = this.getString(idp.getReasonForStoppingProcess());
                    String reason_scheduler = this.getString(idp.getProcessDeallocationType().toString());
                    int exit_code = idp.getProcessExitCode();
                    long cpu = idp.getCurrentCPU();
                    long swap = idp.getSwapUsageMax();
                    ITimeWindow itw = idp.getTimeWindowInit();
                    long processStart = 0L;
                    long initTime = 0L;
                    if (itw != null) {
                        processStart = itw.getStartLong();
                        initTime = itw.getElapsedMillis();
                    }
                    itw = idp.getTimeWindowRun();
                    long processEnd = 0L;
                    if (itw != null) {
                        processEnd = idp.getTimeWindowRun().getEndLong();
                    }
                    boolean initialized = idp.isInitialized();
                    long investment = idp.getWiMillisInvestment();
                    long major_faults = idp.getMajorFaults();
                    long gccount = 0L;
                    long gctime = 0L;
                    ProcessGarbageCollectionStats gcs = idp.getGarbageCollectionStats();
                    if (gcs != null) {
                        gccount = gcs.getCollectionCount();
                        gctime = gcs.getCollectionTime();
                    }
                    h.execute(this.processDetailsPrepare, node, work_id, share_id, type, user, memory, processStart, processEnd, sclass, pid, reason_agent, exit_code, reason_scheduler, cpu, swap, Math.max(0L, processEnd - processStart), initTime, initialized, investment, major_faults, gccount, gctime);
                }
                break;
            }
            case Reservation: {
                IDuccReservationMap m = ((IDuccWorkReservation)w).getReservationMap();
                Map map = m.getMap();
                IDuccStandardInfo dsi = w.getStandardInfo();
                IDuccSchedulingInfo dsx = w.getSchedulingInfo();
                long start = dsi.getDateOfCompletionMillis();
                long stop = dsi.getDateOfSubmissionMillis();
                int memory_size = 0;
                if (dsx.getMemorySizeRequested() == null) {
                    memory_size = this.toInt(dsx.getMemorySizeRequested());
                }
                for (IDuccReservation idr : map.values()) {
                    String node = "<none>";
                    if (idr.getNode() != null) {
                        node = idr.getNode().getNodeIdentity().getName();
                    }
                    try {
                        h.execute(this.reservationAllocPrepare, node, work_id, idr.getDuccId().getFriendly(), type, this.getString(dsi.getUser()), memory_size, start, stop, this.getString(dsx.getSchedulingClass()), Math.max(0L, stop - start));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
        }
    }

    void summarizeReservation(DbHandle h, IDuccWork w) throws Exception {
        DuccWorkReservation r = (DuccWorkReservation)w;
        long ducc_id = r.getDuccId().getFriendly();
        IDuccStandardInfo dsi = r.getStandardInfo();
        IDuccSchedulingInfo dsx = r.getSchedulingInfo();
        String user = dsi.getUser();
        String jclass = dsx.getSchedulingClass();
        int memory = this.toInt(dsx.getMemorySizeRequested());
        long submission = dsi.getDateOfSubmissionMillis();
        long completion = dsi.getDateOfCompletionMillis();
        long duration = Math.max(0L, completion - submission);
        String reason = this.getString(r.getCompletionType().toString());
        String description = this.getString(dsi.getDescription());
        List nodes = r.getNodes();
        int processes = nodes.size();
        StringBuffer buf = new StringBuffer("");
        for (int i = 0; i < processes; ++i) {
            buf.append((String)nodes.get(i));
            if (i >= processes - 1) continue;
            buf.append(" ");
        }
        String hosts = buf.toString();
        String type = "R";
        String state = r.getReservationState().toString();
        h.execute(this.reservationDetailsPrepare, user, jclass, ducc_id, submission, duration, memory, reason, processes, state, type, hosts, description);
    }

    void saveWork(PreparedStatement s, IDuccWork w, boolean isHistory) throws Exception {
        String methodName = "saveWork";
        Long nowP = System.currentTimeMillis();
        String type = null;
        String processType = null;
        block0 : switch (w.getDuccType()) {
            case Job: {
                type = "job";
                processType = "J";
                break;
            }
            case Service: 
            case Pop: {
                switch (((IDuccWorkService)w).getServiceDeploymentType()) {
                    case uima: 
                    case custom: {
                        type = "service";
                        processType = "S";
                        break block0;
                    }
                    case other: {
                        type = "AP";
                        processType = "A";
                        break block0;
                    }
                }
                break;
            }
            case Reservation: {
                type = "reservation";
                processType = "R";
                break;
            }
            default: {
                this.logger.error(methodName, w.getDuccId(), new Object[]{"Unknown job type", w.getDuccType(), "Cannot save to database."});
                return;
            }
        }
        this.logger.info(methodName, w.getDuccId(), new Object[]{"saving " + type});
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(baos);
        out.writeObject(w);
        out.close();
        byte[] bytes = baos.toByteArray();
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        DbHandle h = this.dbManager.open();
        h.saveObject(s, w.getDuccId().getFriendly(), type, isHistory, buf);
        if (saveDetails) {
            switch (w.getDuccType()) {
                case Job: {
                    this.summarizeJob(h, w, "J");
                    break;
                }
                case Service: 
                case Pop: {
                    break;
                }
                case Reservation: {
                    break;
                }
            }
            this.summarizeProcesses(h, w, processType);
        }
        this.logger.trace(methodName, w.getDuccId(), new Object[]{"----------> Time to save", type, ":", System.currentTimeMillis() - nowP, "Size:", bytes.length, "bytes."});
    }

    <T> T restoreWork(Class<T> cl, String tablename, long friendly_id) throws Exception {
        String methodName = "restoreWork";
        Object ret = null;
        DbHandle h = null;
        h = this.dbManager.open();
        String cql = "SELECT WORK FROM " + tablename + " WHERE DUCC_ID=" + Long.toString(friendly_id);
        ResultSet rs = h.execute(cql);
        for (Row r : rs) {
            this.logger.info(methodName, null, new Object[]{"----- Restoring", friendly_id});
            ByteBuffer bbWork = r.getBytes("work");
            byte[] workbytes = bbWork.array();
            ByteArrayInputStream bais = new ByteArrayInputStream(workbytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            ret = ois.readObject();
            ois.close();
        }
        return (T)ret;
    }

    public <T> ArrayList<T> restoreSeveralThings(Class<T> cl, String tablename, long max) throws Exception {
        String methodName = "restoreSeveralThings";
        ArrayList<Object> ret = new ArrayList<Object>();
        DbHandle h = this.dbManager.open();
        SimpleStatement s = new SimpleStatement("SELECT * from " + tablename + " limit " + max);
        s.setFetchSize(100);
        long now = System.currentTimeMillis();
        try {
            int count = 0;
            int nbytes = 0;
            ResultSet rs = h.execute(s);
            for (Row r : rs) {
                ++count;
                ByteBuffer b = r.getBytes("work");
                byte[] workbytes = b.array();
                nbytes += workbytes.length;
                ByteArrayInputStream bais = new ByteArrayInputStream(workbytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                ret.add(ois.readObject());
                ois.close();
                ++count;
            }
            this.logger.info(methodName, null, new Object[]{"Found", count, "results. Total bytes", nbytes, "Time:", System.currentTimeMillis() - now});
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Error fetching history:", e});
        }
        return ret;
    }

    public void saveJob(IDuccWorkJob j) throws Exception {
        this.saveWork(this.jobBlobPrepare, (IDuccWork)j, true);
    }

    public IDuccWorkJob restoreJob(long friendly_id) throws Exception {
        return this.restoreWork(IDuccWorkJob.class, JOB_HISTORY_TABLE, friendly_id);
    }

    public ArrayList<IDuccWorkJob> restoreJobs(long max) throws Exception {
        return this.restoreSeveralThings(IDuccWorkJob.class, JOB_HISTORY_TABLE, max);
    }

    public void saveReservation(IDuccWorkReservation r) throws Exception {
        this.saveWork(this.reservationBlobPrepare, (IDuccWork)r, true);
    }

    public IDuccWorkReservation restoreReservation(long duccid) throws Exception {
        return this.restoreWork(IDuccWorkReservation.class, RES_HISTORY_TABLE, duccid);
    }

    public ArrayList<IDuccWorkReservation> restoreReservations(long max) throws Exception {
        return this.restoreSeveralThings(IDuccWorkReservation.class, RES_HISTORY_TABLE, max);
    }

    public void saveService(IDuccWorkService s) throws Exception {
        this.saveWork(this.serviceBlobPrepare, (IDuccWork)s, true);
    }

    public IDuccWorkService restoreService(long duccid) throws Exception {
        return this.restoreWork(IDuccWorkService.class, SVC_HISTORY_TABLE, duccid);
    }

    public ArrayList<IDuccWorkService> restoreServices(long max) throws Exception {
        return this.restoreSeveralThings(IDuccWorkService.class, SVC_HISTORY_TABLE, max);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean checkpoint(DuccWorkMap work, Map<DuccId, DuccId> processToJob) throws Exception {
        methodName = "checkpoint";
        now = System.currentTimeMillis();
        ret = true;
        try {
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(work);
            out.close();
            bytes = baos.toByteArray();
            workbuf = ByteBuffer.wrap(bytes);
            if (this.logger.isTrace()) {
                map = work.getMap();
                for (DuccId id : map.keySet()) {
                    w = (IDuccWork)map.get(id);
                    this.logger.trace(methodName, id, new Object[]{"Checkpointing", w.getClass()});
                }
            }
            baos = new ByteArrayOutputStream();
            out = new ObjectOutputStream(baos);
            out.writeObject(processToJob);
            out.close();
            bytes = baos.toByteArray();
            mapbuf = ByteBuffer.wrap(bytes);
            h = this.dbManager.open();
            h.saveObject(this.ckptPrepare, new Object[]{0, workbuf, mapbuf});
            ** if (!ret) goto lbl-1000
        }
        catch (Exception e) {
            try {
                this.logger.error(methodName, null, new Object[]{"Cannot save ProcessToJob map", e});
                ret = false;
                ** if (!ret) goto lbl-1000
            }
            catch (Throwable var15_15) {
                if (ret) {
                    this.logger.trace(methodName, null, new Object[]{"Saved Orchestrator Checkpoint"});
                }
                throw var15_15;
            }
lbl-1000:
            // 1 sources

            {
                this.logger.trace(methodName, null, new Object[]{"Saved Orchestrator Checkpoint"});
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            this.logger.trace(methodName, null, new Object[]{"Saved Orchestrator Checkpoint"});
        }
lbl-1000:
        // 2 sources

        {
        }
        this.logger.trace(methodName, null, new Object[]{"Total time to save checkpoint:", System.currentTimeMillis() - now});
        return ret;
    }

    public Pair<DuccWorkMap, Map<DuccId, DuccId>> restore() throws Exception {
        String methodName = "restore";
        DbHandle h = null;
        Pair ret = new Pair();
        try {
            h = this.dbManager.open();
            String cql = "SELECT * FROM ducc.orckpt WHERE id=0";
            ResultSet rs = h.execute(cql);
            for (Row r : rs) {
                this.logger.info(methodName, null, new Object[]{"Found checkpoint."});
                if (r == null) continue;
                ByteBuffer bbWork = r.getBytes("work");
                ByteBuffer bbmap = r.getBytes("p2jmap");
                byte[] workbytes = bbWork.array();
                ByteArrayInputStream bais = new ByteArrayInputStream(workbytes);
                ObjectInputStream ois = new ObjectInputStream(bais);
                DuccWorkMap work = (DuccWorkMap)ois.readObject();
                ois.close();
                workbytes = bbmap.array();
                bais = new ByteArrayInputStream(workbytes);
                ois = new ObjectInputStream(bais);
                Map processToJob = (Map)ois.readObject();
                ois.close();
                Set ids = work.getReservationKeySet();
                for (DuccId id : ids) {
                    DuccWorkReservation res = (DuccWorkReservation)work.findDuccWork(IDuccTypes.DuccType.Reservation, "" + id.getFriendly());
                    if (r == null) continue;
                    res.initLogger();
                }
                ConcurrentHashMap map = work.getMap();
                for (DuccId id : map.keySet()) {
                    IDuccWork w = (IDuccWork)map.get(id);
                    this.logger.info(methodName, id, new Object[]{"Restored", w.getClass()});
                }
                ret = new Pair((Object)work, (Object)processToJob);
            }
        }
        catch (Exception e) {
            this.logger.error(methodName, null, new Object[]{"Error restoring checkpoint:", e});
        }
        return ret;
    }

    public void shutdown() {
        this.dbManager.shutdown();
    }
}

