/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.database;

import com.datastax.driver.core.AuthProvider;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PlainTextAuthProvider;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.ConstantReconnectionPolicy;
import com.datastax.driver.core.policies.ReconnectionPolicy;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.database.DbHandle;

public class DbManager {
    static final String URL_PROPERTY = "ducc.database.host";
    private static String db_id = null;
    private static String db_pw = null;
    String dburl;
    DuccLogger logger;
    private Cluster cluster;
    private Session session;

    public DbManager(String dburl, DuccLogger logger) throws Exception {
        this.dburl = dburl;
        this.logger = logger;
    }

    boolean checkForDatabase() throws Exception {
        String methodName = "checkForDatabase";
        this.logger.warn(methodName, null, new Object[]{"Not yet implemented."});
        return true;
    }

    public void drop() throws Exception {
        String methodName = "drop";
        this.logger.warn(methodName, null, new Object[]{"Drop is not implemented yet."});
    }

    public synchronized DbHandle open() throws Exception {
        if (this.session == null) {
            this.session = this.cluster.connect();
            this.session.execute((Statement)new SimpleStatement("USE ducc"));
        }
        return new DbHandle(this);
    }

    public synchronized void init() throws Exception {
        String methodName = "init";
        if (this.cluster != null) {
            return;
        }
        DbManager.dbPassword();
        PlainTextAuthProvider auth = new PlainTextAuthProvider(db_id, db_pw);
        ConstantReconnectionPolicy rp = new ConstantReconnectionPolicy(10000L);
        this.cluster = Cluster.builder().withAuthProvider((AuthProvider)auth).addContactPoint(this.dburl).withReconnectionPolicy((ReconnectionPolicy)rp).build();
        Metadata metadata = this.cluster.getMetadata();
        this.logger.info(methodName, null, new Object[]{"Connected to cluster:", metadata.getClusterName()});
        for (Host host : metadata.getAllHosts()) {
            this.logger.info(methodName, null, new Object[]{"Datatacenter:", host.getDatacenter(), "Host:", host.getAddress(), "Rack:", host.getRack()});
        }
    }

    public synchronized void shutdown() {
        String methodName = "closeDatabase";
        this.logger.info(methodName, null, new Object[]{"Closing the database."});
        if (this.cluster != null) {
            this.cluster.close();
        }
        this.cluster = null;
        this.session = null;
    }

    PreparedStatement prepare(String cql) {
        return this.session.prepare(cql);
    }

    void truncate(String table) throws Exception {
        this.execute("TRUNCATE " + table);
    }

    String truncateText(String s) {
        String ret = s;
        if (ret.length() > 200) {
            ret = s.substring(0, 200) + " ... ";
        }
        return ret;
    }

    ResultSet execute(String cql) {
        String methodName = "execute";
        if (this.logger.isDebug()) {
            this.logger.debug(methodName, null, new Object[]{"EXECUTE CQL:", cql});
        } else {
            this.logger.trace(methodName, null, new Object[]{"EXECUTE CQL:", this.truncateText(cql)});
        }
        return this.session.execute(cql);
    }

    ResultSet execute(BoundStatement s) {
        return this.session.execute((Statement)s);
    }

    ResultSet execute(SimpleStatement s) {
        String methodName = "execute";
        this.logger.trace(methodName, null, new Object[]{"EXECUTE STATEMENT:", this.truncateText(s.getQueryString())});
        return this.session.execute((Statement)s);
    }

    static void dbPassword() throws Exception {
        File f = new File(System.getProperty("DUCC_HOME") + "/resources.private/" + "ducc.private.properties");
        if (!f.canRead()) {
            db_id = "guest";
            db_pw = "guest";
            return;
        }
        db_id = "ducc";
        Properties props = new Properties();
        FileInputStream fis = new FileInputStream(f);
        props.load(fis);
        fis.close();
        db_pw = props.getProperty("db_password");
        if (db_pw == null) {
            throw new IllegalStateException("Cannot acquire the database password.");
        }
    }

    public static void main(String[] args) {
    }
}

