/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.node;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.uima.ducc.common.utils.DuccPropertiesResolver;
import org.apache.uima.ducc.common.utils.Utils;

public class DuplicateDuccDaemonProcessDetector {
    public static String checkForDuplicate() {
        String deployFlag = "ducc.deploy.components";
        String virtualFlag = "ducc.agent.virtual";
        String javaCmd = DuccPropertiesResolver.getInstance().getProperty("ducc.jvm");
        if (javaCmd == null) {
            return "ERROR - this is not a DUCC launched process (ducc.jvm missing)";
        }
        String myType = System.getProperty(deployFlag);
        if (myType == null || myType.equals("jd") || myType.equals("jp")) {
            return null;
        }
        String myPid = Utils.getPID();
        String userid = System.getProperty("user.name");
        boolean isAgent = myType.equals("agent");
        String myVirtualIp = System.getProperty(virtualFlag);
        String[] cmdLine = new String[]{"ps", "--user", userid, "-o", "pid,args", "--no-heading"};
        ProcessBuilder pb = new ProcessBuilder(cmdLine);
        pb.redirectErrorStream(true);
        try {
            String line;
            Process proc = pb.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String dupProcess = null;
            while ((line = reader.readLine()) != null) {
                String[] toks = line.trim().split("\\s+");
                if (toks.length < 2 || toks[0].equals(myPid) || !toks[1].equals(javaCmd) || dupProcess != null) continue;
                String virtualIp = null;
                for (String tok : toks) {
                    String[] parts = tok.split("=", 2);
                    if (parts.length != 2) continue;
                    if (parts[0].equals("-D" + deployFlag)) {
                        if (!myType.equals(parts[1])) continue;
                        dupProcess = line;
                        continue;
                    }
                    if (!isAgent || !parts[0].equals("-D" + virtualFlag)) continue;
                    virtualIp = parts[1];
                }
                if (dupProcess == null || !isAgent || myVirtualIp == null || virtualIp == null || virtualIp.equals(myVirtualIp)) continue;
                dupProcess = null;
            }
            proc.waitFor();
            reader.close();
            return dupProcess;
        }
        catch (Exception e) {
            return "Exception: " + e;
        }
    }

    public static void main(String[] args) {
        String dup;
        if (Utils.findDuccHome() == null) {
            System.out.println("ERROR - failed to find DUCC_HOME");
        }
        if ((dup = DuplicateDuccDaemonProcessDetector.checkForDuplicate()) == null) {
            System.out.println("Duplicate daeomon NOT found");
        } else {
            System.out.println("Duplicate daemon found: " + dup);
        }
    }
}

