/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class DuccCollectionUtils {
    public static <T> DuccListDifference difference(List<T> left, List<T> right) {
        return new DuccListDifference((List)CollectionUtils.subtract(left, right), (List)CollectionUtils.subtract(right, left));
    }

    public static <K, T> DuccMapDifference difference(Map<K, T> left, Map<K, T> right) {
        MapDifference mapDifference = Maps.difference(left, right);
        return new DuccMapDifference(mapDifference.entriesOnlyOnLeft(), mapDifference.entriesOnlyOnRight(), mapDifference);
    }

    public static void main(String[] args) {
        try {
            ArrayList list1 = new ArrayList();
            ArrayList list2 = new ArrayList();
            ArrayList<StringHolder> sublist1 = new ArrayList<StringHolder>();
            ArrayList<StringHolder> sublist2 = new ArrayList<StringHolder>();
            sublist1.add(new StringHolder("one"));
            sublist1.add(new StringHolder("two"));
            sublist1.add(new StringHolder("three"));
            sublist1.add(new StringHolder("four"));
            sublist1.add(new StringHolder("five"));
            sublist2.add(new StringHolder("one"));
            sublist2.add(new StringHolder("two"));
            sublist2.add(new StringHolder("six"));
            sublist2.add(new StringHolder("seven"));
            list1.add(sublist1);
            DuccListDifference diffList = DuccCollectionUtils.difference(list1, list2);
            System.out.println("Left List Size:" + diffList.getLeft().size() + " Right List Size:" + diffList.getRight().size());
            list2.add(sublist1);
            list1.add(sublist2);
            DuccListDifference diffList2 = DuccCollectionUtils.difference(list1, list2);
            System.out.println("Left List Size:" + diffList2.getLeft().size() + " Right List Size:" + diffList2.getRight().size());
            sublist2.add(new StringHolder("eight"));
            list2.add(sublist2);
            DuccListDifference diffList4 = DuccCollectionUtils.difference(list1, list2);
            System.out.println("*** Left List Size:" + diffList4.getLeft().size() + " Right List Size:" + diffList4.getRight().size());
            list1.remove(sublist1);
            DuccListDifference diffList3 = DuccCollectionUtils.difference(list1, list2);
            System.out.println("Left List Size:" + diffList3.getLeft().size() + " Right List Size:" + diffList3.getRight().size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class StringHolder {
        private String value;

        public StringHolder(String value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StringHolder other = (StringHolder)obj;
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class DuccListDifference<T> {
        List<T> left;
        List<T> right;

        protected DuccListDifference(List<T> left, List<T> right) {
            this.left = left;
            this.right = right;
        }

        public List<T> getLeft() {
            return this.left;
        }

        public List<T> getRight() {
            return this.right;
        }
    }

    public static class DuccMapValueDifference<T> {
        private T left;
        private T right;

        public DuccMapValueDifference(T left, T right) {
            this.left = left;
            this.right = right;
        }

        public T getLeft() {
            return this.left;
        }

        public T getRight() {
            return this.right;
        }
    }

    public static class DuccMapDifference<K, T>
    implements Iterable<DuccMapValueDifference<T>> {
        Map<K, T> left;
        Map<K, T> right;
        MapDifference<K, T> mapDifference;

        protected DuccMapDifference(Map<K, T> left, Map<K, T> right, MapDifference<K, T> mapDifference) {
            this.left = left;
            this.right = right;
            this.mapDifference = mapDifference;
        }

        @Override
        public Iterator<DuccMapValueDifference<T>> iterator() {
            return new DuccMapValueDifferenceIterator(this.getDifferingMap());
        }

        public Map<K, T> getLeft() {
            return this.left;
        }

        public Map<K, T> getRight() {
            return this.right;
        }

        public Map<K, T> getCommon() {
            return this.mapDifference.entriesInCommon();
        }

        public Map<K, MapDifference.ValueDifference<T>> getDifferingMap() {
            return this.mapDifference.entriesDiffering();
        }

        public DuccMapValueDifferenceIterator getDifferingMapValueIterator() {
            return new DuccMapValueDifferenceIterator(this.getDifferingMap());
        }

        public class DuccMapValueDifferenceIterator
        implements Iterator<DuccMapValueDifference<T>> {
            private Map<K, MapDifference.ValueDifference<T>> differingMap = null;
            private Iterator<Map.Entry<K, MapDifference.ValueDifference<T>>> iterator = null;

            protected DuccMapValueDifferenceIterator(Map<K, MapDifference.ValueDifference<T>> differingMap) {
                this.differingMap = differingMap;
                this.iterator = differingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public DuccMapValueDifference<T> next() {
                Map.Entry dentry = this.iterator.next();
                return new DuccMapValueDifference<Object>(dentry.getValue().leftValue(), dentry.getValue().rightValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

