/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.launcher.ssh;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;

public class DuccRemoteLauncher {
    public static final String FileSeparator = System.getProperty("file.separator");
    private String sshUser;
    private JSch jsch = new JSch();
    private Executor executor = Executors.newCachedThreadPool();
    private OutputStream outputStream;

    public DuccRemoteLauncher() {
    }

    public DuccRemoteLauncher(String sshUser, String sshIdentityLocation, OutputStream out) throws Exception {
        this.outputStream = out;
        this.sshUser = sshUser;
        this.jsch.addIdentity(sshIdentityLocation);
    }

    public Future<ProcessCompletionResult> execute(String host, String command, ProcessCompletionCallback callback) {
        ExecutableTask task2Run = new ExecutableTask(this, callback, host, command);
        FutureTask<ProcessCompletionResult> future = new FutureTask<ProcessCompletionResult>(task2Run);
        this.executor.execute(future);
        return future;
    }

    private ProcessCompletionResult runTask(String host, String command) {
        int exitCode = 0;
        ProcessCompletionResult result = null;
        ByteArrayOutputStream errorStream = new ByteArrayOutputStream();
        ChannelExec channel = null;
        try {
            Session session = this.createSSHSession(host);
            channel = (ChannelExec)session.openChannel("exec");
            channel.setCommand(command);
            channel.setInputStream(null);
            channel.setErrStream((OutputStream)errorStream);
            InputStream in = channel.getInputStream();
            channel.connect();
            this.consumeProcessStream(host, in, this.outputStream, channel);
            channel.disconnect();
            result = channel.getExitStatus() != 0 || errorStream.size() > 0 ? new ProcessCompletionResult(channel.getExitStatus(), host, command, new String(errorStream.toByteArray())) : new ProcessCompletionResult(channel.getExitStatus(), host, command);
        }
        catch (Throwable e) {
            exitCode = channel == null ? -1 : channel.getExitStatus();
            try {
                this.outputStream.write(errorStream.toByteArray());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            result = new ProcessCompletionResult(exitCode, host, command, new String(errorStream.toByteArray()), e);
        }
        return result;
    }

    private int consumeProcessStream(String host, InputStream is, OutputStream os, ChannelExec channel) throws Exception {
        int exitCode = -1;
        InputStreamReader ins = new InputStreamReader(is);
        BufferedReader reader = new BufferedReader(ins);
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                os.write((host + " : " + line + '\n').getBytes());
                os.flush();
                if (!channel.isClosed()) continue;
            }
            if (channel.isClosed()) {
                exitCode = channel.getExitStatus();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exitCode;
    }

    private Session createSSHSession(String host) throws JSchException {
        Session newSession = this.jsch.getSession(this.sshUser, host, 22);
        newSession.setTimeout(500);
        Properties props = new Properties();
        props.put("StrictHostKeyChecking", "no");
        newSession.setConfig(props);
        newSession.connect();
        return newSession;
    }

    public static class ExecutableTask
    implements Callable<ProcessCompletionResult> {
        private ProcessCompletionCallback callback;
        private String host;
        private String command;
        private DuccRemoteLauncher launcher;

        public ExecutableTask(DuccRemoteLauncher launcher, ProcessCompletionCallback callback, String host, String command) {
            this.callback = callback;
            this.host = host;
            this.command = command;
            this.launcher = launcher;
        }

        @Override
        public ProcessCompletionResult call() throws Exception {
            ProcessCompletionResult result = this.launcher.runTask(this.host.toLowerCase(), this.command);
            if (this.callback != null) {
                this.callback.completed(result);
            }
            return result;
        }
    }

    public static interface ProcessCompletionCallback {
        public void completed(ProcessCompletionResult var1);
    }

    public static class ProcessCompletionResult {
        public String stderr;
        public int exitCode;
        public String host;
        public Throwable e;
        public String command;

        public ProcessCompletionResult(int exitCode, String host, String command) {
            this(exitCode, host, command, null, null);
        }

        public ProcessCompletionResult(int exitCode, String host, String command, String errors) {
            this(exitCode, host, command, errors, null);
        }

        public ProcessCompletionResult(int exitCode, String host, String command, String errors, Throwable e) {
            this.exitCode = exitCode;
            this.host = host;
            this.stderr = errors;
            this.e = e;
            this.command = command;
        }
    }
}

