/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.jd.files;

import org.apache.uima.ducc.common.jd.files.IWorkItemState;

public class WorkItemState
implements IWorkItemState {
    private static final long serialVersionUID = 1L;
    private String seqNo = null;
    private String wiId = null;
    private String node = null;
    private String pid = null;
    private String tid = null;
    @Deprecated
    private Name name = null;
    private IWorkItemState.State state = IWorkItemState.State.unknown;
    private long millisAtStart = -1L;
    private long millisAtQueued = -1L;
    private long millisAtOperating = -1L;
    private long millisAtFinish = -1L;
    private long millisAtInvestment = -1L;

    public WorkItemState(int seqNo) {
        this.seqNo = "" + seqNo;
    }

    @Override
    public String getSeqNo() {
        return this.seqNo;
    }

    @Override
    public String getWiId() {
        return this.wiId;
    }

    @Override
    public void setWiId(String wiId) {
        this.wiId = wiId;
    }

    @Override
    public String getNode() {
        return this.node;
    }

    @Override
    public void setNode(String node) {
        this.node = node;
    }

    @Override
    public String getPid() {
        return this.pid;
    }

    @Override
    public void setPid(String pid) {
        this.pid = pid;
    }

    @Override
    public String getTid() {
        return this.tid;
    }

    @Override
    public void setTid(String tid) {
        this.tid = tid;
    }

    @Override
    public IWorkItemState.State getState() {
        IWorkItemState.State retVal = this.state;
        if (this.name != null) {
            switch (this.name) {
                case start: {
                    this.state = IWorkItemState.State.start;
                    break;
                }
                case queued: {
                    this.state = IWorkItemState.State.queued;
                    break;
                }
                case operating: {
                    this.state = IWorkItemState.State.operating;
                    break;
                }
                case ended: {
                    this.state = IWorkItemState.State.ended;
                    break;
                }
                case retry: {
                    this.state = IWorkItemState.State.retry;
                    break;
                }
                default: {
                    this.state = IWorkItemState.State.unknown;
                }
            }
        }
        return retVal;
    }

    @Override
    public void stateStart() {
        this.state = IWorkItemState.State.start;
        this.millisAtStart = System.currentTimeMillis();
    }

    @Override
    public void stateQueued() {
        this.state = IWorkItemState.State.queued;
        this.millisAtQueued = System.currentTimeMillis();
    }

    @Override
    public void stateOperating() {
        this.state = IWorkItemState.State.operating;
        this.millisAtInvestment = this.millisAtOperating = System.currentTimeMillis();
    }

    @Override
    public void investmentReset() {
        this.millisAtInvestment = System.currentTimeMillis();
    }

    @Override
    public void stateEnded() {
        this.state = IWorkItemState.State.ended;
        this.millisAtFinish = System.currentTimeMillis();
    }

    @Override
    public void stateError() {
        this.state = IWorkItemState.State.error;
        this.millisAtFinish = System.currentTimeMillis();
    }

    @Override
    public void stateLost() {
        this.state = IWorkItemState.State.lost;
        this.millisAtFinish = System.currentTimeMillis();
    }

    @Override
    public void stateRetry() {
        this.state = IWorkItemState.State.retry;
    }

    @Override
    public void statePreempt() {
        this.state = IWorkItemState.State.preempt;
    }

    @Override
    public long getMillisOverhead() {
        return this.getMillisOverhead(System.currentTimeMillis());
    }

    @Override
    public long getMillisOverhead(long now) {
        long retVal = 0L;
        if (this.millisAtStart > 0L) {
            if (this.millisAtQueued > 0L) {
                retVal = this.millisAtQueued - this.millisAtStart;
            }
            retVal = this.millisAtOperating > 0L ? this.millisAtOperating - this.millisAtStart : now - this.millisAtStart;
        }
        return retVal;
    }

    @Override
    public long getMillisProcessing() {
        return this.getMillisProcessing(System.currentTimeMillis());
    }

    @Override
    public long getMillisProcessing(long now) {
        long retVal = 0L;
        if (this.millisAtOperating > 0L) {
            retVal = this.millisAtFinish > 0L ? this.millisAtFinish - this.millisAtOperating : now - this.millisAtOperating;
        }
        return retVal;
    }

    @Override
    public long getMillisInvestment() {
        return this.getMillisInvestment(System.currentTimeMillis());
    }

    @Override
    public long getMillisInvestment(long now) {
        long retVal = 0L;
        if (this.millisAtFinish < 0L) {
            retVal = this.millisAtInvestment > 0L ? now - this.millisAtInvestment : this.getMillisProcessing();
        }
        return retVal;
    }

    private static int stateOrder(IWorkItemState.State state) {
        int retVal = 0;
        if (state != null) {
            switch (state) {
                case start: {
                    retVal = -5;
                    break;
                }
                case queued: {
                    retVal = -4;
                    break;
                }
                case operating: {
                    retVal = -3;
                    break;
                }
                case ended: {
                    retVal = -6;
                    break;
                }
                case error: {
                    retVal = -1;
                    break;
                }
                case retry: {
                    retVal = -2;
                    break;
                }
            }
        }
        return retVal;
    }

    private static int compareState(IWorkItemState.State s1, IWorkItemState.State s2) {
        int so1 = WorkItemState.stateOrder(s1);
        int so2 = WorkItemState.stateOrder(s2);
        if (so2 > so1) {
            return 1;
        }
        if (so2 < so1) {
            return -1;
        }
        return 0;
    }

    private static int compareSeqNo(String s1, String s2) {
        long so1 = Long.parseLong(s1);
        long so2 = Long.parseLong(s2);
        if (so2 > so1) {
            return 1;
        }
        if (so2 < so1) {
            return -1;
        }
        return 0;
    }

    @Override
    public int compareTo(IWorkItemState wis) {
        int retVal = 0;
        WorkItemState w1 = this;
        IWorkItemState w2 = wis;
        retVal = WorkItemState.compareState(w1.getState(), w2.getState());
        if (retVal == 0) {
            retVal = WorkItemState.compareSeqNo(w1.getSeqNo(), w2.getSeqNo());
        }
        return retVal;
    }

    @Deprecated
    public static enum Name {
        start,
        queued,
        operating,
        ended,
        error,
        retry;

    }
}

