/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.main.DuccService;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.IOHelper;
import org.apache.uima.ducc.common.utils.id.DuccId;

public class StateServices
implements IStateServices {
    private static DuccLogger logger = DuccService.getDuccLogger(StateServices.class.getName());
    private static DuccId jobid = null;
    private String directory_state_services = IDuccEnv.DUCC_STATE_SERVICES_DIR;

    StateServices() {
        this.mkdirs();
    }

    private void mkdirs() {
        IOHelper.mkdirs(this.directory_state_services);
    }

    private ArrayList<String> getList(String type) {
        String location = "getList";
        ArrayList<String> retVal = new ArrayList<String>();
        try {
            logger.debug(location, jobid, this.directory_state_services);
            File folder = new File(this.directory_state_services);
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                for (int i = 0; i < listOfFiles.length; ++i) {
                    String name;
                    if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + type)) continue;
                    retVal.add(name);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        return retVal;
    }

    @Override
    public ArrayList<String> getSvcList() {
        return this.getList("svc");
    }

    @Override
    public ArrayList<String> getMetaList() {
        return this.getList("meta");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String name) {
        String location = "getProperties";
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(name);){
            properties.load(fis);
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        return properties;
    }

    @Override
    public StateServicesDirectory getStateServicesDirectory() throws IOException {
        String location = "getStateServicesDirectory";
        StateServicesDirectory ssd = null;
        try {
            ssd = new StateServicesDirectory();
            ArrayList<String> svcList = this.getSvcList();
            logger.trace(location, jobid, svcList.size());
            for (String entry : svcList) {
                try {
                    StateServicesSet sss = new StateServicesSet();
                    String num = entry.split("[.]")[0];
                    Integer i = new Integer(num);
                    String base = this.directory_state_services + num;
                    logger.trace(location, jobid, base);
                    String fnSvc = base + "." + "svc";
                    String fnMeta = base + "." + "meta";
                    Properties propertiesSvc = this.getProperties(fnSvc);
                    sss.put("svc", propertiesSvc);
                    Properties propertiesMeta = this.getProperties(fnMeta);
                    sss.put("meta", propertiesMeta);
                    ssd.put(i, sss);
                }
                catch (Exception e) {
                    logger.error(location, jobid, e, new Object[0]);
                }
            }
        }
        catch (Exception e) {
            logger.error(location, jobid, e, new Object[0]);
        }
        return ssd;
    }
}

