/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.node.metrics;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;

public class NodeCpuInfo
implements Serializable {
    private static final long serialVersionUID = -4770810550678067034L;
    private String availableProcessors = "0";
    private String currentLoad = "0.0";

    public NodeCpuInfo(int availableProcessors) {
        this.setAvailableProcessors(String.valueOf(availableProcessors));
        try {
            this.currentLoad = String.valueOf(this.getCPULoad());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCurrentLoad() {
        return this.currentLoad;
    }

    public String getAvailableProcessors() {
        return this.availableProcessors;
    }

    private void setAvailableProcessors(String availableProcessors) {
        this.availableProcessors = availableProcessors;
    }

    private double getCPULoad() throws Exception {
        double cpu = 0.0;
        InputStreamReader in = null;
        String[] command = new String[]{"/bin/sh", "-c", "/bin/grep 'cpu' /proc/stat | /bin/awk '{usage=($2+$4)*100/($2+$4+$5)} END {print usage}'"};
        try {
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.command(command);
            pb.redirectErrorStream(true);
            Process swapCollectorProcess = pb.start();
            in = new InputStreamReader(swapCollectorProcess.getInputStream());
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println(line);
                try {
                    cpu = Double.parseDouble(line.trim());
                }
                catch (NumberFormatException e) {
                    cpu = 0.0;
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return cpu;
    }
}

