/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.GZIPInputStream;
import org.apache.uima.ducc.common.utils.AlienAbstract;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.common.utils.DuccLoggerComponents;
import org.apache.uima.ducc.common.utils.FileHelper;

public class AlienFile
extends AlienAbstract {
    private static DuccLogger duccLogger = DuccLoggerComponents.getWsLogger(AlienFile.class.getName());
    private String command_cat = "/bin/cat";
    private String file_name;

    protected void set_command_cat(String value) {
        this.command_cat = value;
    }

    protected String get_command_cat() {
        return this.command_cat;
    }

    protected void set_file_name(String value) {
        this.file_name = value;
    }

    protected String get_file_name() {
        return this.file_name;
    }

    public AlienFile(String user, String file_name, String ducc_ling) {
        this.set_user(user);
        this.set_file_name(file_name);
        this.set_ducc_ling(ducc_ling);
    }

    private String[] getCommand() {
        String[] command_ducc_ling_yes = new String[]{this.ducc_ling, this.q_parameter, this.u_parameter, this.user, this.command_cat, this.file_name};
        String[] command_ducc_ling_no = new String[]{this.command_cat, this.file_name};
        String[] command = command_ducc_ling_yes;
        if (this.ducc_ling == null) {
            command = command_ducc_ling_no;
        }
        return command;
    }

    private int getByteSize() throws Throwable {
        InputStreamReader isr;
        String methodName = "getByteSize";
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        if (FileHelper.isGzFileType(this.file_name)) {
            GZIPInputStream gis = new GZIPInputStream(pOut);
            isr = new InputStreamReader((InputStream)gis, this.encoding);
        } else {
            isr = new InputStreamReader(pOut);
        }
        BufferedReader br = new BufferedReader(isr);
        int size = 0;
        int rc = 0;
        while (rc >= 0) {
            rc = br.read();
            ++size;
        }
        String text = "" + size;
        duccLogger.debug(methodName, this.duccId, text);
        return size;
    }

    private String reader(int size) throws Throwable {
        String string;
        String data = null;
        BufferedReader br = null;
        InputStreamReader isr = null;
        try {
            String[] command = this.getCommand();
            this.echo(command);
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            InputStream pOut = p.getInputStream();
            if (FileHelper.isGzFileType(this.file_name)) {
                GZIPInputStream gis = new GZIPInputStream(pOut);
                isr = new InputStreamReader((InputStream)gis, this.encoding);
            } else {
                isr = new InputStreamReader(pOut);
            }
            char[] cbuf = new char[size];
            br = new BufferedReader(isr);
            br.read(cbuf);
            string = data = new String(cbuf);
        }
        catch (Throwable t) {
            try {
                t.printStackTrace();
                throw t;
            }
            catch (Throwable throwable) {
                this.closer(br);
                this.closer(isr);
                throw throwable;
            }
        }
        this.closer(br);
        this.closer(isr);
        return string;
    }

    public String getString() throws Throwable {
        int size = this.getByteSize();
        String data = this.reader(size);
        if (data != null) {
            data = data.trim();
        }
        return data;
    }

    public InputStreamReader getInputStreamReader() throws Throwable {
        InputStreamReader isr = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        if (FileHelper.isGzFileType(this.file_name)) {
            GZIPInputStream gis = new GZIPInputStream(pOut);
            isr = new InputStreamReader((InputStream)gis, this.encoding);
        } else {
            isr = new InputStreamReader(pOut);
        }
        return isr;
    }

    public DataInputStream getDataInputStream() throws Throwable {
        DataInputStream dis = null;
        String[] command = this.getCommand();
        this.echo(command);
        ProcessBuilder pb = new ProcessBuilder(command);
        Process p = pb.start();
        InputStream pOut = p.getInputStream();
        dis = new DataInputStream(pOut);
        return dis;
    }

    public static void main(String[] args) throws Throwable {
        AlienFile alienFile;
        String arg_user = args[0];
        String arg_file = args[1];
        if (args.length < 3) {
            alienFile = new AlienFile(arg_user, arg_file, null);
        } else {
            String arg_ducc_ling = args[2];
            alienFile = new AlienFile(arg_user, arg_file, arg_ducc_ling);
        }
        String data = alienFile.getString();
        System.out.println(data);
    }
}

