/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.persistence.services;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.uima.ducc.common.IDuccEnv;
import org.apache.uima.ducc.common.persistence.services.IStateServices;
import org.apache.uima.ducc.common.persistence.services.StateServicesDirectory;
import org.apache.uima.ducc.common.persistence.services.StateServicesSet;
import org.apache.uima.ducc.common.utils.IOHelper;

public class StateServices
implements IStateServices {
    private static StateServices instance = new StateServices();
    private String directory_state_services = IDuccEnv.DUCC_STATE_SERVICES_DIR;

    public static StateServices getInstance() {
        return instance;
    }

    public StateServices() {
        this.mkdirs();
    }

    private void mkdirs() {
        IOHelper.mkdirs(this.directory_state_services);
    }

    private ArrayList<String> getList(String type) {
        ArrayList<String> retVal = new ArrayList<String>();
        File folder = new File(this.directory_state_services);
        File[] listOfFiles = folder.listFiles();
        if (listOfFiles != null) {
            for (int i = 0; i < listOfFiles.length; ++i) {
                String name;
                if (!listOfFiles[i].isFile() || !(name = listOfFiles[i].getName()).endsWith("." + type)) continue;
                retVal.add(name);
            }
        }
        return retVal;
    }

    @Override
    public ArrayList<String> getSvcList() {
        return this.getList("svc");
    }

    @Override
    public ArrayList<String> getMetaList() {
        return this.getList("meta");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String name) {
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(name);
            try {
                properties.load(fis);
            }
            finally {
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    @Override
    public StateServicesDirectory getStateServicesDirectory() throws IOException {
        StateServicesDirectory ssd = new StateServicesDirectory();
        ArrayList<String> svcList = this.getSvcList();
        for (String entry : svcList) {
            try {
                StateServicesSet sss = new StateServicesSet();
                String num = entry.split("[.]")[0];
                Integer i = new Integer(num);
                String fnSvc = this.directory_state_services + num + "." + "svc";
                String fnMeta = this.directory_state_services + num + "." + "meta";
                Properties propertiesSvc = this.getProperties(fnSvc);
                sss.put("svc", propertiesSvc);
                Properties propertiesMeta = this.getProperties(fnMeta);
                sss.put("meta", propertiesMeta);
                ssd.put(i, sss);
            }
            catch (Exception e) {}
        }
        return ssd;
    }
}

