/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.internationalization;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.uima.ducc.common.internationalization.Placeholders;

public class Messages {
    private String resourceName = "Messages";
    private Locale locale = null;
    private ResourceBundle resourceBundle = null;
    private static String default_language = "en";
    private static String default_country = "us";
    private static HashMap<String, Messages> messagesMap = new HashMap();

    public static Messages getInstance() {
        return Messages.getInstance(default_language, default_country);
    }

    public static Messages getInstance(String language, String country) {
        String key;
        if (language == null) {
            language = default_language;
        }
        if (country == null) {
            country = default_country;
        }
        if (!messagesMap.containsKey(key = language + '.' + country)) {
            Locale locale = new Locale(language, country);
            Messages messages = new Messages(locale);
            messagesMap.put(key, messages);
        }
        Messages instance = messagesMap.get(key);
        return instance;
    }

    private Messages(Locale locale) {
        assert (locale != null);
        this.locale = locale;
        this.init();
    }

    private void init() {
        assert (this.locale != null);
        try {
            this.resourceBundle = ResourceBundle.getBundle(this.resourceName, this.locale);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.resourceBundle == null) {
            try {
                this.locale = new Locale(default_language, default_country);
                this.resourceBundle = ResourceBundle.getBundle(this.resourceName, this.locale);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String normalize(String key) {
        return key.replaceAll(" ", "_");
    }

    public String fetch(String key) {
        String text;
        String normalizedKey = this.normalize(key);
        try {
            text = this.resourceBundle.getString(normalizedKey);
        }
        catch (Exception e) {
            text = key;
        }
        return text;
    }

    public String fetchLabel(String key) {
        return this.fetch(key) + Placeholders.label_sep;
    }

    public String fetch_exact(String key) {
        String text;
        String normalizedKey = this.normalize(key);
        try {
            text = this.resourceBundle.getString(normalizedKey);
        }
        catch (Exception e) {
            text = normalizedKey;
        }
        return text;
    }
}

