/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.common.admin.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ducc.common.admin.event.RmQueriedShare;

public class RmQueriedMachine
implements Serializable {
    private static final long serialVersionUID = -8101741014979144426L;
    String name;
    String nodepoolId;
    long memory;
    int order;
    List<RmQueriedShare> shares = null;
    static String fmt_s = "%14s %14s %10s %5s %4s %s";
    String fmt_d = "%14s %14s %10d %5d %4d";

    public RmQueriedMachine(String name, String nodepoolId, long memory, int order) {
        this.name = name;
        this.nodepoolId = nodepoolId;
        this.memory = memory;
        this.order = order;
    }

    public void addShare(RmQueriedShare rqs) {
        if (this.shares == null) {
            this.shares = new ArrayList<RmQueriedShare>();
        }
        this.shares.add(rqs);
    }

    public String getId() {
        return this.name;
    }

    public long getMemory() {
        return this.memory;
    }

    public int getShareOrder() {
        return this.order;
    }

    public static String header() {
        return String.format(fmt_s, "Node", "Nodepool", "Memory", "Order", "Free", "Shares\n");
    }

    public String toConsole() {
        StringBuffer sb = new StringBuffer();
        if (this.shares == null) {
            sb.append(String.format(this.fmt_d, this.name, this.nodepoolId, this.memory, this.order, 0));
            sb.append(" [none]");
        } else {
            int used = 0;
            for (RmQueriedShare s : this.shares) {
                used += s.getShareOrder();
            }
            sb.append(String.format(this.fmt_d, this.name, this.nodepoolId, this.memory, this.order, this.order - used));
            String spacer = " ";
            String altSpacer = "\n" + String.format(fmt_s, "", "", "", "", "", "");
            for (RmQueriedShare s : this.shares) {
                sb.append(spacer);
                sb.append(s.toConsole());
                spacer = altSpacer;
            }
        }
        return sb.toString();
    }

    public String toCompact() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        sb.append(" ");
        sb.append(this.nodepoolId);
        sb.append(" ");
        sb.append(Long.toString(this.memory));
        sb.append(" ");
        sb.append(Integer.toString(this.order));
        if (this.shares == null) {
            sb.append(" 0, None");
        } else {
            int used = 0;
            for (RmQueriedShare s : this.shares) {
                used += s.getShareOrder();
            }
            sb.append(" ");
            sb.append(Integer.toString(this.order - used));
            for (RmQueriedShare s : this.shares) {
                sb.append(",");
                sb.append(s.toCompact());
            }
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("%14s %12d %3d %3d", this.name, this.memory, this.order, this.shares == null ? 0 : this.shares.size());
    }
}

