/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.processors;

import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.camel.Exchange;
import org.apache.uima.ducc.agent.NodeAgent;
import org.apache.uima.ducc.agent.metrics.collectors.DefaultNodeLoadAverageCollector;
import org.apache.uima.ducc.agent.metrics.collectors.DefaultNodeMemoryCollector;
import org.apache.uima.ducc.agent.metrics.collectors.NodeUsersCollector;
import org.apache.uima.ducc.agent.processors.BaseProcessor;
import org.apache.uima.ducc.agent.processors.NodeMetricsProcessor;
import org.apache.uima.ducc.common.DuccNode;
import org.apache.uima.ducc.common.Node;
import org.apache.uima.ducc.common.agent.metrics.memory.NodeMemory;
import org.apache.uima.ducc.common.node.metrics.NodeCpuInfo;
import org.apache.uima.ducc.common.node.metrics.NodeLoadAverage;
import org.apache.uima.ducc.common.node.metrics.NodeMetrics;
import org.apache.uima.ducc.common.node.metrics.NodeUsersInfo;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.NodeMetricsUpdateDuccEvent;

public class DefaultNodeMetricsProcessor
extends BaseProcessor
implements NodeMetricsProcessor {
    private final NodeAgent agent;
    private ExecutorService pool = Executors.newFixedThreadPool(1);
    DuccLogger logger = DuccLogger.getLogger(this.getClass(), (String)"Agent");

    public DefaultNodeMetricsProcessor(NodeAgent agent) throws Exception {
        this.agent = agent;
    }

    public void process(Exchange exchange) throws Exception {
        String methodName = "process";
        try {
            DefaultNodeMemoryCollector collector = new DefaultNodeMemoryCollector();
            Future<NodeMemory> nmiFuture = this.pool.submit(collector);
            DefaultNodeLoadAverageCollector loadAvgCollector = new DefaultNodeLoadAverageCollector();
            Future<NodeLoadAverage> loadFuture = this.pool.submit(loadAvgCollector);
            NodeCpuInfo cpuInfo = new NodeCpuInfo(this.agent.numProcessors);
            NodeUsersCollector nodeUsersCollector = new NodeUsersCollector(this.agent, this.logger);
            Future<TreeMap<String, NodeUsersInfo>> nuiFuture = this.pool.submit(nodeUsersCollector);
            NodeMetrics nodeMetrics = new NodeMetrics(this.agent.getIdentity(), nmiFuture.get(), loadFuture.get(), cpuInfo, nuiFuture.get());
            DuccNode node = new DuccNode(this.agent.getIdentity(), nodeMetrics, this.agent.useCgroups);
            if (this.agent.getNodeInfo() == null) {
                this.agent.setNodeInfo((Node)node);
            }
            this.logger.info(methodName, null, new Object[]{"... Agent " + node.getNodeIdentity().getName() + " Posting Users:" + node.getNodeMetrics().getNodeUsersMap().size()});
            NodeMetricsUpdateDuccEvent event = new NodeMetricsUpdateDuccEvent((Node)node, this.agent.getInventoryRef().size());
            exchange.getIn().setBody((Object)event, NodeMetricsUpdateDuccEvent.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

