/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.agent.metrics.collectors;

import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.uima.ducc.common.node.metrics.ProcessGarbageCollectionStats;
import org.apache.uima.ducc.common.utils.DuccLogger;
import org.apache.uima.ducc.transport.event.common.IDuccProcess;

public class DuccGarbageStatsCollector {
    MBeanServerConnection connection = null;
    DuccLogger logger = null;
    IDuccProcess process = null;

    public DuccGarbageStatsCollector(DuccLogger logger, IDuccProcess process) {
        this.logger = logger;
        this.process = process;
        try {
            if (process != null && process.getProcessJmxUrl() != null && process.getProcessJmxUrl().trim().length() > 0) {
                this.connection = this.getServerConnection();
            }
        }
        catch (Exception e) {
            logger.error("DuccGarbageStatsCollector.ctor", null, (Throwable)e, new Object[0]);
            logger.error("DuccGarbageStatsCollector.ctor", null, new Object[]{"Failed to Connect via JMX to PID:" + process.getPID() + " Reason:\n" + e});
        }
    }

    private MBeanServerConnection getServerConnection() throws Exception {
        System.out.println("Connecting Monitor To Broker - URL:" + this.process.getProcessJmxUrl());
        JMXServiceURL url = new JMXServiceURL(this.process.getProcessJmxUrl());
        JMXConnector jmxc = JMXConnectorFactory.connect(url, null);
        return jmxc.getMBeanServerConnection();
    }

    public ProcessGarbageCollectionStats collect() {
        ProcessGarbageCollectionStats gcStats = new ProcessGarbageCollectionStats();
        if (this.connection != null) {
            try {
                Set<ObjectInstance> mbeans = this.connection.queryMBeans(new ObjectName("java.lang:type=GarbageCollector,*"), null);
                Long totalCollectionCount = new Long(0L);
                Long totalCollectionTime = new Long(0L);
                for (ObjectInstance gcObject : mbeans) {
                    String gcCollectorName = gcObject.getObjectName().getCanonicalKeyPropertyListString();
                    ObjectName memoryManagerMXBean = new ObjectName("java.lang:" + gcCollectorName);
                    totalCollectionCount = totalCollectionCount + (Long)this.connection.getAttribute(memoryManagerMXBean, "CollectionCount");
                    totalCollectionTime = totalCollectionTime + (Long)this.connection.getAttribute(memoryManagerMXBean, "CollectionTime");
                }
                gcStats.setCollectionCount(totalCollectionCount.longValue());
                gcStats.setCollectionTime(totalCollectionTime.longValue());
            }
            catch (Exception e) {
                this.logger.error("", null, new Object[]{"Failed to Fetch JMX GC Stats From PID:" + this.process.getPID() + " Reason:\n" + e});
            }
        }
        return gcStats;
    }
}

