/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.gpg;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractGpgSigner {
    public static final String SIGNATURE_EXTENSION = ".asc";
    protected boolean useAgent;
    protected boolean isInteractive = true;
    protected boolean defaultKeyring = true;
    protected String keyname;
    private Log log;
    protected String passphrase;
    private File outputDir;
    private File buildDir;
    private File baseDir;
    protected File homeDir;
    protected String secretKeyring;
    protected String publicKeyring;
    protected String lockMode;
    protected List<String> args;

    public Log getLog() {
        return this.log;
    }

    public void setArgs(List<String> args) {
        this.args = args;
    }

    public void setInteractive(boolean b) {
        this.isInteractive = b;
    }

    public void setLockMode(String lockMode) {
        this.lockMode = lockMode;
    }

    public void setUseAgent(boolean b) {
        this.useAgent = b;
    }

    public void setDefaultKeyring(boolean enabled) {
        this.defaultKeyring = enabled;
    }

    public void setKeyName(String s) {
        this.keyname = s;
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setPassPhrase(String s) {
        this.passphrase = s;
    }

    public void setOutputDirectory(File out) {
        this.outputDir = out;
    }

    public void setBuildDirectory(File out) {
        this.buildDir = out;
    }

    public void setBaseDirectory(File out) {
        this.baseDir = out;
    }

    public void setHomeDirectory(File homeDirectory) {
        this.homeDir = homeDirectory;
    }

    public void setSecretKeyring(String path) {
        this.secretKeyring = path;
    }

    public void setPublicKeyring(String path) {
        this.publicKeyring = path;
    }

    public File generateSignatureForArtifact(File file) throws MojoExecutionException {
        File parent;
        File signature = new File(file + SIGNATURE_EXTENSION);
        boolean isInBuildDir = false;
        if (this.buildDir != null && this.buildDir.equals(parent = signature.getParentFile())) {
            isInBuildDir = true;
        }
        if (!isInBuildDir && this.outputDir != null) {
            String fileDirectory = "";
            File signatureDirectory = signature;
            while ((signatureDirectory = signatureDirectory.getParentFile()) != null && !signatureDirectory.equals(this.baseDir)) {
                fileDirectory = signatureDirectory.getName() + File.separatorChar + fileDirectory;
            }
            signatureDirectory = new File(this.outputDir, fileDirectory);
            if (!signatureDirectory.exists()) {
                signatureDirectory.mkdirs();
            }
            signature = new File(signatureDirectory, file.getName() + SIGNATURE_EXTENSION);
        }
        if (signature.exists()) {
            signature.delete();
        }
        this.generateSignatureForFile(file, signature);
        return signature;
    }

    protected abstract void generateSignatureForFile(File var1, File var2) throws MojoExecutionException;

    private MavenProject findReactorProject(MavenProject prj) {
        if (prj.getParent() != null && prj.getParent().getBasedir() != null && prj.getParent().getBasedir().exists()) {
            return this.findReactorProject(prj.getParent());
        }
        return prj;
    }

    public String getPassphrase(MavenProject project) throws IOException {
        String pass = null;
        if (project != null && (pass = project.getProperties().getProperty("gpg.passphrase")) == null) {
            MavenProject prj2 = this.findReactorProject(project);
            pass = prj2.getProperties().getProperty("gpg.passphrase");
        }
        if (pass == null) {
            pass = this.readPassword("GPG Passphrase: ");
        }
        if (project != null) {
            this.findReactorProject(project).getProperties().setProperty("gpg.passphrase", pass);
        }
        return pass;
    }

    private String readPassword(String prompt) throws IOException {
        try {
            return this.readPasswordJava16(prompt);
        }
        catch (IOException e) {
            throw e;
        }
        catch (NoSuchMethodException e) {
            return this.readPasswordJava15(prompt);
        }
        catch (IllegalAccessException e) {
            return this.readPasswordJava15(prompt);
        }
        catch (InvocationTargetException e) {
            return this.readPasswordJava15(prompt);
        }
    }

    private String readPasswordJava16(String prompt) throws IOException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method consoleMethod = System.class.getMethod("console", new Class[0]);
        Object console = consoleMethod.invoke(null, new Object[0]);
        if (console == null) {
            throw new IllegalAccessException("console was null");
        }
        Method readPasswordMethod = console.getClass().getMethod("readPassword", String.class, Object[].class);
        return new String((char[])readPasswordMethod.invoke(console, prompt, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPasswordJava15(String prompt) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        while (System.in.available() != 0) {
            System.in.read();
        }
        System.out.print(prompt);
        System.out.print(' ');
        MaskingThread thread = new MaskingThread();
        thread.start();
        try {
            String string = in.readLine();
            return string;
        }
        finally {
            thread.stopMasking();
        }
    }

    class MaskingThread
    extends Thread {
        private volatile boolean stop;

        MaskingThread() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            int priority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(10);
            try {
                this.stop = false;
                while (!this.stop) {
                    System.out.print("\b*");
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException iex) {
                        Thread.currentThread().interrupt();
                        Thread.currentThread().setPriority(priority);
                        return;
                    }
                }
            }
            finally {
                Thread.currentThread().setPriority(priority);
            }
        }

        public void stopMasking() {
            this.stop = true;
        }
    }
}

