/*
 * Decompiled with CFR 0.152.
 */
package net.nicoulaj.maven.plugins.checksum.mojo;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.nicoulaj.maven.plugins.checksum.mojo.AbstractChecksumMojo;
import net.nicoulaj.maven.plugins.checksum.mojo.ChecksumFile;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="artifacts", defaultPhase=LifecyclePhase.VERIFY, requiresProject=true, inheritByDefault=false, threadSafe=true)
public class ArtifactsMojo
extends AbstractChecksumMojo {
    public static final String NAME = "artifacts";
    @Parameter(defaultValue="true")
    protected boolean individualFiles;
    @Parameter
    protected String individualFilesOutputDirectory;
    @Parameter(defaultValue="false")
    protected boolean csvSummary;
    @Parameter(defaultValue="artifacts-checksums.csv")
    protected String csvSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean xmlSummary;
    @Parameter(defaultValue="artifacts-checksums.xml")
    protected String xmlSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean shasumSummary;
    @Parameter(defaultValue="artifacts-checksums.sha")
    protected String shasumSummaryFile;
    @Parameter(defaultValue="false")
    protected boolean appendFilename;

    public ArtifactsMojo() {
        super(false, true, true);
    }

    @Override
    protected List<ChecksumFile> getFilesToProcess() {
        LinkedList<ChecksumFile> files = new LinkedList<ChecksumFile>();
        File pomToSign = new File(this.project.getBuild().getDirectory(), this.project.getBuild().getFinalName() + ".pom");
        try {
            FileUtils.copyFile((File)this.project.getFile(), (File)pomToSign);
        }
        catch (IOException e) {
            throw new RuntimeException((Throwable)new MojoExecutionException("Error copying POM for signing.", (Exception)e));
        }
        files.add(new ChecksumFile("", pomToSign, "pom", null));
        if (this.hasValidFile(this.project.getArtifact())) {
            files.add(new ChecksumFile("", this.project.getArtifact().getFile(), this.project.getArtifact().getType(), this.project.getArtifact().getClassifier()));
        }
        if (this.project.getAttachedArtifacts() != null) {
            for (Artifact artifact : this.project.getAttachedArtifacts()) {
                if (!this.hasValidFile(artifact)) continue;
                files.add(new ChecksumFile("", artifact.getFile(), artifact.getType(), artifact.getClassifier()));
            }
        }
        return files;
    }

    protected boolean hasValidFile(Artifact artifact) {
        boolean hasValidFile = artifact != null && artifact.getFile() != null && artifact.getFile().exists();
        hasValidFile = hasValidFile && !artifact.getFile().getPath().equals(this.project.getFile().getPath());
        hasValidFile = hasValidFile && artifact.getFile().getPath().startsWith(this.project.getBuild().getDirectory());
        return hasValidFile;
    }

    @Override
    protected boolean isIndividualFiles() {
        return this.individualFiles;
    }

    @Override
    protected String getIndividualFilesOutputDirectory() {
        return this.individualFilesOutputDirectory;
    }

    @Override
    protected boolean isAppendFilename() {
        return this.appendFilename;
    }

    @Override
    protected boolean isCsvSummary() {
        return this.csvSummary;
    }

    @Override
    protected String getCsvSummaryFile() {
        return this.csvSummaryFile;
    }

    @Override
    protected boolean isXmlSummary() {
        return this.xmlSummary;
    }

    @Override
    protected String getXmlSummaryFile() {
        return this.xmlSummaryFile;
    }

    @Override
    protected boolean isShasumSummary() {
        return this.shasumSummary;
    }

    @Override
    protected String getShasumSummaryFile() {
        return this.shasumSummaryFile;
    }
}

