/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ssz;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.ssz.ByteBufferSSZWriter;
import org.apache.tuweni.ssz.BytesSSZReader;
import org.apache.tuweni.ssz.BytesSSZWriter;
import org.apache.tuweni.ssz.SSZReader;
import org.apache.tuweni.ssz.SSZWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.bigints.UInt384;

public final class SSZ {
    private static final Bytes TRUE = Bytes.of((byte[])new byte[]{1});
    private static final Bytes FALSE = Bytes.of((byte[])new byte[]{0});

    private SSZ() {
    }

    public static Bytes32 hashTreeRoot(Bytes ... bytes) {
        if (bytes.length == 1) {
            if (bytes[0].size() > 32) {
                return Hash.keccak256((Bytes)bytes[0]);
            }
            return Bytes32.rightPad((Bytes)bytes[0]);
        }
        Bytes hash = SSZ.merkleHash(new ArrayList<Bytes>(Arrays.asList(bytes)));
        return Bytes32.rightPad((Bytes)hash);
    }

    static Bytes merkleHash(List<Bytes> values) {
        List<Object> chunks;
        Bytes littleEndianLength = Bytes.ofUnsignedInt((long)values.size(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        Bytes32 valuesLength = Bytes32.rightPad((Bytes)littleEndianLength);
        if (values.isEmpty()) {
            chunks = new ArrayList<Bytes>();
            chunks.add(Bytes.wrap((byte[])new byte[128]));
        } else if (values.get(0).size() < 128) {
            int itemsPerChunk = (int)Math.floor(128.0 / (double)values.get(0).size());
            chunks = new ArrayList();
            int i = 0;
            while (i * itemsPerChunk < values.size()) {
                Bytes[] chunkItems = values.subList(i * itemsPerChunk, Math.min((i + 1) * itemsPerChunk, values.size())).toArray(new Bytes[0]);
                chunks.add(Bytes.concatenate((Bytes[])chunkItems));
                ++i;
            }
        } else {
            chunks = values;
        }
        while (chunks.size() > 1) {
            if (chunks.size() % 2 == 1) {
                chunks.add(Bytes.wrap((byte[])new byte[128]));
            }
            Iterator<Object> iterator = chunks.iterator();
            ArrayList<Bytes32> hashRound = new ArrayList<Bytes32>();
            while (iterator.hasNext()) {
                hashRound.add(Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)iterator.next(), (Bytes)iterator.next()})));
            }
            chunks = hashRound;
        }
        return Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{(Bytes)chunks.get(0), valuesLength}));
    }

    public static Bytes encode(Consumer<SSZWriter> fn) {
        Objects.requireNonNull(fn);
        BytesSSZWriter writer = new BytesSSZWriter();
        fn.accept(writer);
        return writer.toBytes();
    }

    public static <T extends ByteBuffer> T encodeTo(T buffer, Consumer<SSZWriter> fn) {
        Objects.requireNonNull(buffer);
        Objects.requireNonNull(fn);
        ByteBufferSSZWriter writer = new ByteBufferSSZWriter(buffer);
        fn.accept(writer);
        return buffer;
    }

    public static Bytes encodeBytes(Bytes value) {
        Bytes lengthBytes = SSZ.encodeLong(value.size(), 32);
        return Bytes.wrap((Bytes[])new Bytes[]{lengthBytes, value});
    }

    static void encodeBytesTo(Bytes value, Consumer<Bytes> appender) {
        appender.accept(SSZ.encodeLong(value.size(), 32));
        appender.accept(value);
    }

    static void encodeFixedBytesTo(Bytes value, Consumer<Bytes> appender) {
        appender.accept(value);
    }

    public static Bytes encodeByteArray(byte[] value) {
        return SSZ.encodeBytes(Bytes.wrap((byte[])value));
    }

    static void encodeByteArrayTo(byte[] value, Consumer<byte[]> appender) {
        appender.accept(SSZ.encodeLongToByteArray(value.length, 32));
        appender.accept(value);
    }

    public static Bytes encodeString(String str) {
        return SSZ.encodeByteArray(str.getBytes(StandardCharsets.UTF_8));
    }

    static void encodeStringTo(String str, Consumer<byte[]> appender) {
        SSZ.encodeByteArrayTo(str.getBytes(StandardCharsets.UTF_8), appender);
    }

    public static Bytes encodeInt(int value, int bitLength) {
        return SSZ.encodeLong(value, bitLength);
    }

    public static Bytes encodeLong(long value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeLongToByteArray(value, bitLength));
    }

    static byte[] encodeLongToByteArray(long value, int bitLength) {
        int i;
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int zeros = value >= 0L ? Long.numberOfLeadingZeros(value) : Long.numberOfLeadingZeros(-1L - value) - 1;
        int valueBytes = 8 - zeros / 8;
        int byteLength = bitLength / 8;
        Preconditions.checkArgument((valueBytes <= byteLength ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        byte[] encoded = new byte[byteLength];
        int shift = 0;
        for (i = 0; i < valueBytes; ++i) {
            encoded[i] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        if (value < 0L) {
            for (i = valueBytes; i < byteLength; ++i) {
                encoded[i] = -1;
            }
        }
        return encoded;
    }

    public static Bytes encodeBigInteger(BigInteger value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeBigIntegerToByteArray(value, bitLength));
    }

    public static byte[] encodeBigIntegerToByteArray(BigInteger value, int bitLength) {
        byte[] encoded;
        int byteLength;
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        byte[] bytes = value.toByteArray();
        int valueBytes = bytes.length;
        int offset = 0;
        if (value.signum() >= 0 && bytes[0] == 0) {
            valueBytes = bytes.length - 1;
            offset = 1;
        }
        Preconditions.checkArgument((valueBytes <= (byteLength = bitLength / 8) ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        if (valueBytes == byteLength && offset == 0) {
            encoded = bytes;
        } else {
            encoded = new byte[byteLength];
            int padLength = byteLength - valueBytes;
            System.arraycopy(bytes, offset, encoded, padLength, valueBytes);
            if (value.signum() < 0) {
                for (int i = 0; i < padLength; ++i) {
                    encoded[i] = -1;
                }
            }
        }
        for (int i = 0; i < encoded.length / 2; ++i) {
            byte swapped = encoded[i];
            encoded[i] = encoded[encoded.length - i - 1];
            encoded[encoded.length - i - 1] = swapped;
        }
        return encoded;
    }

    public static Bytes encodeInt8(int value) {
        return SSZ.encodeInt(value, 8);
    }

    public static Bytes encodeInt16(int value) {
        return SSZ.encodeInt(value, 16);
    }

    public static Bytes encodeInt32(int value) {
        return SSZ.encodeInt(value, 32);
    }

    public static Bytes encodeInt64(long value) {
        return SSZ.encodeLong(value, 64);
    }

    public static Bytes encodeUInt(int value, int bitLength) {
        return SSZ.encodeULong(value, bitLength);
    }

    public static Bytes encodeULong(long value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeULongToByteArray(value, bitLength));
    }

    static byte[] encodeULongToByteArray(long value, int bitLength) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        int zeros = Long.numberOfLeadingZeros(value);
        int valueBytes = 8 - zeros / 8;
        Preconditions.checkArgument((zeros == 0 || value >= 0L ? 1 : 0) != 0, (Object)"Value must be positive or zero");
        int byteLength = bitLength / 8;
        Preconditions.checkArgument((valueBytes <= byteLength ? 1 : 0) != 0, (Object)"value is too large for the desired bitLength");
        byte[] encoded = new byte[byteLength];
        int shift = 0;
        for (int i = 0; i < valueBytes; ++i) {
            encoded[i] = (byte)(value >> shift & 0xFFL);
            shift += 8;
        }
        return encoded;
    }

    public static Bytes encodeUBigInteger(BigInteger value, int bitLength) {
        return Bytes.wrap((byte[])SSZ.encodeUBigIntegerToByteArray(value, bitLength));
    }

    public static byte[] encodeUBigIntegerToByteArray(BigInteger value, int bitLength) {
        Preconditions.checkArgument((value.compareTo(BigInteger.ZERO) >= 0 ? 1 : 0) != 0, (Object)"Value must be positive or zero");
        return SSZ.encodeBigIntegerToByteArray(value, bitLength);
    }

    public static Bytes encodeUInt8(int value) {
        return SSZ.encodeUInt(value, 8);
    }

    public static Bytes encodeUInt16(int value) {
        return SSZ.encodeUInt(value, 16);
    }

    public static Bytes encodeUInt32(long value) {
        return SSZ.encodeULong(value, 32);
    }

    public static Bytes encodeUInt64(long value) {
        return SSZ.encodeULong(value, 64);
    }

    public static Bytes encodeUInt256(UInt256 value) {
        return value.toBytes().reverse();
    }

    public static Bytes encodeUInt384(UInt384 value) {
        return value.toBytes().reverse();
    }

    public static Bytes encodeBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static Bytes encodeAddress(Bytes address) {
        Preconditions.checkArgument((address.size() == 20 ? 1 : 0) != 0, (Object)"address is not 20 bytes");
        return address;
    }

    public static Bytes encodeHash(Bytes hash) {
        return hash;
    }

    public static Bytes encodeBytesList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length * 2 + 1);
        SSZ.encodeBytesListTo(elements, encoded::add);
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeBytesList(List<? extends Bytes> elements) {
        ArrayList encoded = new ArrayList(elements.size() * 2 + 1);
        SSZ.encodeBytesListTo(elements, encoded::add);
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBytesListTo(Bytes[] elements, Consumer<Bytes> appender) {
        long listSize = 0L;
        for (Bytes bytes : elements) {
            listSize += 4L;
            if ((listSize += (long)bytes.size()) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        appender.accept(SSZ.encodeUInt32(listSize));
        for (Bytes bytes : elements) {
            SSZ.encodeBytesTo(bytes, appender);
        }
    }

    static void encodeBytesListTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        long listSize = 0L;
        for (Bytes bytes : elements) {
            listSize += 4L;
            if ((listSize += (long)bytes.size()) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        appender.accept(SSZ.encodeUInt32(listSize));
        for (Bytes bytes : elements) {
            SSZ.encodeBytesTo(bytes, appender);
        }
    }

    static void encodeFixedBytesVectorTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        for (Bytes bytes : elements) {
            appender.accept(bytes);
        }
    }

    static void encodeBytesVectorTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        for (Bytes bytes : elements) {
            appender.accept(SSZ.encodeLong(bytes.size(), 32));
            appender.accept(bytes);
        }
    }

    static void encodeFixedBytesListTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        long listSize = 0L;
        for (Bytes bytes : elements) {
            if ((listSize += (long)bytes.size()) <= Integer.MAX_VALUE) continue;
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        appender.accept(SSZ.encodeUInt32(listSize));
        for (Bytes bytes : elements) {
            SSZ.encodeFixedBytesTo(bytes, appender);
        }
    }

    public static Bytes encodeStringList(String ... elements) {
        ArrayList encoded = new ArrayList(elements.length * 2 + 1);
        SSZ.encodeStringListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeStringList(List<String> elements) {
        ArrayList encoded = new ArrayList(elements.size() * 2 + 1);
        SSZ.encodeStringListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeStringListTo(String[] elements, Consumer<Bytes> appender) {
        Bytes[] elementBytes = new Bytes[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            elementBytes[i] = Bytes.wrap((byte[])elements[i].getBytes(StandardCharsets.UTF_8));
        }
        SSZ.encodeBytesListTo(elementBytes, appender);
    }

    static void encodeStringListTo(List<String> elements, Consumer<Bytes> appender) {
        Bytes[] elementBytes = new Bytes[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            elementBytes[i] = Bytes.wrap((byte[])elements.get(i).getBytes(StandardCharsets.UTF_8));
        }
        SSZ.encodeBytesListTo(elementBytes, appender);
    }

    public static Bytes encodeIntList(int bitLength, int ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeIntList(int bitLength, List<Integer> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeIntListTo(int bitLength, int[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    static void encodeIntListTo(int bitLength, List<Integer> elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.size(), bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeLongIntList(int bitLength, long ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeLongIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeLongIntList(int bitLength, List<Long> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeLongIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeLongIntListTo(int bitLength, long[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    static void encodeLongIntListTo(int bitLength, List<Long> elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.size(), bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeLongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeBigIntegerList(int bitLength, BigInteger ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeBigIntegerListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeBigIntegerList(int bitLength, List<BigInteger> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeBigIntegerListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBigIntegerListTo(int bitLength, BigInteger[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (BigInteger value : elements) {
            appender.accept(SSZ.encodeBigIntegerToByteArray(value, bitLength));
        }
    }

    static void encodeBigIntegerListTo(int bitLength, List<BigInteger> elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.size(), bitLength / 8));
        for (BigInteger value : elements) {
            appender.accept(SSZ.encodeBigIntegerToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeInt8List(int ... elements) {
        return SSZ.encodeIntList(8, elements);
    }

    public static Bytes encodeInt8List(List<Integer> elements) {
        return SSZ.encodeIntList(8, elements);
    }

    public static Bytes encodeInt16List(int ... elements) {
        return SSZ.encodeIntList(16, elements);
    }

    public static Bytes encodeInt16List(List<Integer> elements) {
        return SSZ.encodeIntList(16, elements);
    }

    public static Bytes encodeInt32List(int ... elements) {
        return SSZ.encodeIntList(32, elements);
    }

    public static Bytes encodeInt32List(List<Integer> elements) {
        return SSZ.encodeIntList(32, elements);
    }

    public static Bytes encodeInt64List(long ... elements) {
        return SSZ.encodeLongIntList(64, elements);
    }

    public static Bytes encodeInt64List(List<Long> elements) {
        return SSZ.encodeLongIntList(64, elements);
    }

    public static Bytes encodeUIntList(int bitLength, int ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeUIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeUIntList(int bitLength, List<Integer> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeUIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeUIntListTo(int bitLength, int[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    static void encodeUIntListTo(int bitLength, List<Integer> elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.size(), bitLength / 8));
        for (int value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeULongIntList(int bitLength, long ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeULongIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeULongIntList(int bitLength, List<Long> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeULongIntListTo(bitLength, elements, (byte[] b) -> encoded.add(Bytes.wrap((byte[])b)));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeULongIntListTo(int bitLength, long[] elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.length, bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    static void encodeULongIntListTo(int bitLength, List<Long> elements, Consumer<byte[]> appender) {
        Preconditions.checkArgument((bitLength % 8 == 0 ? 1 : 0) != 0, (Object)"bitLength must be a multiple of 8");
        appender.accept(SSZ.listLengthPrefix(elements.size(), bitLength / 8));
        for (long value : elements) {
            appender.accept(SSZ.encodeULongToByteArray(value, bitLength));
        }
    }

    public static Bytes encodeUInt8List(int ... elements) {
        return SSZ.encodeUIntList(8, elements);
    }

    public static Bytes encodeUInt8List(List<Integer> elements) {
        return SSZ.encodeUIntList(8, elements);
    }

    public static Bytes encodeUInt16List(int ... elements) {
        return SSZ.encodeUIntList(16, elements);
    }

    public static Bytes encodeUInt16List(List<Integer> elements) {
        return SSZ.encodeUIntList(16, elements);
    }

    public static Bytes encodeUInt32List(long ... elements) {
        return SSZ.encodeULongIntList(32, elements);
    }

    public static Bytes encodeUInt32List(List<Long> elements) {
        return SSZ.encodeULongIntList(32, elements);
    }

    public static Bytes encodeUInt64List(long ... elements) {
        return SSZ.encodeULongIntList(64, elements);
    }

    public static Bytes encodeUInt64List(List<Long> elements) {
        return SSZ.encodeULongIntList(64, elements);
    }

    public static Bytes encodeUInt256List(UInt256 ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeUInt256ListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeUInt256List(List<UInt256> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeUInt256ListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeUInt256ListTo(UInt256[] elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 32)));
        for (UInt256 value : elements) {
            appender.accept(SSZ.encodeUInt256(value));
        }
    }

    static void encodeUInt256ListTo(List<UInt256> elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.size(), 32)));
        for (UInt256 value : elements) {
            appender.accept(SSZ.encodeUInt256(value));
        }
    }

    public static Bytes encodeUInt384List(UInt384 ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeUInt384ListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeUInt384List(List<UInt384> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeUInt384ListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeUInt384ListTo(UInt384[] elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 32)));
        for (UInt384 value : elements) {
            appender.accept(SSZ.encodeUInt384(value));
        }
    }

    static void encodeUInt384ListTo(List<UInt384> elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.size(), 32)));
        for (UInt384 value : elements) {
            appender.accept(SSZ.encodeUInt384(value));
        }
    }

    public static Bytes encodeHashList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeHashListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeHashList(List<? extends Bytes> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeHashListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeHashListTo(Bytes[] elements, Consumer<Bytes> appender) {
        int hashLength = 0;
        for (Bytes bytes : elements) {
            if (hashLength == 0) {
                hashLength = bytes.size();
                continue;
            }
            Preconditions.checkArgument((bytes.size() == hashLength ? 1 : 0) != 0, (Object)"Hashes must be all of the same size");
        }
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 32)));
        for (Bytes bytes : elements) {
            appender.accept(bytes);
        }
    }

    static void encodeHashListTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        int hashLength = 0;
        for (Bytes bytes : elements) {
            if (hashLength == 0) {
                hashLength = bytes.size();
                continue;
            }
            Preconditions.checkArgument((bytes.size() == hashLength ? 1 : 0) != 0, (Object)"Hashes must be all of the same size");
        }
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.size(), 32)));
        for (Bytes bytes : elements) {
            appender.accept(bytes);
        }
    }

    public static Bytes encodeAddressList(Bytes ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeAddressListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeAddressList(List<? extends Bytes> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeAddressListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeAddressListTo(Bytes[] elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.length, 20)));
        for (Bytes bytes : elements) {
            appender.accept(SSZ.encodeAddress(bytes));
        }
    }

    static void encodeAddressListTo(List<? extends Bytes> elements, Consumer<Bytes> appender) {
        appender.accept(Bytes.wrap((byte[])SSZ.listLengthPrefix(elements.size(), 20)));
        for (Bytes bytes : elements) {
            appender.accept(SSZ.encodeAddress(bytes));
        }
    }

    public static Bytes encodeBooleanList(boolean ... elements) {
        ArrayList encoded = new ArrayList(elements.length + 1);
        SSZ.encodeBooleanListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    public static Bytes encodeBooleanList(List<Boolean> elements) {
        ArrayList encoded = new ArrayList(elements.size() + 1);
        SSZ.encodeBooleanListTo(elements, (Bytes b) -> encoded.add(Bytes.wrap((Bytes[])new Bytes[]{b})));
        return Bytes.wrap((Bytes[])encoded.toArray(new Bytes[0]));
    }

    static void encodeBooleanListTo(boolean[] elements, Consumer<Bytes> appender) {
        appender.accept(SSZ.encodeInt32(elements.length));
        for (boolean value : elements) {
            appender.accept(SSZ.encodeBoolean(value));
        }
    }

    static void encodeBooleanListTo(List<Boolean> elements, Consumer<Bytes> appender) {
        appender.accept(SSZ.encodeInt32(elements.size()));
        for (boolean value : elements) {
            appender.accept(SSZ.encodeBoolean(value));
        }
    }

    private static byte[] listLengthPrefix(long nElements, int elementBytes) {
        long listSize;
        try {
            listSize = Math.multiplyExact(nElements, (long)elementBytes);
        }
        catch (ArithmeticException e) {
            listSize = Long.MAX_VALUE;
        }
        if (listSize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Cannot serialize list: overall length is too large");
        }
        return SSZ.encodeLongToByteArray(listSize, 32);
    }

    public static <T> T decode(Bytes source, Function<SSZReader, T> fn) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(fn);
        return fn.apply(new BytesSSZReader(source));
    }

    public static Bytes decodeBytes(Bytes source) {
        return SSZ.decode(source, SSZReader::readBytes);
    }

    public static Bytes decodeBytes(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readBytes(limit));
    }

    public static String decodeString(Bytes source) {
        return SSZ.decode(source, SSZReader::readString);
    }

    public static String decodeString(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readString(limit));
    }

    public static int decodeInt(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readInt(bitLength));
    }

    public static long decodeLong(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readLong(bitLength));
    }

    public static BigInteger decodeBigInteger(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigInteger(bitLength));
    }

    public static int decodeInt8(Bytes source) {
        return SSZ.decodeInt(source, 8);
    }

    public static int decodeInt16(Bytes source) {
        return SSZ.decodeInt(source, 16);
    }

    public static int decodeInt32(Bytes source) {
        return SSZ.decodeInt(source, 32);
    }

    public static long decodeInt64(Bytes source) {
        return SSZ.decodeLong(source, 64);
    }

    public static int decodeUInt(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUInt(bitLength));
    }

    public static long decodeULong(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readULong(bitLength));
    }

    public static BigInteger decodeUnsignedBigInteger(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigInteger(bitLength));
    }

    public static int decodeUInt8(Bytes source) {
        return SSZ.decodeUInt(source, 8);
    }

    public static int decodeUInt16(Bytes source) {
        return SSZ.decodeUInt(source, 16);
    }

    public static long decodeUInt32(Bytes source) {
        return SSZ.decodeULong(source, 32);
    }

    public static long decodeUInt64(Bytes source) {
        return SSZ.decodeLong(source, 64);
    }

    public static UInt256 decodeUInt256(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt256);
    }

    public static UInt384 decodeUInt384(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt384);
    }

    public static boolean decodeBoolean(Bytes source) {
        return SSZ.decode(source, SSZReader::readBoolean);
    }

    public static Bytes decodeAddress(Bytes source) {
        return SSZ.decode(source, SSZReader::readAddress);
    }

    public static Bytes decodeHash(Bytes source, int hashLength) {
        return SSZ.decode(source, r -> r.readHash(hashLength));
    }

    public static List<Bytes> decodeBytesList(Bytes source) {
        return SSZ.decode(source, SSZReader::readBytesList);
    }

    public static List<Bytes> decodeBytesList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readBytesList(limit));
    }

    public static List<byte[]> decodeByteArrayList(Bytes source) {
        return SSZ.decode(source, SSZReader::readByteArrayList);
    }

    public static List<byte[]> decodeByteArrayList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readByteArrayList(limit));
    }

    public static List<String> decodeStringList(Bytes source) {
        return SSZ.decode(source, SSZReader::readStringList);
    }

    public static List<String> decodeStringList(Bytes source, int limit) {
        return SSZ.decode(source, r -> r.readStringList(limit));
    }

    public static List<Integer> decodeIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readIntList(bitLength));
    }

    public static List<Long> decodeLongIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readLongIntList(bitLength));
    }

    public static List<BigInteger> decodeBigIntegerList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readBigIntegerList(bitLength));
    }

    public static List<Integer> decodeInt8List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt8List);
    }

    public static List<Integer> decodeInt16List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt16List);
    }

    public static List<Integer> decodeInt32List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt32List);
    }

    public static List<Long> decodeInt64List(Bytes source) {
        return SSZ.decode(source, SSZReader::readInt64List);
    }

    public static List<Integer> decodeUIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUIntList(bitLength));
    }

    public static List<Long> decodeULongIntList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readULongIntList(bitLength));
    }

    public static List<BigInteger> decodeUnsignedBigIntegerList(Bytes source, int bitLength) {
        return SSZ.decode(source, r -> r.readUnsignedBigIntegerList(bitLength));
    }

    public static List<Integer> decodeUInt8List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt8List);
    }

    public static List<Integer> decodeUInt16List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt16List);
    }

    public static List<Long> decodeUInt32List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt32List);
    }

    public static List<Long> decodeUInt64List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt64List);
    }

    public static List<UInt256> decodeUInt256List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt256List);
    }

    public static List<UInt384> decodeUInt384List(Bytes source) {
        return SSZ.decode(source, SSZReader::readUInt384List);
    }

    public static List<Bytes> decodeAddressList(Bytes source) {
        return SSZ.decode(source, SSZReader::readAddressList);
    }

    public static List<Bytes> decodeHashList(Bytes source, int hashLength) {
        return SSZ.decode(source, r -> r.readHashList(hashLength));
    }

    public static List<Boolean> decodeBooleanList(Bytes source) {
        return SSZ.decode(source, SSZReader::readBooleanList);
    }
}

