/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.progpow;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.ethash.EthHash;
import org.apache.tuweni.progpow.KISS99Random;
import org.apache.tuweni.progpow.Keccakf800;
import org.apache.tuweni.progpow.ProgPoWMath;
import org.apache.tuweni.units.bigints.UInt32;
import org.apache.tuweni.units.bigints.UInt64;

public final class ProgPoW {
    static int PROGPOW_PERIOD = 50;
    static int PROGPOW_LANES = 16;
    static int PROGPOW_REGS = 32;
    static int PROGPOW_DAG_LOADS = 4;
    static int PROGPOW_CACHE_BYTES = 16384;
    static int PROGPOW_CNT_DAG = 64;
    static int PROGPOW_CNT_CACHE = 12;
    static int PROGPOW_CNT_MATH = 20;
    static UInt32 FNV_PRIME = UInt32.fromHexString((String)"0x1000193");
    static Bytes FNV_OFFSET_BASIS = Bytes.fromHexString((CharSequence)"0x811c9dc5");
    static int HASH_BYTES = 64;
    static int HASH_WORDS = 16;
    static int DATASET_PARENTS = 256;

    public static Bytes32 progPowHash(long blockNumber, long nonce, Bytes32 header, UInt32[] dag, Function<Integer, Bytes> dagLookupFunction) {
        UInt32[][] mix = new UInt32[PROGPOW_LANES][PROGPOW_REGS];
        Bytes32 seed_256 = Keccakf800.keccakF800Progpow(header, nonce, Bytes32.ZERO);
        long seed = Integer.toUnsignedLong(seed_256.getInt(0)) << 32 | Integer.toUnsignedLong(seed_256.getInt(4));
        for (int l = 0; l < PROGPOW_LANES; ++l) {
            mix[l] = ProgPoW.fillMix(UInt64.fromBytes((Bytes)Bytes.wrap((byte[])ByteBuffer.allocate(8).putLong(seed).array())), UInt32.valueOf((int)l));
        }
        for (int i = 0; i < PROGPOW_CNT_DAG; ++i) {
            ProgPoW.progPowLoop(blockNumber, UInt32.valueOf((int)i), mix, dag, dagLookupFunction);
        }
        UInt32[] digest_lane = new UInt32[PROGPOW_LANES];
        for (int l = 0; l < PROGPOW_LANES; ++l) {
            digest_lane[l] = UInt32.fromBytes((Bytes)FNV_OFFSET_BASIS);
            for (int i = 0; i < PROGPOW_REGS; ++i) {
                digest_lane[l] = ProgPoW.fnv1a(digest_lane[l], mix[l][i]);
            }
        }
        Object[] digest = new UInt32[8];
        Arrays.fill(digest, UInt32.fromBytes((Bytes)FNV_OFFSET_BASIS));
        for (int l = 0; l < PROGPOW_LANES; ++l) {
            digest[l % 8] = ProgPoW.fnv1a((UInt32)digest[l % 8], digest_lane[l]);
        }
        Bytes32 bytesDigest = Bytes32.wrap((Bytes)Bytes.concatenate((Bytes[])((Bytes[])Stream.of(digest).map(UInt32::toBytes).toArray(Bytes[]::new))));
        return Keccakf800.keccakF800Progpow(header, seed, bytesDigest);
    }

    public static UInt32[] createDagCache(long blockNumber, Function<Integer, Bytes> datasetLookup) {
        UInt32[] cdag = new UInt32[HASH_BYTES * DATASET_PARENTS];
        for (int i = 0; i < cdag.length; ++i) {
            Bytes lookup = datasetLookup.apply(i >> 4);
            cdag[i] = UInt32.fromBytes((Bytes)lookup.slice((i & 0xF) << 2, 4).reverse());
        }
        return cdag;
    }

    static KISS99Random progPowInit(UInt64 prog_seed, int[] mix_seq_src, int[] mix_seq_dst) {
        int i;
        UInt32 leftSeed = UInt32.fromBytes((Bytes)prog_seed.toBytes().slice(0, 4));
        UInt32 rightSeed = UInt32.fromBytes((Bytes)prog_seed.toBytes().slice(4));
        UInt32 z = ProgPoW.fnv1a(UInt32.fromBytes((Bytes)FNV_OFFSET_BASIS), rightSeed);
        UInt32 w = ProgPoW.fnv1a(z, leftSeed);
        UInt32 jsr = ProgPoW.fnv1a(w, rightSeed);
        UInt32 jcong = ProgPoW.fnv1a(jsr, leftSeed);
        KISS99Random prog_rnd = new KISS99Random(z, w, jsr, jcong);
        for (i = 0; i < PROGPOW_REGS; ++i) {
            mix_seq_dst[i] = i;
            mix_seq_src[i] = i;
        }
        for (i = PROGPOW_REGS - 1; i > 0; --i) {
            int j = prog_rnd.generate().mod(UInt32.valueOf((int)(i + 1))).intValue();
            int buffer = mix_seq_dst[i];
            mix_seq_dst[i] = mix_seq_dst[j];
            mix_seq_dst[j] = buffer;
            j = prog_rnd.generate().mod(UInt32.valueOf((int)(i + 1))).intValue();
            buffer = mix_seq_src[i];
            mix_seq_src[i] = mix_seq_src[j];
            mix_seq_src[j] = buffer;
        }
        return prog_rnd;
    }

    static UInt32 merge(UInt32 a, UInt32 b, UInt32 r) {
        switch (r.mod(UInt32.valueOf((int)4)).intValue()) {
            case 0: {
                return a.multiply(UInt32.valueOf((int)33)).add(b);
            }
            case 1: {
                return a.xor(b).multiply(UInt32.valueOf((int)33));
            }
            case 2: {
                return ProgPoWMath.rotl32(a, r.shiftRight(16).mod(UInt32.valueOf((int)31)).add(UInt32.ONE)).xor(b);
            }
            case 3: {
                return ProgPoWMath.rotr32(a, r.shiftRight(16).mod(UInt32.valueOf((int)31)).add(UInt32.ONE)).xor(b);
            }
        }
        throw new IllegalArgumentException("r mod 4 is larger than 4" + r.toHexString() + " " + r.mod(UInt32.valueOf((int)4)).intValue());
    }

    static UInt32[] fillMix(UInt64 seed, UInt32 laneId) {
        UInt32 z = ProgPoW.fnv1a(UInt32.fromBytes((Bytes)FNV_OFFSET_BASIS), UInt32.fromBytes((Bytes)seed.toBytes().slice(4, 4)));
        UInt32 w = ProgPoW.fnv1a(z, UInt32.fromBytes((Bytes)seed.toBytes().slice(0, 4)));
        UInt32 jsr = ProgPoW.fnv1a(w, laneId);
        UInt32 jcong = ProgPoW.fnv1a(jsr, laneId);
        KISS99Random random = new KISS99Random(z, w, jsr, jcong);
        UInt32[] mix = new UInt32[PROGPOW_REGS];
        for (int i = 0; i < mix.length; ++i) {
            mix[i] = random.generate();
        }
        return mix;
    }

    static UInt32 fnv1a(UInt32 h, UInt32 d) {
        return h.xor(d).multiply(FNV_PRIME);
    }

    static void progPowLoop(long blockNumber, UInt32 loop, UInt32[][] mix, UInt32[] dag, Function<Integer, Bytes> dagLookupFunction) {
        int i;
        long dagBytes = EthHash.getFullSize(blockNumber);
        UInt32[][] dag_entry = new UInt32[PROGPOW_LANES][PROGPOW_DAG_LOADS];
        int dag_addr_base = mix[loop.intValue() % PROGPOW_LANES][0].mod(UInt32.valueOf((int)Math.toIntExact(dagBytes / (long)(PROGPOW_LANES * PROGPOW_DAG_LOADS * 4)))).intValue();
        for (int l = 0; l < PROGPOW_LANES; ++l) {
            int dag_addr_lane = dag_addr_base * PROGPOW_LANES + Integer.remainderUnsigned(l ^ loop.intValue(), PROGPOW_LANES);
            int offset = Integer.remainderUnsigned(l ^ loop.intValue(), PROGPOW_LANES);
            for (int i2 = 0; i2 < PROGPOW_DAG_LOADS; ++i2) {
                UInt32 lookup = UInt32.valueOf((int)dag_addr_lane).divide(UInt32.valueOf((int)4)).add(offset >> 4);
                Bytes lookupHolder = dagLookupFunction.apply(lookup.intValue());
                int lookupOffset = (i2 * 4 + ((offset & 0xF) << 4)) % 64;
                dag_entry[l][i2] = UInt32.fromBytes((Bytes)lookupHolder.slice(lookupOffset, 4).reverse());
            }
        }
        int[] mix_seq_dst = new int[PROGPOW_REGS];
        int[] mix_seq_src = new int[PROGPOW_REGS];
        int mix_seq_dst_cnt = 0;
        int mix_seq_src_cnt = 0;
        KISS99Random prog_rnd = ProgPoW.progPowInit(UInt64.valueOf((long)(blockNumber / (long)PROGPOW_PERIOD)), mix_seq_src, mix_seq_dst);
        int max_i = Integer.max(PROGPOW_CNT_CACHE, PROGPOW_CNT_MATH);
        for (i = 0; i < max_i; ++i) {
            if (i < PROGPOW_CNT_CACHE) {
                int src = mix_seq_src[mix_seq_src_cnt++ % PROGPOW_REGS];
                int dst = mix_seq_dst[mix_seq_dst_cnt++ % PROGPOW_REGS];
                UInt32 sel = prog_rnd.generate();
                for (int l = 0; l < PROGPOW_LANES; ++l) {
                    UInt32 offset = mix[l][src].mod(UInt32.valueOf((int)(PROGPOW_CACHE_BYTES / 4)));
                    mix[l][dst] = ProgPoW.merge(mix[l][dst], dag[offset.intValue()], sel);
                }
            }
            if (i >= PROGPOW_CNT_MATH) continue;
            UInt32 src_rnd = prog_rnd.generate().mod(UInt32.valueOf((int)(PROGPOW_REGS * (PROGPOW_REGS - 1))));
            int src1 = src_rnd.mod(UInt32.valueOf((int)PROGPOW_REGS)).intValue();
            int src2 = src_rnd.divide(UInt32.valueOf((int)PROGPOW_REGS)).intValue();
            if (src2 >= src1) {
                ++src2;
            }
            UInt32 sel1 = prog_rnd.generate();
            int dst = mix_seq_dst[mix_seq_dst_cnt++ % PROGPOW_REGS];
            UInt32 sel2 = prog_rnd.generate();
            for (int l = 0; l < PROGPOW_LANES; ++l) {
                UInt32 data = ProgPoWMath.math(mix[l][src1], mix[l][src2], sel1);
                mix[l][dst] = ProgPoW.merge(mix[l][dst], data, sel2);
            }
        }
        for (i = 0; i < PROGPOW_DAG_LOADS; ++i) {
            int dst = i == 0 ? 0 : mix_seq_dst[mix_seq_dst_cnt++ % PROGPOW_REGS];
            UInt32 sel = prog_rnd.generate();
            for (int l = 0; l < PROGPOW_LANES; ++l) {
                mix[l][dst] = ProgPoW.merge(mix[l][dst], dag_entry[l][i], sel);
            }
        }
    }
}

