/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.ethash;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.crypto.Hash;
import org.apache.tuweni.units.bigints.UInt32;

public class EthHash {
    public static int WORD_BYTES = 4;
    public static long DATASET_BYTES_INIT = (long)Math.pow(2.0, 30.0);
    public static long DATASET_BYTES_GROWTH = (long)Math.pow(2.0, 23.0);
    public static long CACHE_BYTES_INIT = (long)Math.pow(2.0, 24.0);
    public static long CACHE_BYTES_GROWTH = (long)Math.pow(2.0, 17.0);
    public static int CACHE_MULTIPLIER = 1024;
    public static int EPOCH_LENGTH = 30000;
    public static int MIX_BYTES = 128;
    public static int HASH_BYTES = 64;
    private static int HASH_WORDS = HASH_BYTES / WORD_BYTES;
    public static int DATASET_PARENTS = 256;
    public static int CACHE_ROUNDS = 3;
    public static int ACCESSES = 64;
    public static int FNV_PRIME = 16777619;

    public static long epoch(long block) {
        return block / (long)EPOCH_LENGTH;
    }

    public static int getCacheSize(long block_number) {
        long sz = CACHE_BYTES_INIT + CACHE_BYTES_GROWTH * (block_number / (long)EPOCH_LENGTH);
        sz -= (long)HASH_BYTES;
        while (!EthHash.isPrime(sz / (long)HASH_BYTES)) {
            sz -= (long)(2 * HASH_BYTES);
        }
        return (int)sz;
    }

    public static long getFullSize(long block_number) {
        long sz = DATASET_BYTES_INIT + DATASET_BYTES_GROWTH * (block_number / (long)EPOCH_LENGTH);
        sz -= (long)MIX_BYTES;
        while (!EthHash.isPrime(sz / (long)MIX_BYTES)) {
            sz -= (long)(2 * MIX_BYTES);
        }
        return sz;
    }

    public static UInt32[] mkCache(int cacheSize, long block) {
        int rows = cacheSize / HASH_BYTES;
        ArrayList<Bytes> cache = new ArrayList<Bytes>(rows);
        cache.add(Hash.keccak512((Bytes)EthHash.dagSeed(block)));
        for (int i = 1; i < rows; ++i) {
            cache.add(Hash.keccak512((Bytes)((Bytes)cache.get(i - 1))));
        }
        Bytes completeCache = Bytes.concatenate((Bytes[])cache.toArray(new Bytes[cache.size()]));
        byte[] temp = new byte[HASH_BYTES];
        for (int i = 0; i < CACHE_ROUNDS; ++i) {
            for (int j = 0; j < rows; ++j) {
                int offset = j * HASH_BYTES;
                for (int k = 0; k < HASH_BYTES; ++k) {
                    temp[k] = (byte)(completeCache.get((j - 1 + rows) % rows * HASH_BYTES + k) ^ completeCache.get(Integer.remainderUnsigned(completeCache.getInt(offset, ByteOrder.LITTLE_ENDIAN), rows) * HASH_BYTES + k));
                }
                temp = Hash.keccak512((byte[])temp);
                System.arraycopy(temp, 0, completeCache.toArrayUnsafe(), offset, HASH_BYTES);
            }
        }
        UInt32[] result = new UInt32[completeCache.size() / 4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = UInt32.fromBytes((Bytes)completeCache.slice(i * 4, 4).reverse());
        }
        return result;
    }

    public static Bytes calcDatasetItem(UInt32[] cache, int index) {
        int i;
        int rows = cache.length / HASH_WORDS;
        UInt32[] mixInts = new UInt32[HASH_BYTES / 4];
        int offset = index % rows * HASH_WORDS;
        mixInts[0] = cache[offset].xor(UInt32.valueOf((int)index));
        System.arraycopy(cache, offset + 1, mixInts, 1, HASH_WORDS - 1);
        Bytes buffer = EthHash.intToByte(mixInts);
        buffer = Hash.keccak512((Bytes)buffer);
        for (i = 0; i < mixInts.length; ++i) {
            mixInts[i] = UInt32.fromBytes((Bytes)buffer.slice(i * 4, 4).reverse());
        }
        for (i = 0; i < DATASET_PARENTS; ++i) {
            EthHash.fnvHash(mixInts, cache, EthHash.fnv(UInt32.valueOf((int)index).xor(UInt32.valueOf((int)i)), mixInts[i % 16]).mod(UInt32.valueOf((int)rows)).multiply(UInt32.valueOf((int)HASH_WORDS)));
        }
        return Hash.keccak512((Bytes)EthHash.intToByte(mixInts));
    }

    private static Bytes dagSeed(long block) {
        Bytes32 seed = Bytes32.wrap((byte[])new byte[32]);
        if (Long.compareUnsigned(block, EPOCH_LENGTH) >= 0) {
            int i = 0;
            while ((long)i < Long.divideUnsigned(block, EPOCH_LENGTH)) {
                seed = Hash.keccak256((Bytes)seed);
                ++i;
            }
        }
        return seed;
    }

    private static UInt32 fnv(UInt32 v1, UInt32 v2) {
        return v1.multiply(FNV_PRIME).xor(v2);
    }

    private static void fnvHash(UInt32[] mix, UInt32[] cache, UInt32 offset) {
        for (int i = 0; i < mix.length; ++i) {
            mix[i] = EthHash.fnv(mix[i], cache[offset.intValue() + i]);
        }
    }

    private static Bytes intToByte(UInt32[] ints) {
        return Bytes.concatenate((Bytes[])((Bytes[])Stream.of(ints).map(i -> i.toBytes().reverse()).toArray(Bytes[]::new)));
    }

    private static boolean isPrime(long number) {
        return number > 2L && IntStream.rangeClosed(2, (int)Math.sqrt(number)).noneMatch(n -> number % (long)n == 0L);
    }
}

