/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.plumtree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.plumtree.MessageHashing;
import org.apache.tuweni.plumtree.MessageListener;
import org.apache.tuweni.plumtree.MessageSender;
import org.apache.tuweni.plumtree.MessageValidator;
import org.apache.tuweni.plumtree.Peer;
import org.apache.tuweni.plumtree.PeerPruning;
import org.apache.tuweni.plumtree.PeerRepository;

public final class State {
    private final PeerRepository peerRepository;
    private final MessageHashing messageHashingFunction;
    private final int maxMessagesHandlers = 1000000;
    private final Map<Bytes, MessageHandler> messageHandlers = Collections.synchronizedMap(new LinkedHashMap<Bytes, MessageHandler>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Bytes, MessageHandler> eldest) {
            return super.size() > 1000000;
        }
    });
    private final MessageSender messageSender;
    private final MessageListener messageListener;
    private final MessageValidator messageValidator;
    private final PeerPruning peerPruningFunction;
    final Queue<Runnable> lazyQueue = new ConcurrentLinkedQueue<Runnable>();
    private final Timer timer = new Timer("plumtree", true);
    private final long delay;

    public State(PeerRepository peerRepository, MessageHashing messageHashingFunction, MessageSender messageSender, MessageListener messageListener, MessageValidator messageValidator, PeerPruning peerPruningFunction) {
        this(peerRepository, messageHashingFunction, messageSender, messageListener, messageValidator, peerPruningFunction, 5000L, 5000L);
    }

    public State(PeerRepository peerRepository, MessageHashing messageHashingFunction, MessageSender messageSender, MessageListener messageListener, MessageValidator messageValidator, PeerPruning peerPruningFunction, long graftDelay, long lazyQueueInterval) {
        this.peerRepository = peerRepository;
        this.messageHashingFunction = messageHashingFunction;
        this.messageSender = messageSender;
        this.messageListener = messageListener;
        this.messageValidator = messageValidator;
        this.peerPruningFunction = peerPruningFunction;
        this.delay = graftDelay;
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                State.this.processQueue();
            }
        }, lazyQueueInterval, lazyQueueInterval);
    }

    public void addPeer(Peer peer) {
        this.peerRepository.addEager(peer);
    }

    public void removePeer(Peer peer) {
        this.peerRepository.removePeer(peer);
    }

    public void receiveGossipMessage(Peer peer, String attributes, Bytes message, Bytes messageHash) {
        Bytes checkHash = this.messageHashingFunction.hash(message);
        if (!checkHash.equals(messageHash)) {
            return;
        }
        this.peerRepository.considerNewPeer(peer);
        MessageHandler handler = this.messageHandlers.computeIfAbsent(messageHash, x$0 -> new MessageHandler((Bytes)x$0));
        handler.fullMessageReceived(peer, attributes, message);
    }

    public void receiveIHaveMessage(Peer peer, Bytes messageHash) {
        MessageHandler handler = this.messageHandlers.computeIfAbsent(messageHash, x$0 -> new MessageHandler((Bytes)x$0));
        handler.partialMessageReceived(peer);
    }

    public void receivePruneMessage(Peer peer) {
        this.peerRepository.moveToLazy(peer);
    }

    public void receiveGraftMessage(Peer peer, Bytes messageHash) {
        this.peerRepository.moveToEager(peer);
        this.messageSender.sendMessage(MessageSender.Verb.GOSSIP, null, peer, messageHash, null);
    }

    public Bytes sendGossipMessage(String attributes, Bytes message) {
        Bytes messageHash = this.messageHashingFunction.hash(message);
        MessageHandler handler = this.messageHandlers.computeIfAbsent(messageHash, x$0 -> new MessageHandler((Bytes)x$0));
        handler.fullMessageReceived(null, attributes, message);
        return messageHash;
    }

    void processQueue() {
        ArrayList<Runnable> executed = new ArrayList<Runnable>();
        for (Runnable r : this.lazyQueue) {
            r.run();
            executed.add(r);
        }
        this.lazyQueue.removeAll(executed);
    }

    public void stop() {
        this.timer.cancel();
    }

    final class MessageHandler {
        private final Bytes hash;
        private final AtomicBoolean receivedFullMessage = new AtomicBoolean(false);
        private final AtomicBoolean requestingGraftMessage = new AtomicBoolean(false);
        private List<TimerTask> tasks = new ArrayList<TimerTask>();
        private List<Peer> lazyPeers = new ArrayList<Peer>();

        MessageHandler(Bytes hash) {
            this.hash = hash;
        }

        void fullMessageReceived(@Nullable Peer sender, String attributes, Bytes message) {
            if (this.receivedFullMessage.compareAndSet(false, true)) {
                for (TimerTask task : this.tasks) {
                    task.cancel();
                }
                if (sender == null || State.this.messageValidator.validate(message, sender)) {
                    for (Peer peer2 : State.this.peerRepository.eagerPushPeers()) {
                        if (sender != null && sender.equals(peer2)) continue;
                        State.this.messageSender.sendMessage(MessageSender.Verb.GOSSIP, attributes, peer2, this.hash, message);
                    }
                    State.this.lazyQueue.addAll(State.this.peerRepository.lazyPushPeers().stream().filter(p -> !this.lazyPeers.contains(p)).map(peer -> () -> State.this.messageSender.sendMessage(MessageSender.Verb.IHAVE, null, (Peer)peer, this.hash, null)).collect(Collectors.toList()));
                    if (sender != null) {
                        State.this.messageListener.listen(message, attributes);
                    }
                }
            } else if (sender != null && State.this.peerPruningFunction.prunePeer(sender)) {
                State.this.messageSender.sendMessage(MessageSender.Verb.PRUNE, null, sender, this.hash, null);
            }
        }

        private void scheduleGraftMessage(final int index) {
            TimerTask timerTask = new TimerTask(){

                @Override
                public void run() {
                    int newPeerIndex = index;
                    if (newPeerIndex == MessageHandler.this.lazyPeers.size()) {
                        newPeerIndex = 0;
                    }
                    State.this.messageSender.sendMessage(MessageSender.Verb.GRAFT, null, MessageHandler.this.lazyPeers.get(index), MessageHandler.this.hash, null);
                    MessageHandler.this.scheduleGraftMessage(newPeerIndex++);
                }
            };
            this.tasks.add(timerTask);
            State.this.timer.schedule(timerTask, State.this.delay);
        }

        void partialMessageReceived(Peer peer) {
            if (!this.receivedFullMessage.get()) {
                this.lazyPeers.add(peer);
                if (this.requestingGraftMessage.compareAndSet(false, true)) {
                    this.scheduleGraftMessage(0);
                }
            }
        }
    }
}

