/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.ip;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.net.util.SubnetUtils;

public class IPRangeChecker {
    private final List<SubnetUtils> allowedRanges;
    private final List<SubnetUtils> rejectedRanges;

    public static IPRangeChecker create(List<String> allowedRanges, List<String> rejectedRanges) {
        ArrayList<SubnetUtils> allowed = new ArrayList<SubnetUtils>();
        ArrayList<SubnetUtils> rejected = new ArrayList<SubnetUtils>();
        for (String iprange : allowedRanges) {
            allowed.add(new SubnetUtils(iprange));
        }
        for (String iprange : rejectedRanges) {
            rejected.add(new SubnetUtils(iprange));
        }
        return new IPRangeChecker(allowed, rejected);
    }

    public static IPRangeChecker allowAll() {
        return IPRangeChecker.create(Collections.singletonList("0.0.0.0/0"), Collections.emptyList());
    }

    private IPRangeChecker(List<SubnetUtils> allowedRanges, List<SubnetUtils> rejectedRanges) {
        this.allowedRanges = allowedRanges;
        this.rejectedRanges = rejectedRanges;
    }

    public boolean check(String ip) {
        for (SubnetUtils subnetUtils : this.allowedRanges) {
            if (subnetUtils.getInfo().isInRange(ip)) continue;
            return false;
        }
        for (SubnetUtils subnetUtils : this.rejectedRanges) {
            if (!subnetUtils.getInfo().isInRange(ip)) continue;
            return false;
        }
        return true;
    }
}

