/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.net.tls;

import io.netty.handler.ssl.util.SimpleTrustManagerFactory;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

final class DelegatingTrustManagerFactory
extends SimpleTrustManagerFactory {
    private static final X509Certificate[] EMPTY_X509_CERTIFICATES = new X509Certificate[0];
    private final TrustManagerFactory delegate;
    private final X509TrustManager fallback;
    private final TrustManager[] trustManagers;

    DelegatingTrustManagerFactory(TrustManagerFactory delegate, X509TrustManager fallback) {
        Objects.requireNonNull(delegate);
        Objects.requireNonNull(fallback);
        this.delegate = delegate;
        this.fallback = fallback;
        this.trustManagers = new TrustManager[]{new DelegatingTrustManager()};
    }

    protected void engineInit(KeyStore keyStore) throws Exception {
        this.delegate.init(keyStore);
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws Exception {
        this.delegate.init(managerFactoryParameters);
    }

    protected TrustManager[] engineGetTrustManagers() {
        return this.trustManagers;
    }

    private class DelegatingTrustManager
    extends X509ExtendedTrustManager {
        private DelegatingTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                    ((X509ExtendedTrustManager)trustManager).checkClientTrusted(chain, authType, socket);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                if (DelegatingTrustManagerFactory.this.fallback instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)DelegatingTrustManagerFactory.this.fallback).checkClientTrusted(chain, authType, socket);
                } else {
                    DelegatingTrustManagerFactory.this.fallback.checkClientTrusted(chain, authType);
                }
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                    ((X509ExtendedTrustManager)trustManager).checkServerTrusted(chain, authType, socket);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                if (DelegatingTrustManagerFactory.this.fallback instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)DelegatingTrustManagerFactory.this.fallback).checkServerTrusted(chain, authType, socket);
                } else {
                    DelegatingTrustManagerFactory.this.fallback.checkServerTrusted(chain, authType);
                }
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                    ((X509ExtendedTrustManager)trustManager).checkClientTrusted(chain, authType, engine);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                if (DelegatingTrustManagerFactory.this.fallback instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)DelegatingTrustManagerFactory.this.fallback).checkClientTrusted(chain, authType, engine);
                } else {
                    DelegatingTrustManagerFactory.this.fallback.checkClientTrusted(chain, authType);
                }
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509ExtendedTrustManager)) continue;
                    ((X509ExtendedTrustManager)trustManager).checkServerTrusted(chain, authType, engine);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                if (DelegatingTrustManagerFactory.this.fallback instanceof X509ExtendedTrustManager) {
                    ((X509ExtendedTrustManager)DelegatingTrustManagerFactory.this.fallback).checkServerTrusted(chain, authType, engine);
                } else {
                    DelegatingTrustManagerFactory.this.fallback.checkServerTrusted(chain, authType);
                }
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    ((X509TrustManager)trustManager).checkClientTrusted(chain, authType);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                DelegatingTrustManagerFactory.this.fallback.checkClientTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            CertificateException caException = null;
            try {
                for (TrustManager trustManager : DelegatingTrustManagerFactory.this.delegate.getTrustManagers()) {
                    if (!(trustManager instanceof X509TrustManager)) continue;
                    ((X509TrustManager)trustManager).checkServerTrusted(chain, authType);
                    return;
                }
            }
            catch (CertificateException e) {
                caException = e;
            }
            try {
                DelegatingTrustManagerFactory.this.fallback.checkServerTrusted(chain, authType);
            }
            catch (CertificateException e) {
                if (caException != null) {
                    e.addSuppressed(caException);
                }
                throw e;
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return EMPTY_X509_CERTIFICATES;
        }
    }
}

