/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.eth.repository;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.BytesRef;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.eth.Address;
import org.apache.tuweni.eth.BlockHeader;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.eth.Log;
import org.apache.tuweni.eth.Transaction;
import org.apache.tuweni.eth.TransactionReceipt;
import org.apache.tuweni.eth.repository.BlockHeaderFields;
import org.apache.tuweni.eth.repository.BlockchainIndexReader;
import org.apache.tuweni.eth.repository.BlockchainIndexWriter;
import org.apache.tuweni.eth.repository.IndexReadException;
import org.apache.tuweni.eth.repository.IndexWriteException;
import org.apache.tuweni.eth.repository.TransactionReceiptFields;
import org.apache.tuweni.units.bigints.UInt256;
import org.apache.tuweni.units.ethereum.Gas;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 ?2\u00020\u00012\u00020\u0002:\u0001?B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0015H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0011H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0012H\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\fH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\tH\u0016J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0013H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0014H\u0016J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001dH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u001dH\u0002J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\t2\u0006\u0010 \u001a\u00020\tH\u0016J\u001a\u0010\u0018\u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020!0#J\u0010\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)H\u0016J(\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011H\u0016J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u000202H\u0002J$\u0010/\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00101\u001a\u000202H\u0002J\u0016\u00105\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u000202H\u0002J$\u00105\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u00101\u001a\u000202H\u0002J$\u00107\u001a\b\u0012\u0004\u0012\u0002000\u000b2\u0006\u00101\u001a\u0002022\f\u00103\u001a\b\u0012\u0004\u0012\u0002080\u000bH\u0002J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010:\u001a\u00020\u0011H\u0002J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010;\u001a\u00020\tH\u0002J\u0010\u00109\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u0013H\u0002J\u0012\u0010=\u001a\u0004\u0018\u00010\t2\u0006\u0010>\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006@"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainIndex;", "Lorg/apache/tuweni/eth/repository/BlockchainIndexWriter;", "Lorg/apache/tuweni/eth/repository/BlockchainIndexReader;", "indexWriter", "Lorg/apache/lucene/index/IndexWriter;", "(Lorg/apache/lucene/index/IndexWriter;)V", "searcherManager", "Lorg/apache/lucene/search/SearcherManager;", "chainHeadTotalDifficulty", "Lorg/apache/tuweni/units/bigints/UInt256;", "findBy", "", "Lorg/apache/tuweni/eth/Hash;", "field", "Lorg/apache/tuweni/eth/repository/BlockHeaderFields;", "value", "", "Lorg/apache/tuweni/bytes/Bytes;", "Lorg/apache/tuweni/eth/Address;", "Lorg/apache/tuweni/units/ethereum/Gas;", "Lorg/apache/tuweni/eth/repository/TransactionReceiptFields;", "", "findByBlockHashAndIndex", "blockHash", "index", "findByHashOrNumber", "hashOrNumber", "findByLargest", "findByOneTerm", "Lorg/apache/lucene/util/BytesRef;", "findInRange", "minValue", "maxValue", "", "indexer", "Lkotlin/Function1;", "indexBlockHeader", "blockHeader", "Lorg/apache/tuweni/eth/BlockHeader;", "indexTransaction", "transaction", "Lorg/apache/tuweni/eth/Transaction;", "indexTransactionReceipt", "txReceipt", "Lorg/apache/tuweni/eth/TransactionReceipt;", "txIndex", "txHash", "queryBlockDocs", "Lorg/apache/lucene/document/Document;", "query", "Lorg/apache/lucene/search/Query;", "fields", "queryBlocks", "queryTxReceiptDocs", "queryTxReceipts", "search", "", "toBytesRef", "bytes", "uint", "gas", "totalDifficulty", "hash", "Companion", "eth-repository"})
public final class BlockchainIndex
implements BlockchainIndexWriter,
BlockchainIndexReader {
    private final SearcherManager searcherManager;
    private final IndexWriter indexWriter;
    private static final int HITS = 10;
    public static final Companion Companion = new Companion(null);

    public final void index(@NotNull Function1<? super BlockchainIndexWriter, Unit> indexer) {
        Intrinsics.checkParameterIsNotNull(indexer, (String)"indexer");
        try {
            indexer.invoke((Object)this);
            try {
                this.indexWriter.commit();
                this.searcherManager.maybeRefresh();
            }
            catch (IOException e) {
                throw (Throwable)new IndexWriteException(e);
            }
        }
        catch (Throwable t) {
            try {
                this.indexWriter.rollback();
            }
            catch (IOException e) {
                throw (Throwable)new IndexWriteException(e);
            }
            throw t;
        }
    }

    @Override
    public void indexBlockHeader(@NotNull BlockHeader blockHeader) {
        Object object;
        BytesRef id;
        List document;
        block10: {
            StringField stringField;
            Collection collection;
            Hash hash;
            block9: {
                Unit unit;
                Intrinsics.checkParameterIsNotNull((Object)blockHeader, (String)"blockHeader");
                document = new ArrayList();
                Hash hash2 = blockHeader.getHash();
                Intrinsics.checkExpressionValueIsNotNull((Object)hash2, (String)"blockHeader.getHash()");
                id = this.toBytesRef((Bytes)hash2);
                document.add(new StringField("_id", id, Field.Store.YES));
                document.add(new StringField("_type", "block", Field.Store.NO));
                hash = blockHeader.getParentHash();
                if (hash == null) break block9;
                object = hash;
                Hash hash3 = object;
                boolean bl = false;
                Hash hash4 = hash3;
                Intrinsics.checkExpressionValueIsNotNull((Object)hash4, (String)"hash");
                BytesRef hashRef = this.toBytesRef((Bytes)hash4);
                collection = document;
                stringField = new StringField(BlockHeaderFields.PARENT_HASH.getFieldName(), hashRef, Field.Store.NO);
                collection.add(stringField);
                Document document2 = (Document)CollectionsKt.firstOrNull(this.queryBlockDocs((Query)new TermQuery(new Term("_id", hashRef)), CollectionsKt.listOf((Object)((Object)BlockHeaderFields.TOTAL_DIFFICULTY))));
                if (document2 != null) {
                    Collection it = collection = document2;
                    boolean bl2 = false;
                    IndexableField indexableField = it.getField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
                    if (indexableField != null) {
                        IndexableField indexableField2;
                        IndexableField it2 = indexableField2 = indexableField;
                        boolean bl3 = false;
                        UInt256 totalDifficulty = blockHeader.getDifficulty().add(UInt256.fromBytes((Bytes)Bytes.wrap((byte[])it2.binaryValue().bytes)));
                        Bytes32 bytes32 = totalDifficulty.toBytes();
                        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"totalDifficulty.toBytes()");
                        BytesRef diffBytes = this.toBytesRef((Bytes)bytes32);
                        Collection collection2 = document;
                        StringField stringField2 = new StringField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes, Field.Store.YES);
                        collection2.add(stringField2);
                        collection2 = document;
                        stringField2 = new SortedDocValuesField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes);
                        collection2.add(stringField2);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                } else {
                    unit = null;
                }
                hash = unit;
                if (unit != null) break block10;
            }
            object = this;
            BlockchainIndex $this$run = (BlockchainIndex)object;
            boolean bl = false;
            Bytes32 bytes32 = blockHeader.getDifficulty().toBytes();
            Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"blockHeader.getDifficulty().toBytes()");
            BytesRef diffBytes = $this$run.toBytesRef((Bytes)bytes32);
            collection = document;
            stringField = new StringField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes, Field.Store.YES);
            collection.add(stringField);
            collection = document;
            stringField = new SortedDocValuesField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), diffBytes);
            collection.add(stringField);
            hash = Unit.INSTANCE;
        }
        object = document;
        String string = BlockHeaderFields.OMMERS_HASH.getFieldName();
        Hash hash = blockHeader.getOmmersHash();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"blockHeader.getOmmersHash()");
        StringField stringField = new StringField(string, this.toBytesRef((Bytes)hash), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string2 = BlockHeaderFields.COINBASE.getFieldName();
        Address address = blockHeader.getCoinbase();
        Intrinsics.checkExpressionValueIsNotNull((Object)address, (String)"blockHeader.getCoinbase()");
        stringField = new StringField(string2, this.toBytesRef((Bytes)address), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string3 = BlockHeaderFields.STATE_ROOT.getFieldName();
        Hash hash5 = blockHeader.getStateRoot();
        Intrinsics.checkExpressionValueIsNotNull((Object)hash5, (String)"blockHeader.getStateRoot()");
        stringField = new StringField(string3, this.toBytesRef((Bytes)hash5), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string4 = BlockHeaderFields.DIFFICULTY.getFieldName();
        UInt256 uInt256 = blockHeader.getDifficulty();
        Intrinsics.checkExpressionValueIsNotNull((Object)uInt256, (String)"blockHeader.getDifficulty()");
        stringField = new StringField(string4, this.toBytesRef(uInt256), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string5 = BlockHeaderFields.NUMBER.getFieldName();
        UInt256 uInt2562 = blockHeader.getNumber();
        Intrinsics.checkExpressionValueIsNotNull((Object)uInt2562, (String)"blockHeader.getNumber()");
        stringField = new StringField(string5, this.toBytesRef(uInt2562), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string6 = BlockHeaderFields.GAS_LIMIT.getFieldName();
        Gas gas = blockHeader.getGasLimit();
        Intrinsics.checkExpressionValueIsNotNull((Object)gas, (String)"blockHeader.getGasLimit()");
        stringField = new StringField(string6, this.toBytesRef(gas), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string7 = BlockHeaderFields.GAS_USED.getFieldName();
        Gas gas2 = blockHeader.getGasUsed();
        Intrinsics.checkExpressionValueIsNotNull((Object)gas2, (String)"blockHeader.getGasUsed()");
        stringField = new StringField(string7, this.toBytesRef(gas2), Field.Store.NO);
        object.add(stringField);
        object = document;
        String string8 = BlockHeaderFields.EXTRA_DATA.getFieldName();
        Bytes bytes = blockHeader.getExtraData();
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"blockHeader.getExtraData()");
        stringField = new StringField(string8, this.toBytesRef(bytes), Field.Store.NO);
        object.add(stringField);
        object = document;
        stringField = new NumericDocValuesField(BlockHeaderFields.TIMESTAMP.getFieldName(), blockHeader.getTimestamp().toEpochMilli());
        object.add(stringField);
        try {
            this.indexWriter.updateDocument(new Term("_id", id), (Iterable)document);
        }
        catch (IOException e) {
            throw (Throwable)new IndexWriteException(e);
        }
    }

    @Override
    public void indexTransaction(@NotNull Transaction transaction) {
        Intrinsics.checkParameterIsNotNull((Object)transaction, (String)"transaction");
    }

    @Override
    public void indexTransactionReceipt(@NotNull TransactionReceipt txReceipt, int txIndex, @NotNull Bytes txHash, @NotNull Bytes blockHash) {
        Log it;
        Object object;
        Object object2;
        Object log2;
        Intrinsics.checkParameterIsNotNull((Object)txReceipt, (String)"txReceipt");
        Intrinsics.checkParameterIsNotNull((Object)txHash, (String)"txHash");
        Intrinsics.checkParameterIsNotNull((Object)blockHash, (String)"blockHash");
        List document = new ArrayList();
        BytesRef id = this.toBytesRef(txHash);
        Collection collection = document;
        Object object3 = new StringField("_id", id, Field.Store.YES);
        collection.add(object3);
        collection = document;
        object3 = new StringField("_type", "txReceipt", Field.Store.NO);
        collection.add(object3);
        collection = document;
        object3 = new NumericDocValuesField(TransactionReceiptFields.INDEX.getFieldName(), (long)txIndex);
        collection.add(object3);
        collection = document;
        object3 = new StringField(TransactionReceiptFields.TRANSACTION_HASH.getFieldName(), id, Field.Store.NO);
        collection.add(object3);
        collection = document;
        object3 = new StringField(TransactionReceiptFields.BLOCK_HASH.getFieldName(), this.toBytesRef(blockHash), Field.Store.NO);
        collection.add(object3);
        for (Object log2 : txReceipt.getLogs()) {
            Collection collection2 = document;
            String string = TransactionReceiptFields.LOGGER.getFieldName();
            Address address = log2.getLogger();
            Intrinsics.checkExpressionValueIsNotNull((Object)address, (String)"log.getLogger()");
            object2 = new StringField(string, this.toBytesRef((Bytes)address), Field.Store.NO);
            collection2.add(object2);
            for (Bytes32 logTopic : log2.getTopics()) {
                object = document;
                String string2 = TransactionReceiptFields.LOG_TOPIC.getFieldName();
                Bytes32 bytes32 = logTopic;
                Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"logTopic");
                StringField stringField = new StringField(string2, this.toBytesRef((Bytes)bytes32), Field.Store.NO);
                object.add(stringField);
            }
        }
        Bytes32 bytes32 = txReceipt.getStateRoot();
        if (bytes32 != null) {
            log2 = bytes32;
            it = log2;
            boolean bl = false;
            object2 = document;
            object = new StringField(TransactionReceiptFields.STATE_ROOT.getFieldName(), this.toBytesRef((Bytes)it), Field.Store.NO);
            object2.add(object);
        }
        log2 = document;
        String string = TransactionReceiptFields.BLOOM_FILTER.getFieldName();
        Bytes bytes = txReceipt.getBloomFilter().toBytes();
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes, (String)"txReceipt.getBloomFilter().toBytes()");
        it = new StringField(string, this.toBytesRef(bytes), Field.Store.NO);
        log2.add(it);
        log2 = document;
        it = new NumericDocValuesField(TransactionReceiptFields.CUMULATIVE_GAS_USED.getFieldName(), txReceipt.getCumulativeGasUsed());
        log2.add(it);
        Integer n = txReceipt.getStatus();
        if (n != null) {
            log2 = n;
            int it2 = ((Number)log2).intValue();
            boolean bl = false;
            object2 = document;
            object = new NumericDocValuesField(TransactionReceiptFields.STATUS.getFieldName(), (long)it2);
            object2.add(object);
        }
        try {
            this.indexWriter.updateDocument(new Term("_id", id), (Iterable)document);
        }
        catch (IOException e) {
            throw (Throwable)new IndexWriteException(e);
        }
    }

    private final List<Document> queryBlockDocs(Query query) {
        return this.queryBlockDocs(query, CollectionsKt.emptyList());
    }

    private final List<Document> queryTxReceiptDocs(Query query) {
        return this.queryTxReceiptDocs(query, CollectionsKt.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Document> queryTxReceiptDocs(Query query, List<? extends BlockHeaderFields> fields) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        BooleanQuery txQuery;
        BooleanQuery booleanQuery = txQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "txReceipt")), BooleanClause.Occur.MUST).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"txQuery");
        Iterable iterable = fields;
        Query query2 = (Query)booleanQuery;
        BlockchainIndex blockchainIndex = this;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            BlockHeaderFields blockHeaderFields = (BlockHeaderFields)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getFieldName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return blockchainIndex.search(query2, (List<String>)collection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<Document> search(Query query, List<String> fields) {
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            if (indexSearcher == null) {
                Intrinsics.throwNpe();
            }
            TopDocs topDocs = indexSearcher.search(query, HITS);
            List docs = new ArrayList();
            for (ScoreDoc hit : topDocs.scoreDocs) {
                Document doc = searcher.doc(hit.doc, SetsKt.plus((Set)SetsKt.setOf((Object)"_id"), (Iterable)fields));
                Collection collection = docs;
                collection.add(doc);
            }
            List list = docs;
            return list;
        }
        catch (IOException e) {
            throw (Throwable)new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Document> queryBlockDocs(Query query, List<? extends BlockHeaderFields> fields) {
        Collection<String> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        BooleanQuery blockQuery;
        BooleanQuery booleanQuery = blockQuery = new BooleanQuery.Builder().add(query, BooleanClause.Occur.MUST).add((Query)new TermQuery(new Term("_type", "block")), BooleanClause.Occur.MUST).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"blockQuery");
        Iterable iterable = fields;
        Query query2 = (Query)booleanQuery;
        BlockchainIndex blockchainIndex = this;
        void var5_7 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            BlockHeaderFields blockHeaderFields = (BlockHeaderFields)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.getFieldName();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        return blockchainIndex.search(query2, (List<String>)collection);
    }

    private final List<Hash> queryBlocks(Query query) {
        List hashes = new ArrayList();
        for (Document doc : this.queryBlockDocs(query)) {
            BytesRef bytes = doc.getBinaryValue("_id");
            Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
            Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"Hash.fromBytes(Bytes32.wrap(bytes.bytes))");
            hashes.add(hash);
        }
        return hashes;
    }

    private final List<Hash> queryTxReceipts(Query query) {
        List hashes = new ArrayList();
        for (Document doc : this.queryTxReceiptDocs(query)) {
            BytesRef bytes = doc.getBinaryValue("_id");
            Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
            Intrinsics.checkExpressionValueIsNotNull((Object)hash, (String)"Hash.fromBytes(Bytes32.wrap(bytes.bytes))");
            hashes.add(hash);
        }
        return hashes;
    }

    @Override
    @NotNull
    public List<Hash> findInRange(@NotNull BlockHeaderFields field, @NotNull UInt256 minValue, @NotNull UInt256 maxValue) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)minValue, (String)"minValue");
        Intrinsics.checkParameterIsNotNull((Object)maxValue, (String)"maxValue");
        return this.queryBlocks((Query)new TermRangeQuery(field.getFieldName(), this.toBytesRef(minValue), this.toBytesRef(maxValue), true, true));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Bytes value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, long value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Query query = NumericDocValuesField.newSlowExactQuery((String)field.getFieldName(), (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"NumericDocValuesField.ne\u2026y(field.fieldName, value)");
        return this.queryBlocks(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Hash findByLargest(@NotNull BlockHeaderFields field) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            if (indexSearcher == null) {
                Intrinsics.throwNpe();
            }
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "block")), HITS, new Sort(new SortField[]{SortField.FIELD_SCORE, new SortField(field.getFieldName(), SortField.Type.DOC, true)}));
            int n = 0;
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            int n2 = scoreDocArray.length;
            if (n < n2) {
                ScoreDoc hit = scoreDocArray[n];
                Document doc = searcher.doc(hit.doc, SetsKt.setOf((Object)"_id"));
                BytesRef bytes = doc.getBinaryValue("_id");
                Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
                return hash;
            }
            Hash hash = null;
            return hash;
        }
        catch (IOException e) {
            throw (Throwable)new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public UInt256 chainHeadTotalDifficulty() {
        UInt256 uInt256;
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            if (indexSearcher == null) {
                Intrinsics.throwNpe();
            }
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "block")), 1, new Sort(new SortField[]{SortField.FIELD_SCORE, new SortField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName(), SortField.Type.DOC, true)}));
            UInt256 uInt2562 = topDocs.scoreDocs;
            Intrinsics.checkExpressionValueIsNotNull((Object)uInt2562, (String)"topDocs.scoreDocs");
            UInt256 uInt2563 = uInt2562;
            if (((ScoreDoc[])uInt2563).length == 0) {
                UInt256 uInt2564 = UInt256.ZERO;
                Intrinsics.checkExpressionValueIsNotNull((Object)uInt2564, (String)"UInt256.ZERO");
                uInt2563 = uInt2564;
                return uInt2563;
            }
            Document doc = searcher.doc(topDocs.scoreDocs[0].doc, SetsKt.setOf((Object)BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName()));
            BytesRef fieldValue = doc.getBinaryValue(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
            UInt256 uInt2565 = UInt256.fromBytes((Bytes)((Bytes)Bytes32.wrap((byte[])fieldValue.bytes)));
            Intrinsics.checkExpressionValueIsNotNull((Object)uInt2565, (String)"UInt256.fromBytes(Bytes32.wrap(fieldValue.bytes))");
            uInt256 = uInt2565;
        }
        catch (IOException e) {
            throw (Throwable)new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
        return uInt256;
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Gas value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull UInt256 value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Address value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull BlockHeaderFields field, @NotNull Hash value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findInRange(@NotNull TransactionReceiptFields field, @NotNull UInt256 minValue, @NotNull UInt256 maxValue) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)minValue, (String)"minValue");
        Intrinsics.checkParameterIsNotNull((Object)maxValue, (String)"maxValue");
        return this.queryBlocks((Query)new TermRangeQuery(field.getFieldName(), this.toBytesRef(minValue), this.toBytesRef(maxValue), true, true));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Bytes value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, int value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        return this.findBy(field, (long)value);
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, long value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Query query = NumericDocValuesField.newSlowExactQuery((String)field.getFieldName(), (long)value);
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"NumericDocValuesField.ne\u2026y(field.fieldName, value)");
        return this.queryTxReceipts(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Hash findByLargest(@NotNull TransactionReceiptFields field) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        IndexSearcher searcher = null;
        try {
            IndexSearcher indexSearcher = searcher = (IndexSearcher)this.searcherManager.acquire();
            if (indexSearcher == null) {
                Intrinsics.throwNpe();
            }
            TopFieldDocs topDocs = indexSearcher.search((Query)new TermQuery(new Term("_type", "txReceipt")), HITS, new Sort(new SortField[]{SortField.FIELD_SCORE, new SortField(field.getFieldName(), SortField.Type.DOC, true)}));
            int n = 0;
            ScoreDoc[] scoreDocArray = topDocs.scoreDocs;
            int n2 = scoreDocArray.length;
            if (n < n2) {
                ScoreDoc hit = scoreDocArray[n];
                Document doc = searcher.doc(hit.doc, SetsKt.setOf((Object)"_id"));
                BytesRef bytes = doc.getBinaryValue("_id");
                Hash hash = Hash.fromBytes((Bytes32)Bytes32.wrap((byte[])bytes.bytes));
                return hash;
            }
            Hash hash = null;
            return hash;
        }
        catch (IOException e) {
            throw (Throwable)new IndexReadException(e);
        }
        finally {
            try {
                this.searcherManager.release((Object)searcher);
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Gas value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull UInt256 value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef(value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Address value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @NotNull
    public List<Hash> findBy(@NotNull TransactionReceiptFields field, @NotNull Hash value) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)field), (String)"field");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        return this.findByOneTerm(field, this.toBytesRef((Bytes)value));
    }

    @Override
    @Nullable
    public Hash findByBlockHashAndIndex(@NotNull Bytes blockHash, int index) {
        Intrinsics.checkParameterIsNotNull((Object)blockHash, (String)"blockHash");
        BooleanQuery booleanQuery = new BooleanQuery.Builder().add((Query)new TermQuery(new Term(TransactionReceiptFields.BLOCK_HASH.getFieldName(), this.toBytesRef(blockHash))), BooleanClause.Occur.MUST).add(NumericDocValuesField.newSlowExactQuery((String)TransactionReceiptFields.INDEX.getFieldName(), (long)index), BooleanClause.Occur.MUST).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"BooleanQuery.Builder()\n \u2026ur.MUST\n        ).build()");
        return (Hash)CollectionsKt.firstOrNull(this.queryTxReceipts((Query)booleanQuery));
    }

    @Override
    @NotNull
    public List<Hash> findByHashOrNumber(@NotNull Bytes hashOrNumber) {
        BooleanQuery query;
        Intrinsics.checkParameterIsNotNull((Object)hashOrNumber, (String)"hashOrNumber");
        BooleanQuery booleanQuery = query = new BooleanQuery.Builder().setMinimumNumberShouldMatch(1).add(new BooleanClause((Query)new TermQuery(new Term("_id", this.toBytesRef(hashOrNumber))), BooleanClause.Occur.SHOULD)).add(new BooleanClause((Query)new TermQuery(new Term(BlockHeaderFields.NUMBER.getFieldName(), this.toBytesRef(hashOrNumber))), BooleanClause.Occur.SHOULD)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)booleanQuery, (String)"query");
        return this.queryBlocks((Query)booleanQuery);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Nullable
    public UInt256 totalDifficulty(@NotNull Bytes hash) {
        Object object;
        Document document;
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        Document document2 = (Document)CollectionsKt.firstOrNull(this.queryBlockDocs((Query)new TermQuery(new Term("_id", this.toBytesRef(hash))), CollectionsKt.listOf((Object)((Object)BlockHeaderFields.TOTAL_DIFFICULTY))));
        if (document2 == null) return null;
        Document it = document = document2;
        boolean bl = false;
        IndexableField indexableField = it.getField(BlockHeaderFields.TOTAL_DIFFICULTY.getFieldName());
        Object object2 = indexableField;
        if (indexableField == null) return null;
        BytesRef bytesRef = object2.binaryValue();
        object2 = bytesRef;
        if (bytesRef == null) return null;
        object2 = object2.bytes;
        if (object2.bytes == null) return null;
        Object object3 = object = object2;
        boolean bl2 = false;
        UInt256 uInt256 = UInt256.fromBytes((Bytes)Bytes.wrap((byte[])object3));
        return uInt256;
    }

    private final List<Hash> findByOneTerm(BlockHeaderFields field, BytesRef value) {
        return this.queryBlocks((Query)new TermQuery(new Term(field.getFieldName(), value)));
    }

    private final List<Hash> findByOneTerm(TransactionReceiptFields field, BytesRef value) {
        return this.queryTxReceipts((Query)new TermQuery(new Term(field.getFieldName(), value)));
    }

    private final BytesRef toBytesRef(Gas gas) {
        return new BytesRef(gas.toBytes().toArrayUnsafe());
    }

    private final BytesRef toBytesRef(Bytes bytes) {
        return new BytesRef(bytes.toArrayUnsafe());
    }

    private final BytesRef toBytesRef(UInt256 uint) {
        Bytes32 bytes32 = uint.toBytes();
        Intrinsics.checkExpressionValueIsNotNull((Object)bytes32, (String)"uint.toBytes()");
        return this.toBytesRef((Bytes)bytes32);
    }

    public BlockchainIndex(@NotNull IndexWriter indexWriter) {
        Intrinsics.checkParameterIsNotNull((Object)indexWriter, (String)"indexWriter");
        this.indexWriter = indexWriter;
        if (!this.indexWriter.isOpen()) {
            throw (Throwable)new IllegalArgumentException("Index writer should be opened");
        }
        try {
            this.searcherManager = new SearcherManager(this.indexWriter, new SearcherFactory());
        }
        catch (IOException e) {
            throw (Throwable)new UncheckedIOException(e);
        }
    }

    static {
        HITS = 10;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/apache/tuweni/eth/repository/BlockchainIndex$Companion;", "", "()V", "HITS", "", "eth-repository"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

