/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.devp2p.eth;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.devp2p.eth.Status;
import org.apache.tuweni.eth.Hash;
import org.apache.tuweni.rlp.RLP;
import org.apache.tuweni.rlp.RLPReader;
import org.apache.tuweni.rlp.RLPWriter;
import org.apache.tuweni.units.bigints.UInt256;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 .2\u00020\u0001:\u0001.BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\bH\u00c6\u0003J\t\u0010 \u001a\u00020\bH\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\u0010\u0010\"\u001a\u0004\u0018\u00010\rH\u00c6\u0003\u00a2\u0006\u0002\u0010\u0012JX\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010)\u001a\u00020\u000bJ\u0006\u0010*\u001a\u00020+J\t\u0010,\u001a\u00020-H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\n\n\u0002\u0010\u0013\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\t\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018\u00a8\u0006/"}, d2={"Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "", "protocolVersion", "", "networkID", "Lorg/apache/tuweni/units/bigints/UInt256;", "totalDifficulty", "bestHash", "Lorg/apache/tuweni/eth/Hash;", "genesisHash", "forkHash", "Lorg/apache/tuweni/bytes/Bytes;", "forkBlock", "", "(ILorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Long;)V", "getBestHash", "()Lorg/apache/tuweni/eth/Hash;", "getForkBlock", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getForkHash", "()Lorg/apache/tuweni/bytes/Bytes;", "getGenesisHash", "getNetworkID", "()Lorg/apache/tuweni/units/bigints/UInt256;", "getProtocolVersion", "()I", "getTotalDifficulty", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "(ILorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/units/bigints/UInt256;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/eth/Hash;Lorg/apache/tuweni/bytes/Bytes;Ljava/lang/Long;)Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "equals", "", "other", "hashCode", "toBytes", "toStatus", "Lorg/apache/tuweni/devp2p/eth/Status;", "toString", "", "Companion", "devp2p-eth"})
public final class StatusMessage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int protocolVersion;
    @NotNull
    private final UInt256 networkID;
    @NotNull
    private final UInt256 totalDifficulty;
    @NotNull
    private final Hash bestHash;
    @NotNull
    private final Hash genesisHash;
    @Nullable
    private final Bytes forkHash;
    @Nullable
    private final Long forkBlock;

    public StatusMessage(int protocolVersion, @NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull Hash genesisHash, @Nullable Bytes forkHash, @Nullable Long forkBlock) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        this.protocolVersion = protocolVersion;
        this.networkID = networkID;
        this.totalDifficulty = totalDifficulty;
        this.bestHash = bestHash;
        this.genesisHash = genesisHash;
        this.forkHash = forkHash;
        this.forkBlock = forkBlock;
    }

    public final int getProtocolVersion() {
        return this.protocolVersion;
    }

    @NotNull
    public final UInt256 getNetworkID() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 getTotalDifficulty() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash getBestHash() {
        return this.bestHash;
    }

    @NotNull
    public final Hash getGenesisHash() {
        return this.genesisHash;
    }

    @Nullable
    public final Bytes getForkHash() {
        return this.forkHash;
    }

    @Nullable
    public final Long getForkBlock() {
        return this.forkBlock;
    }

    @NotNull
    public final Bytes toBytes() {
        Bytes bytes = RLP.encodeList(arg_0 -> StatusMessage.toBytes$lambda-1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"encodeList {\n    it.writ\u2026eros())\n      }\n    }\n  }");
        return bytes;
    }

    @NotNull
    public final Status toStatus() {
        return new Status(this.protocolVersion, this.networkID, this.totalDifficulty, (Bytes32)this.bestHash, (Bytes32)this.genesisHash, this.forkHash, this.forkBlock);
    }

    public final int component1() {
        return this.protocolVersion;
    }

    @NotNull
    public final UInt256 component2() {
        return this.networkID;
    }

    @NotNull
    public final UInt256 component3() {
        return this.totalDifficulty;
    }

    @NotNull
    public final Hash component4() {
        return this.bestHash;
    }

    @NotNull
    public final Hash component5() {
        return this.genesisHash;
    }

    @Nullable
    public final Bytes component6() {
        return this.forkHash;
    }

    @Nullable
    public final Long component7() {
        return this.forkBlock;
    }

    @NotNull
    public final StatusMessage copy(int protocolVersion, @NotNull UInt256 networkID, @NotNull UInt256 totalDifficulty, @NotNull Hash bestHash, @NotNull Hash genesisHash, @Nullable Bytes forkHash, @Nullable Long forkBlock) {
        Intrinsics.checkNotNullParameter((Object)networkID, (String)"networkID");
        Intrinsics.checkNotNullParameter((Object)totalDifficulty, (String)"totalDifficulty");
        Intrinsics.checkNotNullParameter((Object)bestHash, (String)"bestHash");
        Intrinsics.checkNotNullParameter((Object)genesisHash, (String)"genesisHash");
        return new StatusMessage(protocolVersion, networkID, totalDifficulty, bestHash, genesisHash, forkHash, forkBlock);
    }

    public static /* synthetic */ StatusMessage copy$default(StatusMessage statusMessage, int n, UInt256 uInt256, UInt256 uInt2562, Hash hash, Hash hash2, Bytes bytes, Long l, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = statusMessage.protocolVersion;
        }
        if ((n2 & 2) != 0) {
            uInt256 = statusMessage.networkID;
        }
        if ((n2 & 4) != 0) {
            uInt2562 = statusMessage.totalDifficulty;
        }
        if ((n2 & 8) != 0) {
            hash = statusMessage.bestHash;
        }
        if ((n2 & 0x10) != 0) {
            hash2 = statusMessage.genesisHash;
        }
        if ((n2 & 0x20) != 0) {
            bytes = statusMessage.forkHash;
        }
        if ((n2 & 0x40) != 0) {
            l = statusMessage.forkBlock;
        }
        return statusMessage.copy(n, uInt256, uInt2562, hash, hash2, bytes, l);
    }

    @NotNull
    public String toString() {
        return "StatusMessage(protocolVersion=" + this.protocolVersion + ", networkID=" + this.networkID + ", totalDifficulty=" + this.totalDifficulty + ", bestHash=" + this.bestHash + ", genesisHash=" + this.genesisHash + ", forkHash=" + this.forkHash + ", forkBlock=" + this.forkBlock + ")";
    }

    public int hashCode() {
        int result = Integer.hashCode(this.protocolVersion);
        result = result * 31 + this.networkID.hashCode();
        result = result * 31 + this.totalDifficulty.hashCode();
        result = result * 31 + this.bestHash.hashCode();
        result = result * 31 + this.genesisHash.hashCode();
        result = result * 31 + (this.forkHash == null ? 0 : this.forkHash.hashCode());
        result = result * 31 + (this.forkBlock == null ? 0 : ((Object)this.forkBlock).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StatusMessage)) {
            return false;
        }
        StatusMessage statusMessage = (StatusMessage)other;
        if (this.protocolVersion != statusMessage.protocolVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.networkID, (Object)statusMessage.networkID)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.totalDifficulty, (Object)statusMessage.totalDifficulty)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.bestHash, (Object)statusMessage.bestHash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.genesisHash, (Object)statusMessage.genesisHash)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.forkHash, (Object)statusMessage.forkHash)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.forkBlock, (Object)statusMessage.forkBlock);
    }

    private static final void toBytes$lambda-1$lambda-0(StatusMessage this$0, RLPWriter forkWriter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        forkWriter.writeValue(this$0.forkHash);
        forkWriter.writeValue(Bytes.ofUnsignedLong((long)this$0.forkBlock).trimLeadingZeros());
    }

    private static final void toBytes$lambda-1(StatusMessage this$0, RLPWriter it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        it.writeInt(this$0.protocolVersion);
        it.writeUInt256(this$0.networkID);
        it.writeUInt256(this$0.totalDifficulty);
        it.writeValue((Bytes)this$0.bestHash);
        it.writeValue((Bytes)this$0.genesisHash);
        if (this$0.forkHash != null && this$0.forkBlock != null) {
            it.writeList(arg_0 -> StatusMessage.toBytes$lambda-1$lambda-0(this$0, arg_0));
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/apache/tuweni/devp2p/eth/StatusMessage$Companion;", "", "()V", "read", "Lorg/apache/tuweni/devp2p/eth/StatusMessage;", "payload", "Lorg/apache/tuweni/bytes/Bytes;", "devp2p-eth"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StatusMessage read(@NotNull Bytes payload) {
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            Object object = RLP.decode((Bytes)payload, Companion::read$lambda-2);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"decode(payload) {\n      \u2026)\n        )\n      }\n    }");
            return (StatusMessage)object;
        }

        private static final Pair read$lambda-2$lambda-1$lambda-0(RLPReader fork) {
            return new Pair((Object)fork.readValue(), (Object)fork.readValue());
        }

        private static final StatusMessage read$lambda-2$lambda-1(RLPReader reader) {
            Long l;
            int protocolVersion = reader.readInt();
            UInt256 networkID = UInt256.fromBytes((Bytes)reader.readValue());
            UInt256 totalDifficulty = UInt256.fromBytes((Bytes)reader.readValue());
            Hash bestHash = Hash.fromBytes((Bytes)reader.readValue());
            Hash genesisHash = Hash.fromBytes((Bytes)reader.readValue());
            Pair forkInfo = null;
            if (!reader.isComplete()) {
                forkInfo = (Pair)reader.readList(Companion::read$lambda-2$lambda-1$lambda-0);
            }
            Intrinsics.checkNotNullExpressionValue((Object)networkID, (String)"networkID");
            Intrinsics.checkNotNullExpressionValue((Object)totalDifficulty, (String)"totalDifficulty");
            Intrinsics.checkNotNullExpressionValue((Object)bestHash, (String)"bestHash");
            Intrinsics.checkNotNullExpressionValue((Object)genesisHash, (String)"genesisHash");
            Pair pair = forkInfo;
            Bytes bytes = pair == null ? null : (Bytes)pair.getFirst();
            Pair pair2 = forkInfo;
            if (pair2 == null) {
                l = null;
            } else {
                Bytes bytes2 = (Bytes)pair2.getSecond();
                l = bytes2 == null ? null : Long.valueOf(bytes2.toLong());
            }
            return new StatusMessage(protocolVersion, networkID, totalDifficulty, bestHash, genesisHash, bytes, l);
        }

        private static final StatusMessage read$lambda-2(RLPReader it) {
            return (StatusMessage)it.readList(Companion::read$lambda-2$lambda-1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

