/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.concurrent;

import io.vertx.core.Vertx;
import io.vertx.core.WorkerExecutor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.tuweni.concurrent.AsyncResult;
import org.apache.tuweni.concurrent.CompletableAsyncCompletion;
import org.apache.tuweni.concurrent.DefaultCompletableAsyncCompletion;

public interface AsyncCompletion {
    public static final AsyncCompletion COMPLETED = new DefaultCompletableAsyncCompletion(CompletableFuture.completedFuture(null));

    public static AsyncCompletion completed() {
        return COMPLETED;
    }

    public static AsyncCompletion exceptional(Throwable ex) {
        Objects.requireNonNull(ex);
        DefaultCompletableAsyncCompletion completion = new DefaultCompletableAsyncCompletion();
        completion.completeExceptionally(ex);
        return completion;
    }

    public static CompletableAsyncCompletion incomplete() {
        return new DefaultCompletableAsyncCompletion();
    }

    public static AsyncCompletion allOf(AsyncCompletion ... cs) {
        return AsyncCompletion.allOf(Arrays.stream(cs));
    }

    public static AsyncCompletion allOf(Collection<AsyncCompletion> cs) {
        return AsyncCompletion.allOf(cs.stream());
    }

    public static AsyncCompletion allOf(Stream<AsyncCompletion> cs) {
        CompletableFuture[] completableFutures = (CompletableFuture[])cs.map(completion -> {
            CompletableFuture javaFuture = new CompletableFuture();
            completion.whenComplete(ex -> {
                if (ex == null) {
                    javaFuture.complete(null);
                } else {
                    javaFuture.completeExceptionally((Throwable)ex);
                }
            });
            return javaFuture;
        }).toArray(CompletableFuture[]::new);
        return new DefaultCompletableAsyncCompletion(CompletableFuture.allOf(completableFutures));
    }

    public static AsyncCompletion runOnContext(Vertx vertx, Supplier<? extends AsyncCompletion> fn) {
        Objects.requireNonNull(fn);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        vertx.runOnContext(ev -> {
            try {
                ((AsyncCompletion)fn.get()).whenComplete(ex2 -> {
                    if (ex2 == null) {
                        try {
                            completion.complete();
                        }
                        catch (Throwable ex3) {
                            completion.completeExceptionally(ex3);
                        }
                    } else {
                        completion.completeExceptionally((Throwable)ex2);
                    }
                });
            }
            catch (Throwable ex1) {
                completion.completeExceptionally(ex1);
            }
        });
        return completion;
    }

    public static AsyncCompletion runOnContext(Vertx vertx, Runnable action) {
        Objects.requireNonNull(action);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        vertx.runOnContext(ev -> {
            try {
                action.run();
                completion.complete();
            }
            catch (Throwable ex) {
                completion.completeExceptionally(ex);
            }
        });
        return completion;
    }

    public static AsyncCompletion executeBlocking(Runnable action) {
        Objects.requireNonNull(action);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        ForkJoinPool.commonPool().execute(() -> {
            try {
                action.run();
                completion.complete();
            }
            catch (Throwable ex) {
                completion.completeExceptionally(ex);
            }
        });
        return completion;
    }

    public static AsyncCompletion executeBlocking(Executor executor, Runnable action) {
        Objects.requireNonNull(action);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        executor.execute(() -> {
            try {
                action.run();
                completion.complete();
            }
            catch (Throwable ex) {
                completion.completeExceptionally(ex);
            }
        });
        return completion;
    }

    public static AsyncCompletion executeBlocking(Vertx vertx, Runnable action) {
        Objects.requireNonNull(action);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        vertx.executeBlocking(future -> {
            action.run();
            future.complete();
        }, false, res -> {
            if (res.succeeded()) {
                completion.complete();
            } else {
                completion.completeExceptionally(res.cause());
            }
        });
        return completion;
    }

    public static AsyncCompletion executeBlocking(WorkerExecutor executor, Runnable action) {
        Objects.requireNonNull(action);
        CompletableAsyncCompletion completion = AsyncCompletion.incomplete();
        executor.executeBlocking(future -> {
            action.run();
            future.complete();
        }, false, res -> {
            if (res.succeeded()) {
                completion.complete();
            } else {
                completion.completeExceptionally(res.cause());
            }
        });
        return completion;
    }

    public boolean isDone();

    public boolean isCompletedExceptionally();

    public boolean cancel();

    public boolean isCancelled();

    public void join() throws CompletionException, InterruptedException;

    public void join(long var1, TimeUnit var3) throws CompletionException, TimeoutException, InterruptedException;

    public <U> AsyncResult<U> then(Supplier<? extends AsyncResult<U>> var1);

    public <U> AsyncResult<U> thenSchedule(Vertx var1, Supplier<? extends AsyncResult<U>> var2);

    public AsyncCompletion thenRun(Runnable var1);

    public AsyncCompletion thenScheduleRun(Vertx var1, Runnable var2);

    public AsyncCompletion thenScheduleBlockingRun(Vertx var1, Runnable var2);

    public AsyncCompletion thenScheduleBlockingRun(WorkerExecutor var1, Runnable var2);

    public AsyncCompletion thenCompose(Supplier<? extends AsyncCompletion> var1);

    public <U> AsyncResult<U> thenSupply(Supplier<? extends U> var1);

    public <U> AsyncResult<U> thenSupply(Vertx var1, Supplier<? extends U> var2);

    public <U> AsyncCompletion thenConsume(AsyncResult<? extends U> var1, Consumer<? super U> var2);

    public <U, V> AsyncResult<V> thenApply(AsyncResult<? extends U> var1, Function<? super U, ? extends V> var2);

    public AsyncCompletion thenCombine(AsyncCompletion var1);

    public AsyncCompletion exceptionally(Consumer<? super Throwable> var1);

    public AsyncCompletion whenComplete(Consumer<? super Throwable> var1);

    public <U> AsyncResult<U> handle(Function<? super Throwable, ? extends U> var1);

    public AsyncCompletion accept(Consumer<? super Throwable> var1);
}

