/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.tuweni.io.NullOutputStream;

public final class Streams {
    private static final PrintStream NULL_PRINT_STREAM = new PrintStream(NullOutputStream.INSTANCE);

    private Streams() {
    }

    public static OutputStream nullOutputStream() {
        return NullOutputStream.INSTANCE;
    }

    public static PrintStream nullPrintStream() {
        return NULL_PRINT_STREAM;
    }

    public static <T> Stream<T> enumerationStream(final Enumeration<T> enumeration) {
        Objects.requireNonNull(enumeration);
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 16){

            @Override
            public boolean tryAdvance(Consumer<? super T> action) {
                if (enumeration.hasMoreElements()) {
                    action.accept(enumeration.nextElement());
                    return true;
                }
                return false;
            }
        }, false);
    }
}

