/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public final class Base64URLSafe {
    private Base64URLSafe() {
    }

    public static String encodeBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new String(Base64.getUrlEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static String encode(Bytes bytes) {
        Objects.requireNonNull(bytes);
        return Base64URLSafe.encodeBytes(bytes.toArrayUnsafe());
    }

    public static byte[] decodeBytes(String b64) {
        Objects.requireNonNull(b64);
        return Base64.getUrlDecoder().decode(b64.getBytes(StandardCharsets.UTF_8));
    }

    public static Bytes decode(String b64) {
        return Bytes.wrap((byte[])Base64URLSafe.decodeBytes(b64));
    }
}

