/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.io;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;

public final class Base64 {
    private Base64() {
    }

    public static String encodeBytes(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new String(java.util.Base64.getEncoder().encode(bytes), StandardCharsets.UTF_8);
    }

    public static String encode(Bytes bytes) {
        Objects.requireNonNull(bytes);
        return Base64.encodeBytes(bytes.toArrayUnsafe());
    }

    public static byte[] decodeBytes(String b64) {
        Objects.requireNonNull(b64);
        return java.util.Base64.getDecoder().decode(b64.getBytes(StandardCharsets.UTF_8));
    }

    public static Bytes decode(String b64) {
        return Bytes.wrap((byte[])Base64.decodeBytes(b64));
    }
}

