/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.provider;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;

class WidgetImplementationInvoker
implements Invoker {
    private RuntimeComponent component;
    private ComponentJavaScriptGenerator javaScriptGenerator;
    private String widgetName;
    private String widgetFolderURL;
    private String widgetLocationURL;

    WidgetImplementationInvoker(RuntimeComponent component, ComponentJavaScriptGenerator javaScriptGenerator, String widgetName, String widgetFolderURL, String widgetLocationURL) {
        this.component = component;
        this.javaScriptGenerator = javaScriptGenerator;
        this.widgetName = widgetName + ".js";
        this.widgetFolderURL = widgetFolderURL;
        this.widgetLocationURL = widgetLocationURL;
    }

    public Message invoke(Message msg) {
        String id = (String)((Object[])msg.getBody())[0];
        try {
            if (id.length() == 0) {
                URL url = new URL(this.widgetLocationURL);
                InputStream is = url.openStream();
                msg.setBody((Object)is);
            } else if (id.equals(this.widgetName)) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(bos);
                this.javaScriptGenerator.generateJavaScriptCode(this.component, pw);
                ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                msg.setBody((Object)is);
            } else {
                URL url = new URL(this.widgetFolderURL + '/' + id);
                InputStream is = url.openStream();
                msg.setBody((Object)is);
            }
        }
        catch (MalformedURLException e) {
            msg.setFaultBody((Object)e);
        }
        catch (IOException e) {
            msg.setFaultBody((Object)e);
        }
        return msg;
    }
}

