/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.widget.dojo;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.web.javascript.ComponentJavaScriptGenerator;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactory;
import org.apache.tuscany.sca.web.javascript.JavascriptProxyFactoryExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DojoJavaScriptComponentGeneratorImpl
implements ComponentJavaScriptGenerator {
    private static final QName NAME = new QName("http://tuscany.apache.org/xmlns/sca/1.0", "component.script.generator.dojo");
    private JavascriptProxyFactoryExtensionPoint javascriptProxyFactories;

    public DojoJavaScriptComponentGeneratorImpl(ExtensionPointRegistry extensionPoints) {
        this.javascriptProxyFactories = (JavascriptProxyFactoryExtensionPoint)extensionPoints.getExtensionPoint(JavascriptProxyFactoryExtensionPoint.class);
    }

    public QName getQName() {
        return NAME;
    }

    public void generateJavaScriptCode(RuntimeComponent component, PrintWriter pw) throws IOException {
        pw.println();
        pw.println("/* Apache Tuscany SCA Widget header */");
        pw.println();
        HashMap<String, Boolean> bindingClientProcessed = new HashMap<String, Boolean>();
        for (ComponentReference reference : component.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                Boolean processedFlag;
                JavascriptProxyFactory jsProxyFactory = this.javascriptProxyFactories.getProxyFactory(binding.getClass());
                String bindingProxyName = jsProxyFactory.getJavascriptProxyFile();
                if (bindingProxyName == null || (processedFlag = (Boolean)bindingClientProcessed.get(bindingProxyName)) != null && processedFlag.booleanValue()) continue;
                DojoJavaScriptComponentGeneratorImpl.generateJavaScriptBindingProxy(jsProxyFactory, pw);
                bindingClientProcessed.put(bindingProxyName, Boolean.TRUE);
            }
        }
        pw.println();
        pw.println("/* Tuscany Reference/Property injection code */");
        pw.println();
        DojoJavaScriptComponentGeneratorImpl.generateJavaScriptNamespace(pw);
        pw.println();
        DojoJavaScriptComponentGeneratorImpl.generateJavaScriptPropertyFunction(component, pw);
        pw.println();
        DojoJavaScriptComponentGeneratorImpl.generateJavaScriptReferenceFunction(component, this.javascriptProxyFactories, pw);
        pw.println();
        pw.println("/** End of Apache Tuscany SCA Widget */");
        pw.println();
        pw.flush();
        pw.close();
    }

    private static void generateJavaScriptBindingProxy(JavascriptProxyFactory javascriptProxyFactory, PrintWriter pw) throws IOException {
        InputStream is = javascriptProxyFactory.getJavascriptProxyFileAsStream();
        if (is != null) {
            int i;
            while ((i = is.read()) != -1) {
                pw.write(i);
            }
        }
        pw.println();
        pw.println();
    }

    private static void generateJavaScriptNamespace(PrintWriter pw) throws IOException {
        pw.println("if (!window.tuscany) { \nwindow.tuscany = {}; \n}");
        pw.println("var __tus = window.tuscany;");
        pw.println("if (!__tus.sca) { \n__tus.sca = {}; \n}");
    }

    private static void generateJavaScriptPropertyFunction(RuntimeComponent component, PrintWriter pw) throws IOException {
        pw.println("__tus.sca.propertyMap = {};");
        for (ComponentProperty property : component.getProperties()) {
            String propertyName = property.getName();
            pw.println("__tus.sca.propertyMap." + propertyName + " = new String(\"" + DojoJavaScriptComponentGeneratorImpl.getPropertyValue(property) + "\");");
        }
        pw.println("__tus.sca.Property = function (name) {");
        pw.println("    return __tus.sca.propertyMap[name];");
        pw.println("}");
    }

    private static String getPropertyValue(ComponentProperty property) {
        Document doc = (Document)property.getValue();
        Element rootElement = doc.getDocumentElement();
        String value = null;
        if (rootElement.getChildNodes().getLength() > 0) {
            value = rootElement.getChildNodes().item(0).getTextContent();
        }
        return value;
    }

    private static void generateJavaScriptReferenceFunction(RuntimeComponent component, JavascriptProxyFactoryExtensionPoint javascriptProxyFactories, PrintWriter pw) throws IOException {
        pw.println("__tus.sca.referenceMap = {};");
        for (ComponentReference reference : component.getReferences()) {
            Binding binding = (Binding)reference.getBindings().get(0);
            if (binding == null) continue;
            String referenceName = reference.getName();
            JavascriptProxyFactory jsProxyFactory = javascriptProxyFactories.getProxyFactory(binding.getClass());
            pw.println("__tus.sca.referenceMap." + referenceName + " = new " + jsProxyFactory.createJavascriptReference(reference) + ";");
        }
        pw.println("__tus.sca.Reference = function (name) {");
        pw.println("    return __tus.sca.referenceMap[name];");
        pw.println("}");
    }
}

