/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;

public class HTTPGetListenerServlet
extends HttpServlet {
    private static final long serialVersionUID = 2865466417329430610L;
    private MessageFactory messageFactory;
    private Invoker getInvoker;

    public HTTPGetListenerServlet(Invoker getInvoker, MessageFactory messageFactory) {
        this.getInvoker = getInvoker;
        this.messageFactory = messageFactory;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int n;
        String path = URLDecoder.decode(request.getRequestURI().substring(request.getServletPath().length()), "UTF-8");
        if (path.length() == 0) {
            response.sendRedirect(request.getRequestURL().append('/').toString());
            return;
        }
        Message requestMessage = this.messageFactory.createMessage();
        String id = path.substring(1);
        requestMessage.setBody((Object)new Object[]{id});
        Message responseMessage = this.getInvoker.invoke(requestMessage);
        if (responseMessage.isFault()) {
            throw new ServletException((Throwable)responseMessage.getBody());
        }
        InputStream is = (InputStream)responseMessage.getBody();
        ServletOutputStream os = response.getOutputStream();
        byte[] buffer = new byte[2048];
        while ((n = is.read(buffer)) > 0) {
            os.write(buffer, 0, n);
        }
        os.flush();
        os.close();
    }
}

