/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.http.wireformat.jsonrpc.provider;

import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.BindingRRB;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.binding.http.HTTPBinding;
import org.apache.tuscany.sca.binding.http.wireformat.jsonrpc.JSONRPCWireFormat;
import org.apache.tuscany.sca.binding.http.wireformat.jsonrpc.provider.JSONRPCWireFormatInterceptor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;

public class JSONRPCWireFormatServiceProvider
implements WireFormatProvider {
    private MessageFactory messageFactory;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private Binding binding;

    public JSONRPCWireFormatServiceProvider(ExtensionPointRegistry extensionPoints, RuntimeComponent component, RuntimeComponentService service, Binding binding) {
        ModelFactoryExtensionPoint modelFactories = (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.component = component;
        this.service = service;
        this.serviceContract = service.getInterfaceContract();
        this.binding = binding;
    }

    public InterfaceContract configureWireFormatInterfaceContract(InterfaceContract interfaceContract) {
        this.serviceContract = interfaceContract;
        this.setDataBinding(this.serviceContract.getInterface());
        this.serviceContract.getInterface().resetDataBinding("JSON");
        return interfaceContract;
    }

    public Interceptor createInterceptor() {
        BindingRRB rrbBinding;
        WireFormat wireFormat;
        if (this.binding instanceof BindingRRB && (wireFormat = (rrbBinding = (BindingRRB)this.binding).getRequestWireFormat()) != null && wireFormat instanceof JSONRPCWireFormat) {
            return new JSONRPCWireFormatInterceptor((HTTPBinding)this.binding, this.service.getRuntimeWire(this.binding), this.serviceContract, this.messageFactory);
        }
        return null;
    }

    public String getPhase() {
        return "service.binding.wireformat";
    }

    private void setDataBinding(Interface interfaze) {
        List operations = interfaze.getOperations();
        for (Operation operation : operations) {
            DataType outputType;
            operation.setDataBinding("JSON");
            DataType inputType = operation.getInputType();
            if (inputType != null) {
                List logical = (List)inputType.getLogical();
                for (DataType inArg : logical) {
                    if ("java:simpleType".equals(inArg.getDataBinding())) continue;
                    inArg.setDataBinding("JSON");
                }
            }
            if ((outputType = operation.getOutputType()) == null || "java:simpleType".equals(outputType.getDataBinding())) continue;
            outputType.setDataBinding("JSON");
        }
    }
}

