/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.tomee.server.composer.Archive;
import org.apache.tomee.server.composer.Mvn;
import org.tomitribe.swizzle.stream.StreamBuilder;
import org.tomitribe.util.Duration;

public abstract class ServerBuilder<T extends ServerBuilder<T>> {
    protected final File archive;
    protected FileFilter filter = pathname -> true;
    protected Duration await = new Duration("1 minute");
    protected boolean list = false;
    protected boolean debug = false;
    protected final ArrayList<Consumer<File>> homeConsumers = new ArrayList();
    protected final ArrayList<Consumer<T>> builderConsumers = new ArrayList();
    protected final ArrayList<Consumer<StreamBuilder>> watches = new ArrayList();
    protected final Map<String, String> env = new HashMap<String, String>();
    protected final Archive modifications = Archive.archive();

    public ServerBuilder(String coordinates) throws IOException {
        this(Mvn.mvn(coordinates));
    }

    public ServerBuilder(File archive) throws IOException {
        this.archive = archive;
    }

    public Duration await() {
        return this.await;
    }

    public File archive() {
        return this.archive;
    }

    public T env(String name, String value) {
        this.env.put(name, value);
        return (T)this;
    }

    public T add(String name, byte[] bytes) {
        this.modifications.add(name, bytes);
        return (T)this;
    }

    public T add(String name, Supplier<byte[]> content) {
        this.modifications.add(name, content);
        return (T)this;
    }

    public T add(String name, String content) {
        this.modifications.add(name, content);
        return (T)this;
    }

    public T add(String name, File content) {
        this.modifications.add(name, content);
        return (T)this;
    }

    public T home(Consumer<File> customization) {
        this.homeConsumers.add(customization);
        return (T)this;
    }

    public T watch(String token, Consumer<String> consumer) {
        this.watches.add(stream -> stream.watch(token, consumer));
        return (T)this;
    }

    public T watch(String begin, String end, Consumer<String> consumer) {
        this.watches.add(stream -> stream.watch(begin, end, consumer));
        return (T)this;
    }

    public T watch(String token, Runnable runnable) {
        this.watches.add(stream -> stream.watch(token, s -> runnable.run()));
        return (T)this;
    }

    public T watch(String begin, String end, Runnable runnable) {
        this.watches.add(stream -> stream.watch(begin, end, s -> runnable.run()));
        return (T)this;
    }

    public T and(Consumer<T> consumer) {
        this.builderConsumers.add(consumer);
        return (T)this;
    }

    public T filter(FileFilter filter) {
        this.filter = filter;
        return (T)this;
    }

    public T list(boolean list) {
        this.list = list;
        return (T)this;
    }

    public T await(Duration duration) {
        this.await = duration;
        return (T)this;
    }

    public T await(long time, TimeUnit unit) {
        this.await = new Duration(time, unit);
        return (T)this;
    }

    public T debug() {
        return this.debug(true);
    }

    public T debug(boolean debug) {
        this.debug = debug;
        return (T)this;
    }

    protected void applyHomeConsumers(File home) {
        for (Consumer<File> customization : this.homeConsumers) {
            customization.accept(home);
        }
    }

    protected void applyModifications(File home) throws IOException {
        this.modifications.toDir(home);
    }

    protected void applyBuilderConsumers() {
        for (Consumer<ServerBuilder> consumer : this.builderConsumers) {
            consumer.accept(this);
        }
    }
}

