/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.server.composer;

import java.io.File;
import java.util.logging.Logger;
import org.tomitribe.util.Files;
import org.tomitribe.util.JarLocation;

public class Mvn {
    private static final Logger LOGGER = Logger.getLogger(Mvn.class.getName());

    private Mvn() {
    }

    public static File mvn(String coordinates) {
        String[] parts = coordinates.split(":");
        if (parts.length != 5) {
            throw new IllegalArgumentException("Expected format with 5 parts such as 'org.apache.tomee:apache-tomee:zip:plus:8.0.0-SNAPSHOT'.  Found " + coordinates);
        }
        String group = parts[0];
        String artifact = parts[1];
        String version = parts[4];
        String packaging = parts[2];
        String classifier = parts[3];
        return Mvn.mvn(group, artifact, version, packaging, classifier);
    }

    public static File mvn(String group, String artifact, String version, String packaging, String classifier) {
        File file = JarLocation.get();
        while (!file.getName().equals("org")) {
            file = file.getParentFile();
        }
        file = file.getParentFile();
        File archive = Files.file((File)file, (String[])new String[]{group.replace('.', '/'), artifact, version, String.format("%s-%s-%s.%s", artifact, version, classifier, packaging)});
        if (!archive.exists()) {
            String s = "Declare a dependency in your pom.xml on " + group + ":" + artifact + ":" + version + ":tar.gz:" + classifier + ".  For example: \n    <dependency>\n      <groupId>" + group + "</groupId>\n      <artifactId>" + artifact + "</artifactId>\n      <version>" + version + "</version>\n      <type>" + packaging + "</type>\n      <classifier>" + classifier + "</classifier>\n      <exclusions>\n        <exclusion>\n          <groupId>*</groupId>\n          <artifactId>*</artifactId>\n        </exclusion>\n      </exclusions>\n    </dependency>\n";
            LOGGER.severe(s);
        }
        Files.exists((File)archive);
        Files.file((File)archive);
        Files.readable((File)archive);
        return archive;
    }
}

