/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.security.cdi;

import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Typed;
import javax.security.enterprise.AuthenticationException;
import javax.security.enterprise.AuthenticationStatus;
import javax.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import javax.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@ApplicationScoped
@Typed(value={DefaultAuthenticationMechanism.class})
public class DefaultAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private HttpAuthenticationMechanism delegate;

    @PostConstruct
    private void init() {
        this.delegate = new EmptyAuthenticationMechanism();
    }

    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.delegate.validateRequest(request, response, httpMessageContext);
    }

    public AuthenticationStatus secureResponse(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        return this.delegate.secureResponse(request, response, httpMessageContext);
    }

    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        this.delegate.cleanSubject(request, response, httpMessageContext);
    }

    void setDelegate(HttpAuthenticationMechanism delegate) {
        this.delegate = delegate;
    }

    private static class EmptyAuthenticationMechanism
    implements HttpAuthenticationMechanism {
        private EmptyAuthenticationMechanism() {
        }

        public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
            return httpMessageContext.doNothing();
        }
    }
}

