/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webapp.installer;

import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import org.apache.tomee.installer.InstallerInterface;
import org.apache.tomee.installer.PathsInterface;
import org.apache.tomee.installer.Status;
import org.apache.tomee.webapp.installer.Common;

public class Runner {
    private final InstallerInterface installer;
    private String catalinaHome = System.getProperty("catalina.home");
    private String catalinaBase = System.getProperty("catalina.base");
    private String serverXmlFile = System.getProperty("catalina.base") + "/conf/server.xml";
    private static List<Map<String, String>> installerResults;
    private static Status installerStatus;

    public Runner(InstallerInterface installer) {
        this.installer = installer;
    }

    public void setCatalinaHome(String catalinaHome) {
        this.catalinaHome = catalinaHome;
    }

    public void setCatalinaBaseDir(String catalinaBase) {
        this.catalinaBase = catalinaBase;
    }

    public void setServerXmlFile(String serverXmlFile) {
        this.serverXmlFile = serverXmlFile;
    }

    private void setAlerts(String key, List<String> messages) {
        if (messages == null) {
            return;
        }
        for (String message : messages) {
            installerResults.add(Common.build((String)key, (String)message));
        }
    }

    public synchronized List<Map<String, String>> execute(boolean install) {
        if (Status.INSTALLED.equals((Object)installerStatus) || Status.REBOOT_REQUIRED.equals((Object)installerStatus)) {
            return installerResults;
        }
        PathsInterface paths = this.installer.getPaths();
        paths.reset();
        this.installer.reset();
        paths.setCatalinaHomeDir(this.catalinaHome);
        paths.setCatalinaBaseDir(this.catalinaBase);
        paths.setServerXmlFile(this.serverXmlFile);
        if (paths.verify() && install) {
            this.installer.installAll();
        }
        installerResults = new ArrayList();
        installerResults.add(Common.build((String)"catalinaHomeDir", (String)String.valueOf(this.catalinaHome)));
        installerResults.add(Common.build((String)"catalinaBaseDir", (String)String.valueOf(this.catalinaBase)));
        installerResults.add(Common.build((String)"serverXmlFile", (String)String.valueOf(this.serverXmlFile)));
        installerStatus = this.installer.getStatus();
        installerResults.add(Common.build((String)"status", (String)String.valueOf(installerStatus)));
        this.setAlerts("errors", this.installer.getAlerts().getErrors());
        this.setAlerts("warnings", this.installer.getAlerts().getWarnings());
        this.setAlerts("infos", this.installer.getAlerts().getInfos());
        boolean hasHome = false;
        boolean doesHomeExist = false;
        boolean isHomeDirectory = false;
        boolean hasLibDirectory = false;
        String homePath = System.getProperty("openejb.home");
        if (homePath != null) {
            hasHome = true;
            File homeDir = new File(homePath);
            doesHomeExist = homeDir.exists();
            if (homeDir.exists()) {
                isHomeDirectory = homeDir.isDirectory();
                File libDir = new File(homeDir, "lib");
                hasLibDirectory = libDir.exists();
            }
        }
        installerResults.add(Common.build((String)"hasHome", (String)String.valueOf(hasHome)));
        installerResults.add(Common.build((String)"doesHomeExist", (String)String.valueOf(doesHomeExist)));
        installerResults.add(Common.build((String)"isHomeDirectory", (String)String.valueOf(isHomeDirectory)));
        installerResults.add(Common.build((String)"hasLibDirectory", (String)String.valueOf(hasLibDirectory)));
        boolean wereTheOpenEJBClassesInstalled = false;
        boolean wereTheEjbClassesInstalled = false;
        boolean wasOpenEJBStarted = false;
        boolean canILookupAnything = false;
        try {
            ClassLoader myLoader = this.getClass().getClassLoader();
            Class.forName("org.apache.openejb.OpenEJB", true, myLoader);
            wereTheOpenEJBClassesInstalled = true;
        }
        catch (Exception myLoader) {
            // empty catch block
        }
        try {
            Class.forName("javax.ejb.EJBHome", true, this.getClass().getClassLoader());
            wereTheEjbClassesInstalled = true;
        }
        catch (Exception myLoader) {
            // empty catch block
        }
        try {
            Class<?> openejb = Class.forName("org.apache.openejb.OpenEJB", true, this.getClass().getClassLoader());
            Method isInitialized = openejb.getDeclaredMethod("isInitialized", new Class[0]);
            wasOpenEJBStarted = (Boolean)isInitialized.invoke(openejb, new Object[0]);
        }
        catch (Exception openejb) {
            // empty catch block
        }
        try {
            Properties p = new Properties();
            p.put("java.naming.factory.initial", "org.apache.openejb.core.LocalInitialContextFactory");
            p.put("openejb.loader", "embed");
            InitialContext ctx = new InitialContext(p);
            Object obj = ctx.lookup("");
            if (obj.getClass().getName().equals("org.apache.openejb.core.ivm.naming.IvmContext")) {
                canILookupAnything = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        installerResults.add(Common.build((String)"wereTheOpenEJBClassesInstalled", (String)String.valueOf(wereTheOpenEJBClassesInstalled)));
        installerResults.add(Common.build((String)"wereTheEjbClassesInstalled", (String)String.valueOf(wereTheEjbClassesInstalled)));
        installerResults.add(Common.build((String)"wasOpenEJBStarted", (String)String.valueOf(wasOpenEJBStarted)));
        installerResults.add(Common.build((String)"canILookupAnything", (String)String.valueOf(canILookupAnything)));
        return installerResults;
    }
}

