/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.webapp.installer;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tomee.installer.Installer;
import org.apache.tomee.installer.InstallerInterface;
import org.apache.tomee.installer.Paths;
import org.apache.tomee.webapp.installer.Runner;

public class InstallerServlet
extends HttpServlet {
    private String escape(String str) {
        if (str == null) {
            return "";
        }
        return str.replaceAll("\"", "\\\\\"").replaceAll("\\\\", "\\\\\\\\");
    }

    private String getJsonList(List<Map<String, String>> list) {
        StringBuffer sb = new StringBuffer();
        for (Map<String, String> entry : list) {
            sb.append(String.format("{\"key\": \"%s\", \"value\": \"%s\"},", entry.get("key"), this.escape(entry.get("value"))));
        }
        if (!list.isEmpty()) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return "[" + sb.toString() + "]";
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletContext ctx = req.getServletContext();
        String rootPath = ctx.getRealPath("/");
        Runner installer = new Runner((InstallerInterface)new Installer(new Paths(new File(rootPath))));
        resp.setContentType("application/json");
        resp.getOutputStream().print(this.getJsonList(installer.execute(false)));
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletContext ctx = req.getServletContext();
        String rootPath = ctx.getRealPath("/");
        Runner installer = new Runner((InstallerInterface)new Installer(new Paths(new File(rootPath))));
        if (req.getParameter("catalinaBaseDir") != null && "".equals(req.getParameter("catalinaBaseDir").trim())) {
            installer.setCatalinaBaseDir(req.getParameter("catalinaBaseDir").trim());
        }
        if (req.getParameter("catalinaHome") != null && "".equals(req.getParameter("catalinaHome").trim())) {
            installer.setCatalinaHome(req.getParameter("catalinaHome").trim());
        }
        if (req.getParameter("serverXmlFile") != null && "".equals(req.getParameter("serverXmlFile").trim())) {
            installer.setServerXmlFile(req.getParameter("serverXmlFile").trim());
        }
        resp.setContentType("application/json");
        resp.getOutputStream().print(this.getJsonList(installer.execute(true)));
    }
}

